/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.turing_machine.driver;

import fr.univ_orleans.jdl.agc.I_Configuration;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.kernel.Signal_Machine;
import fr.univ_orleans.jdl.turing_machine.E_Undefined_Turing_Transition_Exception;
import fr.univ_orleans.jdl.turing_machine.TM_Transition_Abstract;
import fr.univ_orleans.jdl.turing_machine.Turing_Machine;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;

public abstract class Abstract_Turing_Machine_To_Signal_Machine
extends Signal_Machine {
    public static final Rational CONFIGURATION_LEFT_END_DEFAULT = Rational.ONE;
    public static final Rational CONFIGURATION_RIGHT_END_DEFAULT = Rational.ZERO;
    public static final Rational FACTOR_DEFAULT = Rational.ONE;
    public static final Rational FACTOR_MAXIMUM = Rational.ONE;
    public static final Rational SPEED_LEFT_DEFAULT = Rational.MINUS_ONE;
    public static final Rational SPEED_RIGHT_DEFAULT = SPEED_LEFT_DEFAULT.negate();
    public static final String STATE_MS_PREFIX_LEFT = "state_left_";
    public static final String STATE_MS_PREFIX_RIGHT = "state_right_";
    public static final String SYMBOL_MS_PREFIX = "symbol_";
    private final I_Meta_Signal[] a_ms_state_left;
    private final I_Meta_Signal[] a_ms_state_right;
    private final I_Meta_Signal[] a_ms_symbol;
    public final Rational factor;
    public final Rational speed_left;
    public final Rational speed_right;
    public final Turing_Machine tm;

    public Abstract_Turing_Machine_To_Signal_Machine(Turing_Machine tm) {
        this(tm, FACTOR_DEFAULT);
    }

    public Abstract_Turing_Machine_To_Signal_Machine(Turing_Machine tm, Rational factor) {
        this(tm, factor, SPEED_LEFT_DEFAULT, SPEED_RIGHT_DEFAULT);
    }

    public Abstract_Turing_Machine_To_Signal_Machine(Turing_Machine tm, Rational factor, Rational speed_left, Rational speed_right) {
        this.tm = tm;
        if (-1 != speed_left.signum()) {
            throw new IllegalArgumentException("Left speed should be negatiive " + speed_left);
        }
        if (1 != speed_right.signum()) {
            throw new IllegalArgumentException("Right speed should be positive " + speed_right);
        }
        this.speed_left = speed_left;
        this.speed_right = speed_right;
        if (FACTOR_MAXIMUM.compareTo(factor) <= 0 || factor.signum() <= 0) {
            factor = FACTOR_MAXIMUM;
        }
        this.factor = factor;
        this.a_ms_state_left = new I_Meta_Signal[tm.get_state_number()];
        this.a_ms_state_right = new I_Meta_Signal[tm.get_state_number()];
        this.a_ms_symbol = new I_Meta_Signal[tm.get_symbol_number()];
        int q = 0;
        while (q < tm.get_state_number()) {
            this.a_ms_state_right[q] = this.add_meta_signal(STATE_MS_PREFIX_RIGHT + q, this.speed_right, Color.RED);
            this.a_ms_state_left[q] = this.add_meta_signal(STATE_MS_PREFIX_LEFT + q, this.speed_left, Color.RED);
            ++q;
        }
        int a = 0;
        while (a < tm.get_symbol_number()) {
            this.a_ms_symbol[a] = this.add_meta_signal(SYMBOL_MS_PREFIX + a, 0, Color.BLUE);
            ++a;
        }
        q = 0;
        while (q < tm.get_state_number()) {
            int a2 = 0;
            while (a2 < tm.get_symbol_number()) {
                try {
                    TM_Transition_Abstract t = tm.get_transition(q, a2);
                    I_Meta_Signal ms_a = this.a_ms_symbol[a2];
                    I_Meta_Signal ms_a_out = this.a_ms_symbol[tm.extract_symbol_from_transition(t)];
                    int q_out = tm.extract_state_from_transition(t);
                    boolean go_right_from_transition = tm.extract_go_right_from_transition(t);
                    I_Meta_Signal mt_q_out = go_right_from_transition ? this.a_ms_state_right[q_out] : this.a_ms_state_left[q_out];
                    this.add_collision_rule(new I_Meta_Signal[]{this.a_ms_state_left[q], ms_a}, new I_Meta_Signal[]{mt_q_out, ms_a_out});
                    I_Meta_Signal q_right = this.a_ms_state_right[q];
                    this.add_collision_rule(new I_Meta_Signal[]{q_right, ms_a}, new I_Meta_Signal[]{mt_q_out, ms_a_out});
                }
                catch (E_Undefined_Turing_Transition_Exception e_Undefined_Turing_Transition_Exception) {
                    // empty catch block
                }
                ++a2;
            }
            ++q;
        }
    }

    public final I_Meta_Signal get_ms_state_left(int state) {
        return this.a_ms_state_left[state];
    }

    public final I_Meta_Signal get_ms_state_right(int state) {
        return this.a_ms_state_right[state];
    }

    public final I_Meta_Signal get_ms_symbol(int symbol) {
        return this.a_ms_symbol[symbol];
    }

    public void put_initial_signals(I_Configuration conf) {
        this.put_initial_signals(conf, CONFIGURATION_RIGHT_END_DEFAULT, CONFIGURATION_LEFT_END_DEFAULT);
    }

    public void put_initial_signals(I_Configuration conf, Rational left_end, Rational righ_end_or_step) {
        Rational sep = this.factor.compareTo(Rational.ONE) < 0 ? righ_end_or_step.subtract(left_end).multiply(Rational.ONE.subtract(this.factor)) : righ_end_or_step;
        conf.add_signal(this.a_ms_state_right[0], left_end.subtract(sep).divide(2L));
        Rational pos = left_end;
        for (int symbol : this.tm.get_tape()) {
            conf.add_signal(this.a_ms_symbol[symbol], pos);
            pos = Rational.ONE.add(pos.multiply(this.factor));
        }
    }
}

