/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.turing_machine.driver;

import fr.univ_orleans.jdl.turing_machine.Turing_Machine;
import fr.univ_orleans.jdl.util.File_Util;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class Turing_Machine_Reader {
    public static final String EXTENTION_TURING_MACHINE = ".tm";

    private Turing_Machine_Reader() {
    }

    private static int get_int(StreamTokenizer st) throws IOException {
        if (-2 != st.ttype) {
            throw new IOException("Number expected");
        }
        int n = (int)st.nval;
        st.nextToken();
        return n;
    }

    private static Turing_Machine read(Reader reader) throws IOException {
        StreamTokenizer st = new StreamTokenizer(reader);
        st.eolIsSignificant(false);
        int states = 0;
        int symbols = 0;
        try {
            st.nextToken();
            if (!st.sval.equalsIgnoreCase("states")) {
                throw new RuntimeException("states is not " + st.sval);
            }
            st.nextToken();
            states = Turing_Machine_Reader.get_int(st);
            if (!st.sval.equalsIgnoreCase("symbols")) {
                throw new RuntimeException("symbols is not " + st.sval);
            }
            st.nextToken();
            symbols = Turing_Machine_Reader.get_int(st);
        }
        catch (RuntimeException ioe) {
            System.err.println("File should start with:\nstate N\nsymbols M\n");
            throw ioe;
        }
        Turing_Machine tm = new Turing_Machine(states, symbols);
        while (st.ttype != -1) {
            if (st.sval != null && st.sval.equalsIgnoreCase("input")) break;
            int state_in = Turing_Machine_Reader.get_int(st);
            int symbol_in = Turing_Machine_Reader.get_int(st);
            int state_out = Turing_Machine_Reader.get_int(st);
            int symbol_out = Turing_Machine_Reader.get_int(st);
            boolean go_right = st.ttype == 43;
            st.nextToken();
            tm.set_transition(state_in, symbol_in, state_out, symbol_out, go_right);
        }
        st.nextToken();
        while (st.ttype != -1) {
            tm.add_to_tape(Turing_Machine_Reader.get_int(st));
        }
        return tm;
    }

    public static Turing_Machine read(String fileName) throws IOException {
        return Turing_Machine_Reader.read(new FileReader(File_Util.ensureSuffix(fileName, EXTENTION_TURING_MACHINE)));
    }
}

