/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.turing_machine.driver;

import fr.univ_orleans.jdl.turing_machine.TM_Configuration;
import fr.univ_orleans.jdl.turing_machine.TM_Transition_Abstract;
import fr.univ_orleans.jdl.turing_machine.Turing_Machine;
import fr.univ_orleans.jdl.util.File_Util;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class Turing_Machine_To_Latex {
    private static final String STRING_WRITING_LATEX_FILE_FAILED = "Writing latex file failed :\n";
    public static final String LATEX_TM_OUTPUT_SYMBOL = "\\TuringMachineOutputSYMBOL";
    public static final String LATEX_TM_OUTPUT_STATE = "\\TuringMachineOutputSTATE";
    private final Turing_Machine tm;
    private static final String unit_length = "1.25em";
    private static final double conf_sep = 2.0;
    private final StringWriter command_sw = new StringWriter();
    private final String[] symbol_latex_table;
    private final String[] state_latex_table;

    public Turing_Machine_To_Latex(Turing_Machine tm) {
        this.tm = tm;
        this.symbol_latex_table = new String[tm.get_symbol_number()];
        this.state_latex_table = new String[tm.get_state_number()];
        this.provide_command_symbols_states();
    }

    private void provide_command_symbols_states() {
        PrintWriter command_pw = new PrintWriter(this.command_sw);
        command_pw.println("%% STATES");
        int state = 0;
        while (state < this.tm.get_state_number()) {
            this.state_latex_table[state] = LATEX_TM_OUTPUT_STATE + this.to_letters(state);
            command_pw.printf("\\providecommand{%s}{%d} %% %d%n", this.state_latex_table[state], state, state);
            ++state;
        }
        command_pw.println("%% SYMBOLS");
        int symbol = 0;
        while (symbol < this.tm.get_symbol_number()) {
            this.symbol_latex_table[symbol] = LATEX_TM_OUTPUT_SYMBOL + this.to_letters(symbol);
            command_pw.printf("\\providecommand{%s}{%d} %% %d%n", this.symbol_latex_table[symbol], symbol, symbol);
            ++symbol;
        }
        command_pw.close();
    }

    public void set_state_latex(int state, String state_latex) {
        this.state_latex_table[state] = state_latex;
    }

    public void set_symbol_latex(int symbol, String symbol_latex) {
        this.symbol_latex_table[symbol] = symbol_latex;
    }

    private String to_letters(int v) {
        if (v == 0) {
            return "a";
        }
        StringBuilder result = new StringBuilder();
        while (v > 0) {
            result.insert(0, (char)(97 + v % 10));
            v /= 10;
        }
        return result.toString();
    }

    public void write_configuration(String file_name) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter fw = new FileWriter(File_Util.ensureSuffix(file_name, ".tex"));){
                fw.write(this.command_sw.toString());
                fw.write("%% CONFIGURATION\n");
                this.write_set_length(fw);
                this.write_core_configuration(fw);
                fw.write("}\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            System.err.println(STRING_WRITING_LATEX_FILE_FAILED + ioe);
        }
    }

    private void write_core_configuration(Writer fw) throws IOException {
        TM_Configuration tm_c = this.tm.get_configuration();
        int tape_length = tm_c.get_tape_length();
        fw.write("\\begin{picture}(" + (tape_length + 1) + ".5,1.7)(0,0)\n");
        fw.write("\\multiput(0,0)(0,1){2}{\\line(1,0){" + tape_length + "}}\n");
        fw.write("\\multiput(0,0)(1,0){" + (tape_length + 1) + "}{\\line(0,1){1}}\n");
        fw.write("\\put(.5,.2){%\n");
        int i = 0;
        for (int symbol : tm_c) {
            fw.write("  \\put(" + i + ",0){\\makebox[0mm]{" + this.symbol_latex_table[symbol] + "}}\n");
            ++i;
        }
        fw.write("\\put(" + tm_c.get_head_position() + ",-.35){\\makebox(0,0)[b]{" + this.state_latex_table[tm_c.get_state()] + "\\raisebox{.2em}{\\rule[-2em]{0em}{4em}}}}");
        fw.write("\\put(" + tape_length + ".3,0){\\makebox[0mm]{\\dots}}");
        fw.write("}%\n");
        fw.write("\\end{picture}\n");
    }

    public void write_run(String file_name, int nbr_transitions) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileWriter fw = new FileWriter(File_Util.ensureSuffix(file_name, ".tex"));){
                fw.write(this.command_sw.toString());
                fw.write("%% RUN\n");
                this.write_set_length(fw);
                StringWriter sw = new StringWriter();
                sw.write("\\put(0,0){%\n");
                this.write_core_configuration(sw);
                sw.write("}%\n");
                int i = 1;
                while (i <= nbr_transitions) {
                    this.tm.make_transition();
                    sw.write("\\put(0," + (double)i * 2.0 + "){%\n");
                    this.write_core_configuration(sw);
                    sw.write("}%\n");
                    ++i;
                }
                fw.write("\\begin{picture}(" + (this.tm.get_configuration().get_tape_length() + 2) + "," + ((double)nbr_transitions * 2.0 + 2.0) + ")(0,0)%\n");
                fw.write(sw.toString());
                fw.write("\\end{picture}\n");
                fw.write("}\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            System.err.println(STRING_WRITING_LATEX_FILE_FAILED + ioe);
        }
    }

    private void write_set_length(Writer w) throws IOException {
        w.write("{\\setlength{\\unitlength}{1.25em}\n");
    }

    public void write_transition_table(String file_name) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter fw = new FileWriter(File_Util.ensureSuffix(file_name, ".tex"));){
                fw.write(this.command_sw.toString());
                fw.write("%% TRANSITION TABLE\n");
                fw.write("\\providecommand{\\TMHeadingFont}[1]{\\textbf{#1}}\n");
                fw.write("\\begin{tabular}{|c|");
                int symbol = 0;
                while (symbol < this.tm.get_symbol_number()) {
                    fw.write("c|");
                    ++symbol;
                }
                fw.write("}\n\\hline\n state $\\backslash$ symbol");
                symbol = 0;
                while (symbol < this.tm.get_symbol_number()) {
                    fw.write(" & \\TMHeadingFont{" + this.symbol_latex_table[symbol] + "}");
                    ++symbol;
                }
                fw.write("\t\\\\\n\\hline\n");
                int state = 0;
                while (state < this.tm.get_state_number()) {
                    fw.write("\\TMHeadingFont{" + this.state_latex_table[state] + "} ");
                    int symbol2 = 0;
                    while (symbol2 < this.tm.get_symbol_number()) {
                        TM_Transition_Abstract tM_Transition_Abstract = this.tm.get_transition(state, symbol2);
                        if (tM_Transition_Abstract == null) {
                            fw.write(" &   -     ");
                        } else {
                            fw.write("& (" + this.state_latex_table[this.tm.extract_state_from_transition(tM_Transition_Abstract)] + "," + this.symbol_latex_table[this.tm.extract_symbol_from_transition(tM_Transition_Abstract)] + "," + (this.tm.extract_go_right_from_transition(tM_Transition_Abstract) ? "$\\rightarrow$" : "$\\leftarrow$") + ")");
                        }
                        ++symbol2;
                    }
                    fw.write("\t\\\\\n\\hline\n");
                    ++state;
                }
                fw.write("\\end{tabular}\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            System.err.println(STRING_WRITING_LATEX_FILE_FAILED + ioe);
        }
    }
}

