/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.turing_machine.driver;

import fr.univ_orleans.jdl.agc.I_Configuration;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.turing_machine.E_Undefined_Turing_Transition_Exception;
import fr.univ_orleans.jdl.turing_machine.TM_Transition_Abstract;
import fr.univ_orleans.jdl.turing_machine.Turing_Machine;
import fr.univ_orleans.jdl.turing_machine.driver.Abstract_Turing_Machine_To_Signal_Machine;
import fr.univ_orleans.jdl.util.Rational;

public class Turing_Machine_To_Signal_Machine
extends Abstract_Turing_Machine_To_Signal_Machine {
    public static final Rational CONFIGURATION_LEFT_END_DEFAULT = Rational.ONE;
    public static final Rational CONFIGURATION_RIGHT_END_DEFAULT = Rational.ZERO;
    public static final Rational FACTOR_MAXIMUM = Rational.ONE;
    public static final Rational FACTOR_DEFAULT = Rational.ONE;
    public static final Rational SPEED_STATE_RIGHT = Rational.ONE;
    public static final Rational SPEED_STATE_LEFT = SPEED_STATE_RIGHT.negate();
    public final I_Meta_Signal ms_right_end = this.add_meta_signal("right_end", 0);
    public final I_Meta_Signal ms_right_end_LL;
    public final I_Meta_Signal ms_right_end_R;
    public final I_Meta_Signal ms_right_end_RR;

    public Turing_Machine_To_Signal_Machine(Turing_Machine tm) {
        this(tm, FACTOR_DEFAULT);
    }

    public Turing_Machine_To_Signal_Machine(Turing_Machine tm, Rational factor) {
        super(tm, factor);
        if (FACTOR_MAXIMUM.compareTo(factor) <= 0 || factor.signum() <= 0) {
            factor = FACTOR_MAXIMUM;
        }
        Rational speed_catcher = new Rational(2L).add(factor).divide(factor);
        this.ms_right_end_LL = this.add_meta_signal("right_end_LL", speed_catcher.negate());
        this.ms_right_end_R = this.add_meta_signal("right_end_R", 1);
        this.ms_right_end_RR = this.add_meta_signal("right_end_RR", speed_catcher);
        int a = 0;
        while (a < tm.get_symbol_number()) {
            this.add_collision_rule(new I_Meta_Signal[]{this.get_ms_symbol(a), this.ms_right_end_LL}, new I_Meta_Signal[]{this.get_ms_symbol(a), this.ms_right_end_RR});
            ++a;
        }
        int q = 0;
        while (q < tm.get_state_number()) {
            int a2 = 0;
            while (a2 < tm.get_symbol_number()) {
                try {
                    TM_Transition_Abstract t = tm.get_transition(q, a2);
                    I_Meta_Signal ms_a = this.get_ms_symbol(a2);
                    I_Meta_Signal ms_a_out = this.get_ms_symbol(tm.extract_symbol_from_transition(t));
                    int q_out = tm.extract_state_from_transition(t);
                    boolean go_right_from_transition = tm.extract_go_right_from_transition(t);
                    I_Meta_Signal mt_q_out = go_right_from_transition ? this.get_ms_state_right(q_out) : this.get_ms_state_left(q_out);
                    this.add_collision_rule(new I_Meta_Signal[]{this.get_ms_state_left(q), ms_a}, new I_Meta_Signal[]{mt_q_out, ms_a_out});
                    I_Meta_Signal q_right = this.get_ms_state_right(q);
                    this.add_collision_rule(new I_Meta_Signal[]{q_right, ms_a}, new I_Meta_Signal[]{mt_q_out, ms_a_out});
                    if (a2 == 0) {
                        I_Meta_Signal[] mate_signal_out = go_right_from_transition ? new I_Meta_Signal[]{ms_a_out, mt_q_out, this.ms_right_end_LL} : new I_Meta_Signal[]{ms_a_out, mt_q_out, this.ms_right_end_LL, this.ms_right_end_R};
                        this.add_collision_rule(new I_Meta_Signal[]{q_right, this.ms_right_end}, mate_signal_out);
                        this.add_collision_rule(new I_Meta_Signal[]{q_right, this.ms_right_end_RR}, mate_signal_out);
                    }
                }
                catch (E_Undefined_Turing_Transition_Exception e_Undefined_Turing_Transition_Exception) {
                    // empty catch block
                }
                ++a2;
            }
            ++q;
        }
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_right_end_RR, this.ms_right_end_R}, new I_Meta_Signal[]{this.ms_right_end});
    }

    @Override
    public void put_initial_signals(I_Configuration conf, Rational left_end, Rational righ_end_or_step) {
        Rational sep = this.factor.compareTo(Rational.ONE) < 0 ? righ_end_or_step.subtract(left_end).multiply(Rational.ONE.subtract(this.factor)) : righ_end_or_step;
        conf.add_signal(this.get_ms_state_right(0), left_end.subtract(sep).divide(2L));
        Rational pos = left_end;
        for (int symbol : this.tm.get_tape()) {
            conf.add_signal(this.get_ms_symbol(symbol), pos);
            pos = Rational.ONE.add(pos.multiply(this.factor));
        }
        conf.add_signal(this.ms_right_end, pos);
    }
}

