/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.turing_machine.driver;

import fr.univ_orleans.jdl.agc.I_Configuration;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.turing_machine.TM_Transition_Abstract;
import fr.univ_orleans.jdl.turing_machine.Turing_Machine;
import fr.univ_orleans.jdl.turing_machine.driver.Abstract_Turing_Machine_To_Signal_Machine;
import fr.univ_orleans.jdl.util.Color_Constant;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;
import java.util.Arrays;

public class Turing_Machine_To_Signal_Machine_3_Any_Speed
extends Abstract_Turing_Machine_To_Signal_Machine {
    public static final String STATE_MS_PREFIX_MOTIONLESS = "state_";
    public static final Color color_enlarge = Color_Constant.get_color("darkGreen");
    private final I_Meta_Signal[] a_ms_state;
    public final I_Meta_Signal ms_border_left = this.add_meta_signal("border_left", 0);
    public final I_Meta_Signal ms_border_tape_right = this.add_meta_signal("border_tape_right", 0);
    public final I_Meta_Signal ms_border_pre_right = this.add_meta_signal("border_pre_right", 0, Color.GRAY);
    public final I_Meta_Signal ms_border_right = this.add_meta_signal("border_right", 0);
    public final I_Meta_Signal ms_enlarge_ok_l;
    public final I_Meta_Signal ms_enlarge_l;
    public final I_Meta_Signal ms_enlarge_top_r;
    public final I_Meta_Signal ms_enlarge_bottom_r;
    public final I_Meta_Signal ms_enlarge_back_ok_r;
    public final I_Meta_Signal ms_enlarge_back_l;
    public final I_Meta_Signal ms_enlarge_back_bottom_l;
    public final I_Meta_Signal ms_enlarge_back_top_l;
    public final I_Meta_Signal ms_enlarge_back_bottom_r;
    public final I_Meta_Signal ms_enlarge_back_top_r;
    public final I_Meta_Signal ms_enlarge_back_empty;
    private final I_Meta_Signal[] singals_added_left;
    private final I_Meta_Signal[] signals_added_right;
    private final I_Meta_Signal[] a_ms_symbol_left;

    public Turing_Machine_To_Signal_Machine_3_Any_Speed(Turing_Machine tm, Rational speed_left, Rational speed_right) {
        super(tm, Rational.ONE, speed_left, speed_right);
        this.ms_enlarge_ok_l = this.add_meta_signal("enlarge-ok-l", speed_left, color_enlarge);
        this.ms_enlarge_l = this.add_meta_signal("enlarge-l", speed_left, color_enlarge);
        this.ms_enlarge_bottom_r = this.add_meta_signal("enlarge-bottom-r", speed_right, color_enlarge);
        this.ms_enlarge_top_r = this.add_meta_signal("enlarge-top-r", speed_right, color_enlarge);
        this.singals_added_left = new I_Meta_Signal[]{this.ms_border_left};
        this.signals_added_right = new I_Meta_Signal[]{this.ms_border_tape_right, this.ms_border_pre_right, this.ms_border_right};
        this.ms_enlarge_back_l = this.add_meta_signal("enlarge-back-l", speed_left, color_enlarge);
        this.ms_enlarge_back_bottom_l = this.add_meta_signal("enlarge-back-bottom-l", speed_left, color_enlarge);
        this.ms_enlarge_back_top_l = this.add_meta_signal("enlarge-back-top-l", speed_left, color_enlarge);
        this.ms_enlarge_back_ok_r = this.add_meta_signal("enlarge-back-ok-r", speed_right, color_enlarge);
        this.ms_enlarge_back_top_r = this.add_meta_signal("enlarge-back-top-r", speed_right, color_enlarge);
        this.ms_enlarge_back_bottom_r = this.add_meta_signal("enlarge-back-bottom-r", speed_right, color_enlarge);
        this.ms_enlarge_back_empty = this.add_meta_signal("enlarge-back-empty", 0, color_enlarge);
        this.a_ms_state = new I_Meta_Signal[tm.get_state_number()];
        int q = 0;
        while (q < tm.get_state_number()) {
            this.a_ms_state[q] = this.add_meta_signal(STATE_MS_PREFIX_MOTIONLESS + q, 0, Color.RED);
            this.add_collision_rule(new I_Meta_Signal[]{this.get_ms_state_right(q), this.ms_border_tape_right}, new I_Meta_Signal[]{this.a_ms_state[q], this.ms_enlarge_bottom_r});
            this.add_collision_rule(new I_Meta_Signal[]{this.a_ms_state[q], this.ms_enlarge_l}, new I_Meta_Signal[]{this.ms_enlarge_top_r, this.a_ms_state[q]});
            boolean blank = false;
            if (tm.is_transition_defined(q, 0)) {
                TM_Transition_Abstract t = tm.get_transition(q, 0);
                I_Meta_Signal ms_a_out = this.get_ms_symbol(tm.extract_symbol_from_transition(t));
                int q_out = tm.extract_state_from_transition(t);
                boolean go_right_from_transition = tm.extract_go_right_from_transition(t);
                I_Meta_Signal mt_q_out = go_right_from_transition ? this.get_ms_state_right(q_out) : this.get_ms_state_left(q_out);
                this.add_collision_rule(new I_Meta_Signal[]{this.a_ms_state[q], this.ms_enlarge_ok_l}, new I_Meta_Signal[]{mt_q_out, ms_a_out});
                this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_back_empty, this.get_ms_state_left(q)}, new I_Meta_Signal[]{mt_q_out, ms_a_out});
            }
            ++q;
        }
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_bottom_r, this.ms_border_pre_right}, new I_Meta_Signal[]{this.ms_enlarge_l, this.ms_border_pre_right, this.ms_enlarge_bottom_r});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_bottom_r, this.ms_border_right}, new I_Meta_Signal[]{this.ms_enlarge_l, this.ms_border_right});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_top_r, this.ms_enlarge_ok_l}, new I_Meta_Signal[]{this.ms_enlarge_ok_l, this.ms_border_tape_right});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_border_pre_right, this.ms_enlarge_ok_l}, new I_Meta_Signal[]{this.ms_border_tape_right, this.ms_enlarge_ok_l});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_top_r, this.ms_enlarge_l}, new I_Meta_Signal[]{this.ms_enlarge_ok_l, this.ms_border_pre_right});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_border_pre_right, this.ms_enlarge_l}, new I_Meta_Signal[]{this.ms_enlarge_ok_l, this.ms_border_pre_right});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_top_r, this.ms_border_pre_right, this.ms_enlarge_l}, new I_Meta_Signal[]{this.ms_enlarge_back_l, this.ms_border_pre_right});
        this.a_ms_symbol_left = new I_Meta_Signal[tm.get_symbol_number()];
        int i = 0;
        while (i < tm.get_symbol_number()) {
            I_Meta_Signal ms_l;
            this.a_ms_symbol_left[i] = ms_l = this.add_meta_signal("symbol_" + i + "-l", speed_left);
            this.generate_enlarge_backup_rules(this.get_ms_symbol(i), ms_l);
            this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_back_empty, ms_l}, new I_Meta_Signal[]{this.get_ms_symbol(i)});
            ++i;
        }
        i = 0;
        while (i < tm.get_state_number()) {
            this.generate_enlarge_backup_rules(this.get_ms_state(i), this.get_ms_state_left(i));
            this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_back_ok_r, this.get_ms_state(i)}, new I_Meta_Signal[]{this.get_ms_state_left(i), this.ms_border_tape_right});
            ++i;
        }
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_border_left, this.ms_enlarge_back_bottom_l}, new I_Meta_Signal[]{this.ms_border_left, this.ms_enlarge_back_top_r});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_back_bottom_r, this.ms_border_pre_right}, new I_Meta_Signal[]{this.ms_enlarge_back_top_l, this.ms_border_pre_right});
        this.generate_enlarge_backup_rules(this.ms_border_tape_right, this.ms_enlarge_ok_l);
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_back_ok_r, this.ms_border_pre_right}, new I_Meta_Signal[]{this.ms_enlarge_ok_l, this.ms_border_pre_right});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_border_left, this.ms_enlarge_back_l}, new I_Meta_Signal[]{this.ms_border_left});
    }

    private void generate_enlarge_backup_rules(I_Meta_Signal ms, I_Meta_Signal ms_l) {
        this.add_collision_rule(new I_Meta_Signal[]{ms, this.ms_enlarge_back_l}, new I_Meta_Signal[]{this.ms_enlarge_back_bottom_l, ms, this.ms_enlarge_back_bottom_r});
        this.add_collision_rule(new I_Meta_Signal[]{ms, this.ms_enlarge_back_bottom_l}, new I_Meta_Signal[]{ms, this.ms_enlarge_back_top_r});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_back_bottom_r, ms}, new I_Meta_Signal[]{this.ms_enlarge_back_top_l, ms});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_back_top_r, this.ms_enlarge_back_top_l}, new I_Meta_Signal[]{this.ms_enlarge_back_empty, this.ms_enlarge_back_ok_r});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_back_ok_r, ms}, new I_Meta_Signal[]{ms_l, this.ms_enlarge_back_empty, this.ms_enlarge_back_ok_r});
        this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_back_top_r, ms, this.ms_enlarge_back_top_l}, new I_Meta_Signal[]{this.ms_enlarge_back_l, ms});
    }

    public final I_Meta_Signal get_ms_state(int state) {
        return this.a_ms_state[state];
    }

    @Override
    public void put_initial_signals(I_Configuration conf, Rational left_end, Rational righ_end_or_step) {
        this.put_initial_signals(conf, new Rational[]{CONFIGURATION_RIGHT_END_DEFAULT, CONFIGURATION_LEFT_END_DEFAULT});
    }

    public void put_initial_signals(I_Configuration conf, Rational[] positions) {
        if (positions == null || positions.length < 2) {
            throw new IllegalArgumentException("There should be at least two positions");
        }
        int i = 0;
        while (i < positions.length - 1) {
            if (positions[i].compareTo(positions[i + 1]) >= 0) {
                throw new IllegalArgumentException("Positions should be increasing [" + i + "]->" + positions[i] + " [" + (i + 1) + "]->" + positions[i + 1]);
            }
            ++i;
        }
        int size_min = this.singals_added_left.length + this.signals_added_right.length + this.tm.get_tape().size() + 1;
        if (positions.length < size_min) {
            Rational[] positions_new = Arrays.copyOf(positions, positions.length);
            Rational positions_penultimate = positions[positions.length - 2];
            Rational positions_delta = positions[positions.length - 1].subtract(positions_penultimate).divide(1 + positions_new.length - positions.length);
            int i2 = positions.length - 1;
            while (i2 < positions_new.length) {
                positions_new[i2] = positions_penultimate.add(positions_delta.multiply(i2 + 2 - positions.length));
                ++i2;
            }
            positions = positions_new;
        }
        int i3 = 0;
        I_Meta_Signal[] i_Meta_SignalArray = this.singals_added_left;
        int n = this.singals_added_left.length;
        int n2 = 0;
        while (n2 < n) {
            I_Meta_Signal ms = i_Meta_SignalArray[n2];
            conf.add_signal(ms, positions[i3++]);
            ++n2;
        }
        conf.add_signal(this.get_ms_state_right(0), positions[i3++]);
        for (int s : this.tm.get_tape()) {
            conf.add_signal(this.get_ms_symbol(s), positions[i3++]);
        }
        i_Meta_SignalArray = this.signals_added_right;
        n = this.signals_added_right.length;
        int n3 = 0;
        while (n3 < n) {
            I_Meta_Signal ms = i_Meta_SignalArray[n3];
            conf.add_signal(ms, positions[i3++]);
            ++n3;
        }
    }
}

