/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.turing_machine.driver;

import fr.univ_orleans.jdl.agc.I_Configuration;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.turing_machine.E_Undefined_Turing_Transition_Exception;
import fr.univ_orleans.jdl.turing_machine.TM_Transition_Abstract;
import fr.univ_orleans.jdl.turing_machine.Turing_Machine;
import fr.univ_orleans.jdl.turing_machine.driver.Abstract_Turing_Machine_To_Signal_Machine;
import fr.univ_orleans.jdl.util.Rational;

public class Turing_Machine_To_Signal_Machine_3_Speed
extends Abstract_Turing_Machine_To_Signal_Machine {
    public static final String STATE_MS_PREFIX_MOTIONLESS = "state_";
    public static final Rational GOLDEN_RATIO_APPROX = new Rational(1618033989L, 1000000000L);
    public final I_Meta_Signal ms_border = this.add_meta_signal("border", 0);
    public final I_Meta_Signal ms_enlarge_ll = this.add_meta_signal("enlarge-ll", -1);
    public final I_Meta_Signal ms_enlarge_l = this.add_meta_signal("enlarge-l", -1);
    public final I_Meta_Signal ms_enlarge_r = this.add_meta_signal("enlarge-r", 1);
    private final I_Meta_Signal[] a_ms_state;

    public Turing_Machine_To_Signal_Machine_3_Speed(Turing_Machine tm) {
        super(tm, Rational.ONE);
        this.a_ms_state = new I_Meta_Signal[tm.get_state_number()];
        int q = 0;
        while (q < tm.get_state_number()) {
            this.a_ms_state[q] = this.add_meta_signal(STATE_MS_PREFIX_MOTIONLESS + q, 0);
            this.add_collision_rule(new I_Meta_Signal[]{this.get_ms_state_right(q), this.ms_border}, new I_Meta_Signal[]{this.ms_enlarge_ll, this.a_ms_state[q]});
            this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_r, this.a_ms_state[q]}, new I_Meta_Signal[]{this.get_ms_state_left(q), this.ms_border});
            try {
                boolean empty = false;
                TM_Transition_Abstract t = tm.get_transition(q, 0);
                I_Meta_Signal ms_a_out = this.get_ms_symbol(tm.extract_symbol_from_transition(t));
                int q_out = tm.extract_state_from_transition(t);
                boolean go_right_from_transition = tm.extract_go_right_from_transition(t);
                I_Meta_Signal mt_q_out = go_right_from_transition ? this.get_ms_state_right(q_out) : this.get_ms_state_left(q_out);
                this.add_collision_rule(new I_Meta_Signal[]{this.ms_enlarge_r, this.get_ms_state_left(q)}, new I_Meta_Signal[]{mt_q_out, ms_a_out});
            }
            catch (E_Undefined_Turing_Transition_Exception e_Undefined_Turing_Transition_Exception) {
                // empty catch block
            }
            ++q;
        }
        int a = 0;
        while (a < tm.get_symbol_number()) {
            this.add_collision_rule(new I_Meta_Signal[]{this.get_ms_symbol(a), this.ms_enlarge_ll}, new I_Meta_Signal[]{this.ms_enlarge_l, this.get_ms_symbol(a), this.ms_enlarge_r});
            this.add_collision_rule(new I_Meta_Signal[]{this.get_ms_symbol(a), this.ms_enlarge_l}, new I_Meta_Signal[]{this.get_ms_symbol(a), this.ms_enlarge_r});
            ++a;
        }
    }

    public final I_Meta_Signal get_ms_state(int state) {
        return this.a_ms_state[state];
    }

    @Override
    public void put_initial_signals(I_Configuration conf, Rational left_end, Rational righ_end_or_step) {
        if (righ_end_or_step.is_negative()) {
            int nb_intercell_space = this.tm.get_tape().size();
            super.put_initial_signals(conf, left_end, righ_end_or_step.multiply(nb_intercell_space).divide(GOLDEN_RATIO_APPROX.add(nb_intercell_space)));
            conf.add_signal(this.ms_border, righ_end_or_step.negate());
        } else {
            super.put_initial_signals(conf, left_end, righ_end_or_step);
            conf.add_signal(this.ms_border, conf.get_rightmost_position().add(righ_end_or_step.multiply(GOLDEN_RATIO_APPROX)));
        }
    }
}

