/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.util;

import java.awt.Color;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Color_Constant {
    public static final Color COLOR_DEFAULT = Color.black;
    static final Pattern PATTERN_COLOR_RGB_1 = Pattern.compile("(rgb)\\((\\d*),(\\d*),(\\d*)\\)");
    static final Pattern PATTERN_COLOR_RGB_2 = Pattern.compile("java\\.awt\\.color\\[r=(\\d*),g=(\\d*),b=(\\d*)\\]");
    private static final Map<String, Color> name_to_color = Map.ofEntries(Map.entry("black", Color.BLACK), Map.entry("red", Color.RED), Map.entry("darkred", new Color(190, 0, 0)), Map.entry("darkorange", new Color(255, 128, 0)), Map.entry("magenta", Color.MAGENTA), Map.entry("blue", Color.BLUE), Map.entry("darkblue", new Color(0, 0, 200)), Map.entry("cyan", Color.CYAN), Map.entry("darkCyan", new Color(0, 200, 200)), Map.entry("gray", Color.GRAY), Map.entry("yellow", Color.YELLOW), Map.entry("darkyellow", new Color(224, 236, 20)), Map.entry("orange", Color.ORANGE), Map.entry("purple", new Color(255, 0, 255)), Map.entry("darkgray", Color.DARK_GRAY), Map.entry("green", Color.GREEN), Map.entry("darkgreen", new Color(0.0f, 0.7f, 0.0f)), Map.entry("verydarkgreen", new Color(0.0f, 0.55f, 0.0f)), Map.entry("ultradarkgreen", new Color(0.0f, 0.35f, 0.0f)), Map.entry("brown", new Color(165, 42, 42)), Map.entry("darkbrown", new Color(139, 69, 19)), Map.entry("darkpurple", new Color(0.55f, 0.0f, 0.55f)), Map.entry("deeppurple", new Color(0.55f, 0.0f, 0.55f)), Map.entry("white", new Color(1.0f, 1.0f, 1.0f)), Map.entry("pink", new Color(255, 192, 203)), Map.entry("darkpink", new Color(240, 130, 160)), Map.entry("deeppink", new Color(238, 18, 137)));

    private Color_Constant() {
        throw new IllegalStateException("Color_Constant");
    }

    public static Color get_color(String code) {
        assert (code != null);
        String code_lc = code.toLowerCase();
        Color c = name_to_color.get(code_lc);
        if (c != null) {
            return c;
        }
        Matcher m = PATTERN_COLOR_RGB_1.matcher(code_lc);
        if (m.matches()) {
            return new Color(Integer.valueOf(m.group(2)), Integer.valueOf(m.group(3)), Integer.valueOf(m.group(4)));
        }
        m = PATTERN_COLOR_RGB_2.matcher(code_lc);
        if (m.matches()) {
            return new Color(Integer.valueOf(m.group(1)), Integer.valueOf(m.group(2)), Integer.valueOf(m.group(3)));
        }
        c = Color.getColor(code);
        return c == null ? COLOR_DEFAULT : c;
    }
}

