/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.util;

import fr.univ_orleans.jdl.util.Field;
import java.math.BigInteger;

public final class Rational
implements Field<Rational> {
    private static final String STRING_DIVISION_BY_0 = "Division by 0";
    private static final BigInteger _BI_MINUS_ONE = BigInteger.valueOf(-1L);
    private static final BigInteger _BI_ONE = BigInteger.ONE;
    private static final BigInteger _BI_ZERO = BigInteger.ZERO;
    public static final Rational PLUS_INFINITY = new Rational(_BI_ONE, _BI_ZERO, true);
    public static final Rational MINUS_INFINITY = new Rational(_BI_MINUS_ONE, _BI_ZERO, true);
    public static final Rational UNDEFINED = new Rational(_BI_ZERO, _BI_ZERO, true);
    public static final String RATIONAL_REG_EXP = "(?:|-)(?:0|[1-9][0-9]*)(?:| */ *(?:|-)[1-9][0-9]*)";
    public static final Rational ZERO = new Rational(_BI_ZERO, _BI_ONE, true);
    public static final Rational TWO = new Rational(2L);
    public static final Rational MINUS_ONE = new Rational(_BI_MINUS_ONE, _BI_ONE, true);
    public static final Rational ONE = new Rational(_BI_ONE, _BI_ONE, true);
    private final BigInteger p;
    private final BigInteger q;

    public static Rational max(Rational r1, Rational r2) {
        return r1.compareTo(r2) < 0 ? r2 : r1;
    }

    public static Rational min(Rational r1, Rational r2) {
        return r1.compareTo(r2) < 0 ? r1 : r2;
    }

    public static Rational value_of(String str) {
        if (str.equals("UNDEFINED")) {
            return UNDEFINED;
        }
        if (str.equals("PLUS_INFINITY")) {
            return PLUS_INFINITY;
        }
        if (str.equals("MINUS_INFINITY")) {
            return MINUS_INFINITY;
        }
        int pos_bar = str.indexOf(47);
        if (-1 != pos_bar) {
            return new Rational(new BigInteger(str.substring(0, pos_bar).trim()), new BigInteger(str.substring(pos_bar + 1).trim()));
        }
        int pos_point = str.indexOf(46);
        if (-1 == pos_point) {
            return new Rational(new BigInteger(str.trim()), _BI_ONE);
        }
        String decimal_part = str.substring(pos_point + 1).trim();
        return new Rational(new BigInteger(String.valueOf(str.substring(0, pos_point).trim()) + decimal_part), BigInteger.TEN.pow(decimal_part.length()));
    }

    public Rational(BigInteger p) {
        this(p, BigInteger.ONE, true);
    }

    public Rational(BigInteger p, BigInteger q) {
        this(p, q, false);
    }

    private Rational(BigInteger p, BigInteger q, boolean is_already_simplified) {
        if (!is_already_simplified) {
            if (BigInteger.ZERO.equals(q)) {
                throw new IllegalArgumentException(STRING_DIVISION_BY_0);
            }
            if (q.signum() == -1) {
                p = p.negate();
                q = q.negate();
            }
            if (!this.is_special()) {
                if (q.signum() == 0) {
                    throw new IllegalArgumentException(" Denominator is zero");
                }
                if (p.signum() == 0) {
                    q = _BI_ONE;
                } else {
                    BigInteger gcd = p.gcd(q);
                    p = p.divide(gcd);
                    q = q.divide(gcd);
                }
            }
        }
        this.p = p;
        this.q = q;
    }

    public Rational(long n) {
        this(BigInteger.valueOf(n));
    }

    public Rational(long p, long q) {
        this(BigInteger.valueOf(q < 0L ? -p : p), BigInteger.valueOf(q < 0L ? -q : q));
    }

    public Rational abs() {
        if (this == UNDEFINED || this == PLUS_INFINITY) {
            return this;
        }
        if (this == MINUS_INFINITY) {
            return PLUS_INFINITY;
        }
        return new Rational(this.p.abs(), this.q, true);
    }

    @Override
    public Rational add(BigInteger bi) {
        if (this.is_special()) {
            return this;
        }
        return new Rational(this.p.add(bi.multiply(this.q)), this.q);
    }

    @Override
    public Rational add(long n) {
        if (this.is_special()) {
            return this;
        }
        return new Rational(this.p.add(this.q.multiply(BigInteger.valueOf(n))), this.q);
    }

    public Rational add(long pp, long qq) {
        if (0L == qq) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        if (this.is_special()) {
            return this;
        }
        BigInteger qq_bi = BigInteger.valueOf(qq);
        return new Rational(this.p.multiply(qq_bi).add(this.q.multiply(BigInteger.valueOf(pp))), this.q.multiply(qq_bi));
    }

    @Override
    public Rational add(Rational r) {
        if (this == PLUS_INFINITY && r == PLUS_INFINITY) {
            return PLUS_INFINITY;
        }
        if (this == MINUS_INFINITY && r == MINUS_INFINITY) {
            return MINUS_INFINITY;
        }
        if (this == PLUS_INFINITY && r == MINUS_INFINITY || this == MINUS_INFINITY && r == PLUS_INFINITY || this == UNDEFINED || r == UNDEFINED) {
            return UNDEFINED;
        }
        if (this.is_special()) {
            return this;
        }
        if (r.is_special()) {
            return r;
        }
        return new Rational(this.p.multiply(r.q).add(this.q.multiply(r.p)), this.q.multiply(r.q));
    }

    public double approx() {
        if (this == MINUS_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this == PLUS_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (this == UNDEFINED) {
            return Double.NaN;
        }
        return this.p.doubleValue() / this.q.doubleValue();
    }

    public BigInteger ceil() {
        if (this.is_special()) {
            return null;
        }
        BigInteger[] res = this.p.divideAndRemainder(this.q);
        return -1 != this.signum() || BigInteger.ZERO.equals(res[1]) ? res[0].add(_BI_ONE) : res[0];
    }

    @Override
    public int compareTo(BigInteger bi) {
        if (this == UNDEFINED || this == PLUS_INFINITY) {
            return 1;
        }
        if (this == MINUS_INFINITY) {
            return -1;
        }
        return this.p.compareTo(bi.multiply(this.q));
    }

    @Override
    public int compareTo(Rational r) {
        if (this.is_special()) {
            if (this == r) {
                return 0;
            }
            if (this == MINUS_INFINITY) {
                return -1;
            }
            if (this == PLUS_INFINITY) {
                return 1;
            }
            return r == PLUS_INFINITY ? -1 : 1;
        }
        if (r.is_special()) {
            return -r.compareTo(this);
        }
        return this.p.multiply(r.q).compareTo(r.p.multiply(this.q));
    }

    @Override
    public Rational divide(BigInteger bi) {
        if (this.is_special()) {
            switch (bi.signum()) {
                case 1: {
                    return this;
                }
                case -1: {
                    if (this == PLUS_INFINITY) {
                        return MINUS_INFINITY;
                    }
                    if (this == MINUS_INFINITY) {
                        return PLUS_INFINITY;
                    }
                    return UNDEFINED;
                }
            }
            return UNDEFINED;
        }
        if (bi.signum() == 0) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        return new Rational(this.p, this.q.multiply(bi));
    }

    @Override
    public Rational divide(long div) {
        if (this.is_special()) {
            if (div == 0L) {
                return UNDEFINED;
            }
            if (div < 0L) {
                if (this == PLUS_INFINITY) {
                    return MINUS_INFINITY;
                }
                if (this == MINUS_INFINITY) {
                    return PLUS_INFINITY;
                }
            }
            return this;
        }
        if (div == 0L) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        return new Rational(this.p, this.q.multiply(BigInteger.valueOf(div)));
    }

    @Override
    public Rational divide(Rational rat) {
        if (this.is_special() && rat.is_special() || this == UNDEFINED || rat == UNDEFINED) {
            return UNDEFINED;
        }
        if (rat.is_special()) {
            return ZERO;
        }
        if (rat.is_zero()) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        if (this.is_special()) {
            if (rat.signum() > 0) {
                return this;
            }
            return this.negate();
        }
        return new Rational(this.p.multiply(rat.q), this.q.multiply(rat.p));
    }

    public boolean equals(BigInteger bi) {
        if (this.is_special() || bi == null) {
            return false;
        }
        return this.p.equals(this.q.multiply(bi));
    }

    public boolean equals(Object o) {
        if (o instanceof BigInteger) {
            return this.equals((BigInteger)o);
        }
        return this.equals((Rational)o);
    }

    public boolean equals(Rational r) {
        if (r == null) {
            return false;
        }
        if (this.is_special()) {
            return this == r;
        }
        return this.p.multiply(r.q).equals(r.p.multiply(this.q));
    }

    public BigInteger floor() {
        if (this.is_special()) {
            return null;
        }
        BigInteger[] res = this.p.divideAndRemainder(this.q);
        return -1 != this.signum() || BigInteger.ZERO.equals(res[1]) ? res[0] : res[0].add(_BI_MINUS_ONE);
    }

    public BigInteger get_denominator() {
        return this.q;
    }

    public BigInteger get_numerator() {
        return this.p;
    }

    public int hashCode() {
        return this.p.hashCode() * this.q.hashCode();
    }

    @Override
    public Rational inverse() {
        if (this == UNDEFINED) {
            return UNDEFINED;
        }
        if (this == PLUS_INFINITY || this == MINUS_INFINITY) {
            return ZERO;
        }
        if (_BI_ZERO.equals(this.p)) {
            return PLUS_INFINITY;
        }
        if (this.is_zero()) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        return new Rational(this.q, this.p);
    }

    public boolean is_integral() {
        return BigInteger.ONE.equals(this.q);
    }

    public boolean is_negative() {
        return this.p.signum() == -1;
    }

    public boolean is_positive() {
        return this.p.signum() == 1;
    }

    public boolean is_special() {
        return this == PLUS_INFINITY || this == MINUS_INFINITY || this == UNDEFINED;
    }

    public boolean is_zero() {
        return this.p.signum() == 0;
    }

    public boolean lt(Rational rat) {
        return this.compareTo(rat) < 0;
    }

    public boolean le(Rational rat) {
        return this.compareTo(rat) <= 0;
    }

    public Rational mod(BigInteger divisor) {
        if (this.is_special()) {
            return UNDEFINED;
        }
        if (divisor.signum() == 0) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        if (divisor.signum() < 0) {
            throw new IllegalArgumentException("mod should have a positive left argument " + divisor);
        }
        return new Rational(this.p.mod(this.q.multiply(divisor)), this.q);
    }

    public Rational mod(Rational divisor) {
        if (this.is_special() || divisor.is_special()) {
            return UNDEFINED;
        }
        if (divisor.is_zero()) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        return new Rational(this.p.multiply(divisor.q).mod(this.q.multiply(divisor.p)), this.q.multiply(divisor.q));
    }

    @Override
    public Rational multiply(BigInteger bi) {
        if (this.is_special()) {
            switch (bi.signum()) {
                case 1: {
                    return this;
                }
                case -1: {
                    if (this == PLUS_INFINITY) {
                        return MINUS_INFINITY;
                    }
                    if (this == MINUS_INFINITY) {
                        return PLUS_INFINITY;
                    }
                    return UNDEFINED;
                }
            }
            return UNDEFINED;
        }
        return new Rational(this.p.multiply(bi), this.q);
    }

    @Override
    public Rational multiply(long n) {
        if (this.is_special()) {
            if (n < 0L) {
                if (this == MINUS_INFINITY) {
                    return PLUS_INFINITY;
                }
                if (this == PLUS_INFINITY) {
                    return MINUS_INFINITY;
                }
            } else if (n == 0L) {
                return UNDEFINED;
            }
            return this;
        }
        return new Rational(this.p.multiply(BigInteger.valueOf(n)), this.q);
    }

    public Rational multiply(long pp, long qq) {
        if (this == UNDEFINED) {
            return UNDEFINED;
        }
        if (this == PLUS_INFINITY || this == MINUS_INFINITY) {
            if (0L == pp || 0L == qq) {
                return UNDEFINED;
            }
            if (0L < pp == 0L < qq) {
                return this;
            }
            return this == PLUS_INFINITY ? MINUS_INFINITY : PLUS_INFINITY;
        }
        if (qq == 0L) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        return new Rational(this.p.multiply(BigInteger.valueOf(pp)), this.q.multiply(BigInteger.valueOf(qq)));
    }

    @Override
    public Rational multiply(Rational rat) {
        if (this == UNDEFINED || rat == UNDEFINED) {
            return UNDEFINED;
        }
        if (this.is_special() && rat.is_special()) {
            if (this == PLUS_INFINITY && rat == PLUS_INFINITY || this == MINUS_INFINITY && rat == MINUS_INFINITY) {
                return PLUS_INFINITY;
            }
            return MINUS_INFINITY;
        }
        if (this.is_special()) {
            if (rat.signum() > 0) {
                return this;
            }
            if (this == PLUS_INFINITY) {
                return MINUS_INFINITY;
            }
            return PLUS_INFINITY;
        }
        if (rat.is_special()) {
            if (this.signum() > 0) {
                return rat;
            }
            if (rat == PLUS_INFINITY) {
                return MINUS_INFINITY;
            }
            return PLUS_INFINITY;
        }
        return new Rational(this.p.multiply(rat.p), this.q.multiply(rat.q));
    }

    @Override
    public Rational negate() {
        return new Rational(this.p.negate(), this.q, true);
    }

    public Rational pow(int exponent) {
        if (this.is_special()) {
            if (this == UNDEFINED || exponent == 0) {
                return UNDEFINED;
            }
            if (exponent < 0) {
                return ZERO;
            }
            if (this == MINUS_INFINITY && exponent % 2 != 0) {
                return MINUS_INFINITY;
            }
            return PLUS_INFINITY;
        }
        return new Rational(this.p.pow(exponent), this.q.pow(exponent));
    }

    public Rational remainder(BigInteger divisor) {
        if (this.is_special()) {
            return UNDEFINED;
        }
        if (divisor.signum() == 0) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        if (divisor.signum() > 0) {
            return new Rational(this.p.remainder(this.q.multiply(divisor)), this.q);
        }
        return new Rational(this.p.remainder(this.q.multiply(divisor).negate()), this.q);
    }

    public Rational remainder(Rational divisor) {
        if (this.is_special() || divisor.is_special()) {
            return UNDEFINED;
        }
        if (divisor.is_zero()) {
            throw new IllegalArgumentException(STRING_DIVISION_BY_0);
        }
        return new Rational(this.p.multiply(divisor.q).remainder(this.q.multiply(divisor.p)), this.q.multiply(divisor.q));
    }

    public long round() {
        if (this.is_special()) {
            throw new IllegalCallerException("Special rational have no round");
        }
        return Math.round(this.approx());
    }

    public BigInteger round_to_zero_bi() {
        if (this.is_special()) {
            throw new IllegalCallerException("Special rational have no round");
        }
        return this.p.divide(this.q);
    }

    public int signum() {
        if (this == UNDEFINED) {
            return 1;
        }
        return this.p.signum();
    }

    @Override
    public Rational subtract(BigInteger bi) {
        if (this.is_special()) {
            return this;
        }
        return new Rational(this.p.subtract(bi.multiply(this.q)), this.q);
    }

    @Override
    public Rational subtract(Rational rat) {
        if (this == UNDEFINED || rat == UNDEFINED) {
            return UNDEFINED;
        }
        if (this == PLUS_INFINITY && rat == MINUS_INFINITY) {
            return PLUS_INFINITY;
        }
        if (this == MINUS_INFINITY && rat == PLUS_INFINITY) {
            return MINUS_INFINITY;
        }
        if (this == PLUS_INFINITY && rat == PLUS_INFINITY || this == MINUS_INFINITY && rat == MINUS_INFINITY) {
            return UNDEFINED;
        }
        if (this.is_special()) {
            return this;
        }
        if (rat.is_special()) {
            return rat.negate();
        }
        return new Rational(this.p.multiply(rat.q).subtract(this.q.multiply(rat.p)), this.q.multiply(rat.q));
    }

    public String toString() {
        return this.toString("/");
    }

    public String toString(String op) {
        if (UNDEFINED == this) {
            return "UNDEFINED";
        }
        if (MINUS_INFINITY == this) {
            return "MINUS_INFINITY";
        }
        if (PLUS_INFINITY == this) {
            return "PLUS_INFINITY";
        }
        if (this.q.equals(BigInteger.ONE)) {
            return this.p.toString();
        }
        return this.p + op + this.q;
    }
}

