/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.util;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Tree_Linked_List<T>
implements Iterable<T> {
    private Node root;
    private Node first;
    private Node last;
    private int size = 0;
    private final Comparator<T> comp;

    public Tree_Linked_List(Comparator<T> comp) {
        this.comp = comp;
    }

    public Node add(T value) {
        if (value == null) {
            return null;
        }
        if (this.root == null) {
            this.last = this.root = new Node(value, null, null, null, null, null);
            this.first = this.root;
            return this.root;
        }
        Node result = this.root.add(value);
        assert (this.test_equilibrium_order_link());
        return result;
    }

    public void clear() {
        Node node = this.get_first_location();
        while (node != null) {
            Node next = node.next;
            assert (node.left == null);
            if (node.father != null) {
                if (node == node.father.left) {
                    node.father.left = node.right;
                }
                if (node == node.father.right) {
                    node.father.right = node.right;
                }
                if (node.right != null) {
                    node.right.father = node.father;
                    node.father.left = node.right;
                }
                node.father = null;
            } else if (node.right != null) {
                node.right.father = null;
                this.root = node.right;
            }
            node.left = null;
            node.right = null;
            node.remove_from_chain();
            node = next;
        }
        this.last = null;
        this.first = null;
        this.root = null;
        this.size = 0;
    }

    public Comparator<T> get_comparator() {
        return this.comp;
    }

    public T get_first() {
        return this.first == null ? null : (T)this.first.value;
    }

    public Node get_first_location() {
        return this.first;
    }

    public T get_last() {
        return this.last == null ? null : (T)this.last.value;
    }

    public Node get_last_location() {
        return this.last;
    }

    public Node get_location_after(Node location) {
        return location == null ? null : location.next;
    }

    public Node get_location_before(Node location) {
        return location == null ? null : location.previous;
    }

    public Iterable<T> get_safe_iterator() {
        return () -> new TLLIterator(false);
    }

    public int get_size() {
        return this.size;
    }

    public T get_value(Node location) {
        if (location == null || !location.is_in_structure) {
            throw new IllegalArgumentException("Illegal location: " + location);
        }
        return location.get_value();
    }

    public T get_value_after(Node location) {
        Node loc = this.get_location_after(location);
        return loc == null ? null : (T)loc.get_value();
    }

    public T get_value_after(T val) {
        return (T)this.get_value_after((T)this.locate(val));
    }

    public T get_value_before(Node location) {
        Node loc = this.get_location_before(location);
        assert (loc == null || loc.is_coherent(true, true));
        return loc == null ? null : (T)loc.get_value();
    }

    public T get_value_before(T val) {
        return (T)this.get_value_before((T)this.locate(val));
    }

    public boolean is_empty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new TLLIterator(true);
    }

    public Node locate(T value) {
        return this.root == null ? null : this.root.locate(value);
    }

    public void print_v_tree(PrintStream ps) {
        if (this.root == null) {
            ps.println("Empty tree");
        } else {
            this.root.print_tree_vertical(ps, "");
        }
    }

    public void remove(Node location) {
        if (location != null) {
            location.remove();
        }
    }

    public void remove(T value) {
        this.remove(this.locate(value));
    }

    public boolean test_equilibrium_order_link() {
        if (!this.is_empty()) {
            this.test_linked_list();
            this.root.test_equilibrium_order();
        } else {
            assert (this.root == null);
            assert (this.first == null);
            assert (this.last == null);
        }
        return true;
    }

    public boolean test_linked_list() {
        Iterator<T> i = this.iterator();
        T t = i.next();
        int nbr = 1;
        while (i.hasNext()) {
            T u = i.next();
            if (this.comp.compare(t, u) > 0) {
                System.err.print("\t" + t + " " + u + " | \n");
            }
            t = u;
            ++nbr;
        }
        assert (nbr == this.get_size());
        Node curant = this.first;
        assert (curant.previous == null);
        nbr = 1;
        while (curant != null) {
            assert (curant == this.first || curant.previous.next == curant);
            assert (curant == this.last || curant.next.previous == curant);
            curant = curant.next;
            ++nbr;
        }
        return true;
    }

    public class Node {
        private final T value;
        private Node father;
        private Node left;
        private Node right;
        private Node previous;
        private Node next;
        private int height = 1;
        private int delta = 0;
        private boolean is_in_structure = true;

        private Node(T value, Node father, Node left, Node right, Node previous, Node next) {
            this.value = value;
            this.father = father;
            this.left = left;
            this.right = right;
            this.previous = previous;
            if (father == null) {
                Tree_Linked_List.this.root = this;
            }
            if (previous == null) {
                Tree_Linked_List.this.first = this;
            } else {
                previous.next = this;
            }
            this.next = next;
            if (next == null) {
                Tree_Linked_List.this.last = this;
            } else {
                next.previous = this;
            }
            ++Tree_Linked_List.this.size;
            assert (this.is_coherent(false, true));
        }

        private Node add(T value_added) {
            Node local = this;
            int compare;
            while ((compare = Tree_Linked_List.this.comp.compare(value_added, local.value)) != 0) {
                if (compare < 0) {
                    if (local.left == null) {
                        Node resultat;
                        local.left = resultat = new Node(value_added, local, null, null, local.previous, local);
                        local.left.rebalance_bottom_up();
                        return resultat;
                    }
                    local = local.left;
                    continue;
                }
                if (local.right == null) {
                    Node resultat;
                    local.right = resultat = new Node(value_added, local, null, null, local, local.next);
                    local.right.rebalance_bottom_up();
                    return resultat;
                }
                local = local.right;
            }
            return local;
        }

        private void compute_height_local() {
            int right_height = this.right == null ? 0 : this.right.height;
            int left_height = this.left == null ? 0 : this.left.height;
            this.delta = left_height - right_height;
            this.height = this.delta > 0 ? left_height + 1 : right_height + 1;
        }

        private void compute_height_local_equilibrate() {
            this.compute_height_local();
            if (2 <= this.delta) {
                if (this.left.delta < 0) {
                    this.left.rotate_left();
                }
                this.rotate_right();
            } else if (this.delta <= -2) {
                if (this.right.delta > 0) {
                    this.right.rotate_right();
                }
                this.rotate_left();
            }
            assert (this.is_coherent(true, true));
        }

        public T get_value() {
            return this.value;
        }

        public boolean is_coherent(boolean test_tree, boolean test_extremities) {
            if (test_tree) {
                assert (this.father != null || this == Tree_Linked_List.this.root);
                assert (this.father == null || this == this.father.left || this == this.father.right);
            }
            if (test_extremities) {
                assert (this.previous != null || Tree_Linked_List.this.first == this);
                assert (this.next != null || Tree_Linked_List.this.last == this);
            }
            assert (this.previous == null || this.previous.is_in_structure);
            assert (this.previous == null || this.previous.next == this);
            assert (this.next == null || this.next.previous == this);
            assert (this.next == null || this.next.is_in_structure);
            assert (this.left == null || this.left.father == this);
            assert (this.right == null || this.right.father == this);
            return true;
        }

        private Node locate(T value) {
            switch (Tree_Linked_List.this.comp.compare(value, this.value)) {
                case 1: {
                    return this.right == null ? null : this.right.locate(value);
                }
                case -1: {
                    return this.left == null ? null : this.left.locate(value);
                }
            }
            return this;
        }

        void print_tree_vertical(PrintStream ps, String prefix) {
            if (this.left != null) {
                this.left.print_tree_vertical(ps, String.valueOf(prefix) + "  ");
            }
            ps.println(String.valueOf(prefix) + this.value);
            if (this.right != null) {
                this.right.print_tree_vertical(ps, String.valueOf(prefix) + "  ");
            }
        }

        private void rebalance_bottom_up() {
            Node ancestor = this;
            while (ancestor != null) {
                ancestor.compute_height_local_equilibrate();
                ancestor = ancestor.father;
            }
        }

        void remove() {
            if (!this.is_in_structure) {
                return;
            }
            if (this.left == null) {
                if (this.right == null) {
                    this.remove_from_father();
                    this.remove_from_chain();
                } else {
                    this.right.father = this.father;
                    if (this.father == null) {
                        Tree_Linked_List.this.root = this.right;
                    } else {
                        if (this.father.left == this) {
                            this.father.left = this.right;
                        } else {
                            this.father.right = this.right;
                        }
                        this.father.rebalance_bottom_up();
                    }
                    this.right = null;
                    this.father = null;
                    this.remove_from_chain();
                }
            } else if (this.right == null) {
                this.left.father = this.father;
                if (this.father == null) {
                    Tree_Linked_List.this.root = this.left;
                } else {
                    if (this.father.left == this) {
                        this.father.left = this.left;
                    } else {
                        this.father.right = this.left;
                    }
                    this.father.rebalance_bottom_up();
                }
                this.left = null;
                this.father = null;
                this.remove_from_chain();
            } else {
                int deeper_previous = this.previous.height - this.next.height;
                this.swap_in_tree(deeper_previous > 0 || deeper_previous == 0 && this.delta > 0 ? this.previous : this.next);
                assert (this.is_coherent(true, true));
                assert (this.previous == null || this.previous.is_coherent(true, true));
                assert (this.next == null || this.next.is_coherent(true, true));
                this.remove();
            }
        }

        private void remove_from_chain() {
            assert (this.is_in_structure);
            assert (this.father == null);
            assert (this.left == null);
            assert (this.right == null);
            assert (this.is_coherent(false, false));
            this.is_in_structure = false;
            if (this.next != null) {
                this.next.previous = this.previous;
            } else {
                Tree_Linked_List.this.last = this.previous;
            }
            if (this.previous != null) {
                this.previous.next = this.next;
            } else {
                Tree_Linked_List.this.first = this.next;
            }
            assert (this.next == null || this.next.is_coherent(true, true));
            assert (this.previous == null || this.previous.is_coherent(true, true));
            this.previous = null;
            this.next = null;
            this.father = null;
            this.left = null;
            this.right = null;
            --Tree_Linked_List.this.size;
        }

        private void remove_from_father() {
            assert (this.left == null);
            assert (this.right == null);
            assert (this.is_coherent(true, true));
            if (this.father == null) {
                Tree_Linked_List.this.root = null;
                Tree_Linked_List.this.first = null;
                Tree_Linked_List.this.last = null;
            } else {
                assert (this.father.is_coherent(true, true));
                if (this.father.left == this) {
                    this.father.left = null;
                } else {
                    this.father.right = null;
                }
                this.father.rebalance_bottom_up();
                this.father = null;
            }
        }

        private void rotate_left() {
            this.right.father = this.father;
            if (this.father == null) {
                Tree_Linked_List.this.root = this.right;
            } else if (this.father.left == this) {
                this.father.left = this.right;
            } else {
                this.father.right = this.right;
            }
            this.father = this.right;
            this.right = this.right.left;
            if (this.right != null) {
                this.right.father = this;
            }
            this.father.left = this;
            this.compute_height_local();
            assert (this.is_coherent(true, true));
            assert (this.father.is_coherent(true, true));
            assert (this.father.right == null || this.father.right.is_coherent(true, true));
            this.father.compute_height_local();
        }

        private void rotate_right() {
            this.left.father = this.father;
            if (this.father == null) {
                Tree_Linked_List.this.root = this.left;
            } else if (this.father.right == this) {
                this.father.right = this.left;
            } else {
                this.father.left = this.left;
            }
            this.father = this.left;
            this.left = this.left.right;
            if (this.left != null) {
                this.left.father = this;
            }
            this.father.right = this;
            this.compute_height_local();
            this.father.compute_height_local();
            assert (this.is_coherent(true, true));
            assert (this.father.is_coherent(true, true));
            assert (this.father.left == null || this.father.left.is_coherent(true, true));
        }

        private void swap_in_tree(Node n) {
            if (this.father != null) {
                if (this.father.left == this) {
                    this.father.left = n;
                } else {
                    this.father.right = n;
                }
            } else {
                Tree_Linked_List.this.root = n;
            }
            if (n.father != null) {
                if (n.father.left == n) {
                    n.father.left = this;
                } else {
                    n.father.right = this;
                }
            } else {
                Tree_Linked_List.this.root = n;
            }
            Node swap = this.father;
            this.father = n.father;
            n.father = swap;
            if (this.left != null) {
                this.left.father = n;
            }
            if (n.left != null) {
                n.left.father = this;
            }
            swap = this.left;
            this.left = n.left;
            n.left = swap;
            if (this.right != null) {
                this.right.father = n;
            }
            if (n.right != null) {
                n.right.father = this;
            }
            swap = this.right;
            this.right = n.right;
            n.right = swap;
            int swap_height = this.height;
            this.height = n.height;
            n.height = swap_height;
            swap_height = this.delta;
            this.delta = n.delta;
            n.delta = swap_height;
            assert (this.is_coherent(true, true));
            assert (n.is_coherent(true, true));
        }

        private void test_equilibrium_order() {
            int r_l;
            int l_l;
            assert (this.is_coherent(true, true));
            if (this.left != null) {
                this.left.test_equilibrium_order();
                l_l = this.left.height;
                if (Tree_Linked_List.this.comp.compare(this.left.value, this.value) > 0) {
                    this.print_tree_vertical(System.err, "**");
                    throw new IllegalStateException("TREE NOT ORDERED");
                }
                if (this != this.left.father) {
                    this.print_tree_vertical(System.err, "** this != left.father");
                    throw new IllegalStateException("TREE NOT COHERENT");
                }
            } else {
                l_l = 0;
            }
            if (this.right != null) {
                this.right.test_equilibrium_order();
                r_l = this.right.height;
                if (Tree_Linked_List.this.comp.compare(this.value, this.right.value) > 0) {
                    this.print_tree_vertical(System.err, "**");
                    throw new IllegalStateException("TREE NOT ORDERED");
                }
                if (this != this.right.father) {
                    this.print_tree_vertical(System.err, "** this != right.father");
                    throw new IllegalStateException("TREE NOT COHERENT");
                }
            } else {
                r_l = 0;
            }
            if (2 <= Math.abs(r_l - l_l)) {
                this.print_tree_vertical(System.err, "**");
                throw new IllegalStateException("TREE NOT EQUILIBRATED");
            }
            if (this.previous != null) {
                if (this != this.previous.next) {
                    this.print_tree_vertical(System.err, "**");
                    throw new IllegalStateException("Error link to previous");
                }
            } else if (this != Tree_Linked_List.this.first) {
                this.print_tree_vertical(System.err, "**");
                throw new IllegalStateException("Error link to first");
            }
            if (this.next != null) {
                if (this != this.next.previous) {
                    this.print_tree_vertical(System.err, "**");
                    throw new IllegalStateException("Error link to next");
                }
            } else if (Tree_Linked_List.this.last != this) {
                this.print_tree_vertical(System.err, "**");
                throw new IllegalStateException("Error link to last");
            }
        }
    }

    private class TLLIterator
    implements Iterator<T> {
        private Node current = null;
        private Node next;
        private final boolean may_delete;

        TLLIterator(boolean may_delete) {
            this.next = Tree_Linked_List.this.first;
            this.may_delete = may_delete;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.may_delete) {
                throw new UnsupportedOperationException();
            }
            if (this.next != null) {
                this.current = this.next;
                this.next = this.next.next;
                return this.current.value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new RuntimeException("There is no node to remove");
            }
            Tree_Linked_List.this.remove(this.current);
            this.current = null;
        }
    }
}

