grammar SM_Language_;

/*

cd ~/Developpement/Eclipse/Abstract_Geometrical_Computation/src/fr/univ_orleans/jdl/language/parser
java -jar ~/lib/java/antlr-4.7-complete.jar SM_Language_.g4

#-package fr.univ_orleans.jdl.language.parser

*/

// WARNING  /!\
// need to be compiled by ANTLR with the arguments: -visitor -encoding UTF-8 
// in external tools configuration, and the encoding is probably optional
// WARNING  /!\

options {

	language = Java;
	
}


@header {
	
	package fr.univ_orleans.jdl.language.parser ;

	import java.io.InputStream ;
	import java.math.BigInteger ;

	import fr.univ_orleans.jdl.util.Rational ;
	import fr.univ_orleans.jdl.language.* ;
    import fr.univ_orleans.jdl.language.operator.* ;
    import fr.univ_orleans.jdl.language.exception.* ;
    import fr.univ_orleans.jdl.language.value.* ;
}


@parser::members {
	
//	public InputStream input_stream ;
		public String input_descritpion ;
	
}


program returns [ Program chunk ] :
	{	$chunk = new Program ( new Chunk_Origin_Input( input_descritpion, 0 ) ) ;	}
	block_inside [ $chunk ]
;


block_inside [ OP_Block chunk ] :
	SYMBOL_INSTRUCTION_END*
	(
		i=instruction
		{	$chunk.add ( $i.chunk ) ;
		}
	)*
;


instruction returns [ Chunk chunk ] :
 	eu=construct SYMBOL_INSTRUCTION_END*
	{	$chunk = $eu.chunk ;	}
|	bl=block SYMBOL_INSTRUCTION_END*
	{	$chunk = $bl.chunk ; 	}
|	(
		op_use=KEY_WORD_USE id=ID
		{	$chunk = new OP_Use_Library ( new Chunk_Origin_Input( input_descritpion , $op_use.line ), $id.text ) ; 	}
	|	op_load=KEY_WORD_LOAD str=STRING
		{	$chunk = new OP_Load_Code ( new Chunk_Origin_Input( input_descritpion , $op_load.line ), $str.text.substring ( 1 , $str.text.length () - 1 ) ) ;
  		}
	|	op_ret=SYMBOL_AFFECT er=expression_right  // return
		{	$chunk = new OP_Return ( new Chunk_Origin_Input( input_descritpion , $op_ret.line ), $er.chunk ) ; 	}
	|	er=expression_right
		{	$chunk = $er.chunk ; 	}
	) 	SYMBOL_INSTRUCTION_END+
;

construct returns [ Chunk chunk ] :
	chunk_do_while
	{	$chunk = $chunk_do_while.chunk ;	}
|	chunk_foreach
	{	$chunk = $chunk_foreach.chunk ;	}
|	chunk_foreach_range
	{	$chunk = $chunk_foreach_range.chunk ;	}
|	chunk_while
	{	$chunk = $chunk_while.chunk ;	}
;

expression_right returns [ Chunk chunk ] :
//  < <= ≤ != ==
	er_l=expression_right
	{	$chunk = ( $er_l.chunk instanceof OP_Test_Sequence )
	     		 ? $er_l.chunk
	     		 : new OP_Test_Sequence ( new Chunk_Origin_Input( input_descritpion , -1 ) , $er_l.chunk ) ;
		OP_Test_Sequence.Test_Type test_op ;
	}
	( 	SYMBOL_DIFFERENT 	{ test_op = OP_Test_Sequence.Test_Type.DIFFERENT ; }
	| 	SYMBOL_EQUAL 	{ test_op = OP_Test_Sequence.Test_Type.EQUAL ; }
	| 	SYMBOL_LESS 	{ test_op = OP_Test_Sequence.Test_Type.LESS_THAN ; }
	| 	SYMBOL_LESS_EQUAL 	{ test_op = OP_Test_Sequence.Test_Type.LESS_EQUAL ; }
	)
	er_r=expression_right
	{	( (OP_Test_Sequence) $chunk ) . add ( test_op , $er_r.chunk ) ; 	}
| 	er_l=expression_right op=SYMBOL_AND er_r=expression_right
	{	$chunk = new OP_AND ( new Chunk_Origin_Input( input_descritpion , $op.line ), $er_l.chunk , $er_r.chunk ) ; 	}
|	er_l=expression_right op=SYMBOL_OR er_r=expression_right
	{	$chunk = new OP_OR ( new Chunk_Origin_Input( input_descritpion , $op.line ), $er_l.chunk , $er_r.chunk ) ; 	}
|	// The two forms are provided to force priority
	kw=KEY_WORD_IF SYMBOL_PARENTHESIS_OPEN cnd=expression_right
	SYMBOL_PARENTHESIS_CLOSE tr=expression_right
	KEY_WORD_ELSE fl=expression_right
	{	$chunk = new OP_If ( new Chunk_Origin_Input( input_descritpion , $kw.line ), $cnd.chunk , $tr.chunk , $fl.chunk ) ; }
|	kw=KEY_WORD_IF SYMBOL_PARENTHESIS_OPEN cnd=expression_right
	SYMBOL_PARENTHESIS_CLOSE tr=expression_right
	{	$chunk = new OP_If ( new Chunk_Origin_Input( input_descritpion , $kw.line ), $cnd.chunk , $tr.chunk ) ; }
|	lab=expression_left
	{	boolean is_constant ;	}
	(	op=SYMBOL_AFFECT { 	is_constant = false ;	}
	|	op=SYMBOL_AFFECT_COSTANT { 	is_constant = true ; 	}
	)	er_r=expression_right
	{	$chunk = ( is_constant )
				 ? new OP_Affectation_Constant ( new Chunk_Origin_Input( input_descritpion , $op.line ), $lab.chunk , $er_r.chunk )
				 : new OP_Affectation ( new Chunk_Origin_Input( input_descritpion , $op.line ), $lab.chunk , $er_r.chunk ) ;	}
|   er_l=expression_right op=SYMBOL_ASSOCIATE er_r=expression_right
	{	$chunk = new OP_Association ( new Chunk_Origin_Input( input_descritpion , $op.line ), $er_l.chunk , $er_r.chunk ) ;	}
|	// FUNCTION DECLARATION
	op=SYMBOL_PARENTHESIS_OPEN
	{	Value_Function function = new Value_Function ( new Chunk_Origin_Input( input_descritpion , $op.line )) ;
		$chunk = function ;
	}
	(
		arg=ID
		{	function . add_arg ( $arg.text ) ; 	}
		(
			SYMBOL_EXPRESSION_SEPARATOR arg=ID
			{	function . add_arg ( $arg.text ) ; 	}
		)*
	)?
	SYMBOL_PARENTHESIS_CLOSE
	op=SYMBOL_FUNCTION_DECLARATION
	er=expression_right
	{	function . set_expression ( $er.chunk ) ; 	}
|	ee=expresion_extra
	{ 	$chunk = $ee.chunk ; 	}
;


context returns [ OP_Get_Context get_context ] :
	(
	|	sc=symbol_context
	{	$get_context = new OP_Get_Context ( new Chunk_Origin_Input( input_descritpion , $sc.line ), $sc.type,  null ) ; 	}
	|	<assoc=right>
		el_l=expression_left
		sc=symbol_context
		{	$get_context = new OP_Get_Context ( new Chunk_Origin_Input( input_descritpion , $sc.line ), $sc.type,  $el_l.chunk ) ; 	}
	)
;

/*
 * OPERATORS that are not associated to any spc treatment and can be dynamically defined
 * Priority is between test and list concatenation.
 * For any of these operators, e1 OP e2 OP e3 is illegal!
 * There is no left or right associativity so that the code has to provide the parenthesis.
 */
expresion_extra returns [ Chunk chunk ] :
	erp_l=expression_right_priority
	context
	op=Z_SYMBOL_EXTRA
	erp_r=expression_right_priority
	{	$chunk = new OP_Extra ( new Chunk_Origin_Input( input_descritpion , $op.line ), $op.text , $erp_l.chunk , $erp_r.chunk, $context.get_context ) ;  }
|	erp=expression_right_priority
	{ 	$chunk = $erp.chunk ; 	}
;


// expression_right_priority : provide a value but is not meant to be on left side of affectations
expression_right_priority returns [ Chunk chunk ] :
// by decreasing priority order
//	CONSTANTs
	ra=rational_form
	{	$chunk = Value_Number.simplify_integral ( new Chunk_Origin_Input( input_descritpion , $ra.line ), $ra.rat ) ; 	}
|	bi=rational_big_integer
	{	$chunk = new Value_Integer ( new Chunk_Origin_Input( input_descritpion , $bi.line ), $bi.bi ) ; 	}
| 	kw=KEY_WORD_PLUS_INFINITY
	{	$chunk = new Value_Rational.Plus_Infinity ( new Chunk_Origin_Input( input_descritpion , $kw.line ) );	}
| 	KEY_WORD_MINUS_INFINITY
	{	$chunk = new Value_Rational.Minus_Infinity ( new Chunk_Origin_Input( input_descritpion , $kw.line ) );	}
|	ch=CHARACTER
	{	$chunk = new Value_Character ( new Chunk_Origin_Input ( input_descritpion , $ch.line ), $ch.text.charAt( 1 ) ) ; 	}
|	str=STRING
	{	$chunk = new Value_String ( new Chunk_Origin_Input ( input_descritpion , $str.line ), $str.text.substring ( 1 , $str.text.length () - 1 ) ) ; 	}
|	kw=KEY_WORD_TRUE  { $chunk = Value_Boolean.TRUE ; }
|	kw=KEY_WORD_FALSE { $chunk = Value_Boolean.FALSE ; }
|	kw=KEY_WORD_ERROR { $chunk = new Value_Special.Value_Error ( new Chunk_Origin_Input( input_descritpion , $kw.line ) ) ; }
|	kw=KEY_WORD_UNDEFINED { $chunk = new Value_Special.Value_Undefined  ( new Chunk_Origin_Input( input_descritpion , $kw.line ) ); }
|	kw=KEY_WORD_VOID { $chunk = new Value_Special.Value_Void ( new Chunk_Origin_Input( input_descritpion , $kw.line ) ) ; }
//	OPEN … END DELIMITERS ( { [ ] } )
|	SYMBOL_PARENTHESIS_OPEN er=expression_right SYMBOL_PARENTHESIS_CLOSE
	{	$chunk = $er.chunk ; 	}
|	{	boolean is_reopen ;
		Chunk elno = null ;	}
	(
		(
		|	elno=expression_left
			{	elno = $elno.chunk ; }
		)
		s=symbol_context
		{	is_reopen = true ; 	}
	|	{	is_reopen = false ; 	}
	)
	op=SYMBOL_LESS er=expression_right SYMBOL_ASSOCIATION_CALL_END
	{	$chunk = new OP_Association_Get ( new Chunk_Origin_Input( input_descritpion , $op.line ), $er.chunk ) ;
		$chunk = is_reopen
			     ? new OP_Reopen ( new Chunk_Origin_Input( input_descritpion , $s.line ), $s.type, elno , $chunk )
			     : $chunk ; 	}
|	bl=block
	{	$chunk = $bl.chunk ; 	}
// LEFT EXPRESSIONS
|	el=expression_left
	{	$chunk = $el.chunk ; }
|	op=SYMBOL_NOT ev=expression_right_priority
	{	$chunk = new OP_Not ( new Chunk_Origin_Input( input_descritpion , $op.line ), $ev.chunk ) ;	}
|	op=SYMBOL_MINUS ev=expression_right_priority
	{  	Chunk ch = $ev.chunk ;
		if ( ch instanceof Value_Number ) {
			$chunk = ( ( Value_Number ) ch ) . negate ( new Chunk_Origin_Input( input_descritpion , $op.line )) ;
		} else {
			$chunk = new OP_Change_Sign ( new Chunk_Origin_Input( input_descritpion , $op.line ), ch ) ;
		}
	}
|	erp_l=expression_right_priority
	{	OP_Binary_Number.OP_Binary_Number_Type type ; 	}
	(	op=SYMBOL_PRODUCT 	{	type = OP_Binary_Number.OP_Binary_Number_Type.OP_PRODUCT ; 	}
	| 	op=SYMBOL_DIVIDE  	{	type = OP_Binary_Number.OP_Binary_Number_Type.OP_DIVISION ; 	}
	| 	op=SYMBOL_REMAINDER  	{	type = OP_Binary_Number.OP_Binary_Number_Type.OP_REMAINDER ; 	}
	|	op=SYMBOL_DIVIDE_INTEGRAL  	{	type = OP_Binary_Number.OP_Binary_Number_Type.OP_DIVISION_INTEGRAL ; 	}
	) 	erp_r=expression_right_priority
	{	$chunk = OP_Binary_Number.create_operator_binary_number ( new Chunk_Origin_Input( input_descritpion , $op.line ), $erp_l.chunk , $erp_r.chunk , type ) ; 	}
|	erp_l=expression_right_priority
	{	OP_Binary_Number.OP_Binary_Number_Type type ; 	}
	( 	op=SYMBOL_PLUS 	{	type = OP_Binary_Number.OP_Binary_Number_Type.OP_ADDITION ; 	}
	|	op=SYMBOL_MINUS 	{	type = OP_Binary_Number.OP_Binary_Number_Type.OP_SUBTRACTION ; 	}
	)
	erp_r=expression_right_priority
	{	$chunk = OP_Binary_Number.create_operator_binary_number ( new Chunk_Origin_Input( input_descritpion , $op.line ), $erp_l.chunk , $erp_r.chunk , type ) ; 	}
|	erp_l=expression_right_priority op=SYMBOL_CONCATENATION erp_r=expression_right_priority
	{	$chunk = new OP_Concatenation ( new Chunk_Origin_Input( input_descritpion , $op.line ), $erp_l.chunk , $erp_r.chunk ) ; 	}
//|	erp_l=expression_right_priority op=SYMBOL_LIST_CONCAT erp_r=expression_right_priority
//	{	$chunk = new OP_List_Concatenation ( new Chunk_Origin_Input( input_descritpion , $op.line ), $erp_l.chunk , $erp_r.chunk ) ; 	}
|	op=SYMBOL_LIST_SIZE v_a=expression_right_priority
	{	$chunk = new OP_List_Size ( new Chunk_Origin_Input( input_descritpion , $op.line ), $v_a.chunk ) ;	}
;


// expression that can receive a value
expression_left
	returns [	Chunk chunk ]
	locals [ 	OP_Block op_block 	]
:
	SYMBOL_PARENTHESIS_OPEN el=expression_left SYMBOL_PARENTHESIS_CLOSE
	{	$chunk = $el.chunk ; 	}
|	l=list
	{	$chunk = $l.chunk ;  	}
|	(	i=ID
	|	i=Z_SYMBOL_EXTRA
	) 	{	$chunk = new Value_Id (new Chunk_Origin_Input( input_descritpion , $i.line ), $i.text ) ; 	}
|	sc=symbol_context
	el=expression_left
	{	$chunk = new OP_Reopen ( new Chunk_Origin_Input( input_descritpion , $sc.line ), $sc.type,  null , $el.chunk ) ; 	}
|	<assoc=right>
	el_l=expression_left
	sc=symbol_context
	el_r=expression_left
	{	$chunk = new OP_Reopen ( new Chunk_Origin_Input( input_descritpion , $sc.line ), $sc.type,  $el_l.chunk , $el_r.chunk ) ; 	}
| // FUNCTION CALLING
	el=expression_left
	{	$chunk = $el.chunk ;
		OP_Function_Call fct_call = new OP_Function_Call ( $chunk.origin , $chunk ) ;
		$op_block = fct_call ;
		$chunk = $op_block ;
	}
	(  // HAVE PARENTHESIS
		op=SYMBOL_PARENTHESIS_OPEN
		(
			er=expression_right
			{	fct_call . add_arg ( $er.chunk ) ; 	}
			(
				SYMBOL_EXPRESSION_SEPARATOR er=expression_right
				{	fct_call . add_arg ( $er.chunk ) ; 	}
			)*
		)?
		SYMBOL_PARENTHESIS_CLOSE
		(
			SYMBOL_BLOCK_OPEN
			block_inside[ $op_block ]
			SYMBOL_BLOCK_CLOSE
		)?
	|  // JUST HAVE BLOCK
		SYMBOL_BLOCK_OPEN
		block_inside[ $op_block ]
		SYMBOL_BLOCK_CLOSE
	)
|	// LIST ELEMENT ACCESS
	el=expression_left op=SYMBOL_LIST_OPEN e=expression_right SYMBOL_LIST_CLOSE
	{ $chunk = new OP_List_Cell( new Chunk_Origin_Input( input_descritpion , $op.line ), $el.chunk , $e.chunk ) ; }
;

symbol_context returns [ int line , OP_Reopen.OP_Reopen_Type type ] :
	s=SYMBOL_CONTEXT_REOPEN 	{ 	$line = $s.line ; $type = OP_Reopen.OP_Reopen_Type . REOPEN ;	}
|	s=SYMBOL_CONTEXT_HERE 		{ 	$line = $s.line ; $type = OP_Reopen.OP_Reopen_Type . HERE ;	}
|	s=SYMBOL_CONTEXT_ABOVE	 	{ 	$line = $s.line ; $type = OP_Reopen.OP_Reopen_Type . ABOVE ;	}
|	s=SYMBOL_CONTEXT_CALLING	{ 	$line = $s.line ; $type = OP_Reopen.OP_Reopen_Type . CALLING ;	}
;


chunk_foreach returns [ Chunk chunk ] :
	kw=KEY_WORD_FOREACH SYMBOL_PARENTHESIS_OPEN id=ID SYMBOL_COLOM lst=expression_right SYMBOL_PARENTHESIS_CLOSE
	tr=expression_right
	{	$chunk = new OP_Foreach ( new Chunk_Origin_Input( input_descritpion , $kw.line ), $id.text , $lst.chunk , $tr.chunk ) ; }
;

chunk_foreach_range returns [ Chunk chunk ] :
	kw=KEY_WORD_FOREACH SYMBOL_PARENTHESIS_OPEN id=ID SYMBOL_COLOM 
	e_l=expression_right op=SYMBOL_RANGE e_r=expression_right 
	SYMBOL_PARENTHESIS_CLOSE
	tr=expression_right
	{	$chunk = new OP_Foreach_Range ( new Chunk_Origin_Input( input_descritpion , $kw.line ), $id.text , $e_l.chunk , $e_r.chunk , $tr.chunk ) ; }
;

chunk_while  returns [ Chunk chunk ] :
	kw=KEY_WORD_WHILE SYMBOL_PARENTHESIS_OPEN cnd=expression_right SYMBOL_PARENTHESIS_CLOSE
	tr=expression_right
	{	$chunk = new OP_While ( new Chunk_Origin_Input( input_descritpion , $kw.line ), $cnd.chunk , $tr.chunk ) ; }
;


chunk_do_while  returns [ Chunk chunk ] :
	KEY_WORD_WHILE_DO
	tr=expression_right
	kw=KEY_WORD_WHILE SYMBOL_PARENTHESIS_OPEN cnd=expression_right SYMBOL_PARENTHESIS_CLOSE
	{	$chunk = new OP_While_Do ( new Chunk_Origin_Input( input_descritpion , $kw.line ), $cnd.chunk , $tr.chunk ) ; }
;


block returns [ Chunk chunk ]
@init{	OP_Block block ;	}
:
	{	boolean is_reopen = false ;
		Chunk elno = null ;	}
	(
		(
			(
			|	elno=expression_left
				{	elno = $elno.chunk ; }
			)
			s=symbol_context
			{	is_reopen = true ; 	}
		|	{	is_reopen = false ; 	}
		)
		op=SYMBOL_BLOCK_OPEN
		{	block = new OP_Block ( new Chunk_Origin_Input( input_descritpion , $op.line )) ;
			$chunk = is_reopen
				     ? new OP_Reopen ( new Chunk_Origin_Input( input_descritpion , $s.line ), $s.type, elno , block )
				     : block ; 	}
		block_inside [ block ]
		SYMBOL_BLOCK_CLOSE
	)
|	(	opa=SYMBOL_BLOCK_ASSOCIATIVE_OPEN
		{	$chunk = block = new OP_Block_Assocaitive ( new Chunk_Origin_Input( input_descritpion , $opa.line )) ; 	}
		block_inside [ block ]
		SYMBOL_BLOCK_ASSOCIATIVE_CLOSE
	)
;


list returns [ OP_List chunk ] :
	op=SYMBOL_LIST_OPEN
	{	$chunk= new OP_List ( new Chunk_Origin_Input( input_descritpion , $op.line ) ) ; 	}
	(	er=expression_right
		{	$chunk.add ( $er.chunk ) ; 	}
		(	SYMBOL_EXPRESSION_SEPARATOR er=expression_right
			{	$chunk.add ( $er.chunk ) ; 	}
		)*
	)?
	SYMBOL_LIST_CLOSE
;

rational_big_integer returns [ int line , BigInteger bi ] :
	num=rational_integer
	{	$bi = new BigInteger ( $num.text ) ;
		$line = $num.line ;
	}
;

rational_form returns [ int line , Rational rat ] :
	num=rational_integer op=SYMBOL_COLOM den=RATIONAL_INTEGER_UNSIGNED
	{	$rat = new Rational ( new BigInteger ( $num.text ) , new BigInteger ( $den.text ) ) ;
		$line = $op.line ;
	}
;

rational returns [ int line , Rational rat ] :
	bi=rational_big_integer
	{ 	$rat = new Rational ( $bi.bi ) ;
		$line = $bi.line ;
	}
|	r=rational_form
	{ 	$rat = $r.rat ;
		$line = $r.line ;
	}
;

rational_integer returns [ int line ] :
	r=RATIONAL_INTEGER_UNSIGNED
	{ 	$line = $r.line ;	}
|	s=rational_integer_negative
	{ 	$line = $s.line ;	}
|	z='0'
	{ 	$line = $z.line ;	}
;

rational_integer_negative returns [ int line ] :
	r=SYMBOL_MINUS RATIONAL_INTEGER_UNSIGNED
	{ 	$line = $r.line ;	}
;



//
// Definition of Tokens
//
SYMBOL_AFFECT :	':=' ;
SYMBOL_AFFECT_COSTANT :	'.=' ;
SYMBOL_AND :	'&&' ;
SYMBOL_ASSOCIATE : '=>' ;
SYMBOL_BLOCK_ASSOCIATIVE_OPEN : 	'{{' ;
SYMBOL_BLOCK_ASSOCIATIVE_CLOSE :	'}}' ;
SYMBOL_BLOCK_OPEN : 	'{' ;
SYMBOL_BLOCK_CLOSE :	'}' ;
SYMBOL_CONTEXT_ABOVE :	'..' ;
SYMBOL_CONTEXT_CALLING : '?' ;
SYMBOL_CONTEXT_HERE :	'.' ;
SYMBOL_CONTEXT_REOPEN :	'::' ;
SYMBOL_CONCATENATION : '_' ;
SYMBOL_DIFFERENT : 	'!=' ;
SYMBOL_DIVIDE :	'/' ;
SYMBOL_DIVIDE_INTEGRAL :	'/%' ;
SYMBOL_EQUAL : 	'==' ;
SYMBOL_EXPRESSION_SEPARATOR :	',' ;
SYMBOL_FUNCTION_DECLARATION : '->' ;
SYMBOL_ASSOCIATION_CALL_END :	'>' ;
SYMBOL_INSTRUCTION_END :	';' ;
SYMBOL_LESS :	'<' ;
SYMBOL_LESS_EQUAL :	'<=' 	| 	'≤' ;
SYMBOL_LIST_CLOSE : ']' ;
SYMBOL_LIST_OPEN : '[' ;
SYMBOL_LIST_SIZE : '#' ;
SYMBOL_MINUS :	'-' ;
SYMBOL_REMAINDER :	'%' ;
SYMBOL_NOT :	'!' ;
SYMBOL_OR :	'||' ;
SYMBOL_PARENTHESIS_OPEN : 	'(' ;
SYMBOL_PARENTHESIS_CLOSE : 	')' ;
SYMBOL_PLUS :	'+' ;
SYMBOL_PRODUCT :	'*' ;
SYMBOL_RANGE :	'...' ;

SYMBOL_COLOM :	':' ;

KEY_WORD_IF : 	'if' ;
KEY_WORD_ELSE :		'else' ;
KEY_WORD_WHILE_DO : 	'do' ;
KEY_WORD_WHILE : 	'while' ;

KEY_WORD_FALSE : 	'false' ;
KEY_WORD_TRUE : 	'true' ;

KEY_WORD_USE : 	'use' ;
KEY_WORD_LOAD : 	'load' ;

KEY_WORD_THIS : 	'this' ; // TODO to capture the current context
KEY_WORD_SWITCH : 	'switch' ; // TODO for distinct cases
KEY_WORD_NEW : 	'new' ; // TODO to reserve it

KEY_WORD_ERROR : 	'error' ;
KEY_WORD_UNDEFINED : 	'undef' ;
KEY_WORD_VOID : 	'void' ;

KEY_WORD_FOREACH : 	'foreach' ;
KEY_WORD_FOR : 	'for' ;

KEY_WORD_PLUS_INFINITY : 'plus_infinity' ;
KEY_WORD_MINUS_INFINITY : 'minus_infinity' ;

STRING :
	'"' ( ~["] | '\\"' )* '"'
;

CHARACTER :
	'\'' ( . | '\\' [ntr] ) '\''
;

ID :
	LETTER
	(
		LETTER
		| DIGIT
		| '_'
	)*
;

RATIONAL_INTEGER_UNSIGNED :
	[1-9][0-9]*
;


fragment
LETTER :
	'a' .. 'z'
|	'A' .. 'Z'
;

fragment
DIGIT :
	[0-9]
;

WS :
	[ \t\n\r]+ -> skip
;

COMMENT :
	(
		'//' ~[\r\n]*
	|	'/*' .*? '*/'
	) -> skip
;


/*
 *  Should be after the others not to mess up with what is already defined, including WS!.
 * 
 */
Z_SYMBOL_EXTRA :
	'@' | '~' | '^' | '«' | '»' | '§' // One letter
|	Z_SYMBOL_EXTRA_CHAR Z_SYMBOL_EXTRA_CHAR Z_SYMBOL_EXTRA_CHAR+   // TODO find repetition syntax
;

fragment
Z_SYMBOL_EXTRA_CHAR : 
  '@' | '#' | '~' | '^' | '&' | '|' | '-' | '+' | '*' | '=' 
| '$' | '%' | '!' | ':' | '/' | '<' | '>'
| '≤' | '≥' | '«' | '»' | '§' | '?'
;
