grammar rational_;

// WARNING  /!\
// need to be compiled by ANTLR with the arguments: -visitor -encoding UTF-8 
// in external tools configuration, and the encoding is probably optional
// WARNING  /!\

/*

cd ~/Developpement/Eclipse/Abstract_Geometrical_Computation/src/fr/univ_orleans/besson/modularization/generic

java -jar ~/lib/java/antlr-4.7-complete.jar -package fr.univ_orleans.besson.modularization.generic  -visitor rational_.g4

*/

options {
	language = Java;
}



@header {

	import fr.univ_orleans.jdl.util.Rational ;
	import java.math.BigInteger ;
	import fr.univ_orleans.jdl.language.* ;
}



@parser::members {
}



rational_big_integer returns [ int line , BigInteger bi ] :
	num=rational_integer
	{	$bi = new BigInteger ( $num.text ) ; 
		$line = $num.line ;
	} 
;

rational_form returns [ int line , Rational rat ] :
	num=rational_integer op=RATIONAL__OPERATOR_RATIONAL den=RATIONAL_INTEGER_UNSIGNED
	{	$rat = new Rational ( new BigInteger ( $num.text ) , new BigInteger ( $den.text ) ) ;
		$line = $op.line ;
	}
;

rational returns [ int line , Rational rat ] :
	bi=rational_big_integer
	{ 	$rat = new Rational ( $bi.bi ) ; 
		$line = $bi.line ;
	}
|	r=rational_form
	{ 	$rat = $r.rat ; 
		$line = $r.line ;
	}	
;

rational_integer returns [ int line ] :
	r=RATIONAL_INTEGER_UNSIGNED
	{ 	$line = $r.line ;	}
|	s=rational_integer_negative
	{ 	$line = $s.line ;	}
|	z='0'
	{ 	$line = $z.line ;	}
;

rational_integer_negative returns [ int line ] :
	r=SYMBOL_MINUS RATIONAL_INTEGER_UNSIGNED
	{ 	$line = $r.line ;	}
;

RATIONAL_INTEGER_UNSIGNED :
	[1-9][0-9]* 
;

SYMBOL_MINUS :	'-' ;

RATIONAL__OPERATOR_RATIONAL :	':' ;


WS :
	[ \t\n\r]+ -> skip
;
