//
//  Library for the universal signal machine simulator.
//
//  Main file to include 
//

// load the library for signal machine manipulation
use AGC ;

load "./utils.agc" ;

//-----------------------
//
//CONSTANTS
//
//-----------------------


//Directory for outputting
DIR_OUT .= "./Output/";

// This is used to form meta-signal names
.RIGHTLEFT .= [
	.RIGHT := "r" ,
	.LEFT := "l"
] ;

// Parameter of the simulation

// relative duration of the test
.TEST_EPSILON .= 1 / 16 ;

// ratio for the shrinking
.SHRINK_RIGHT_RATIO .= 1 / 2 ;
	
//-----------------------
//
// Inclusion of other parts of the simulator
//
//-----------------------

// These are the styles used. Separated to allow simple modification/replacement
load "./lib_agc_iuniv_style.agc" ;

// It contains the function to provide names/id for macro-signals
load "./lib_agc_iuniv_names.agc" ;

// The creation function is really big, it has a separate file for clarity
load "./lib_agc_iuniv_creator.agc" ;
