//
//  Library for the universal signal machine simulator.
//
// This file contains the function to provide names/id for macro-signals (ms)
//


//----------------------
//
//  FUNCTIONS TO DEFINE FUNCTIONS
//
//----------------------

.ms_name_1_arg .= ( base ) -> ( arg ) -> base _ arg ;
.ms_name_2_arg .= ( base ) -> ( arg1, arg2 ) -> base _ arg1 _ "^" _ arg2 ;
.ms_name_3_arg .= ( base ) -> ( arg1, arg2, arg3 ) -> base _ arg1 _ "^" _ arg2 _ "=" _ arg3 ;

// when the second argument is some set and setToStr is used te get a string
.ms_name_2_os_arg .= ( base ) -> ( arg1, arg2 ) -> base _ arg1 _ "^" _ setToStr ( arg2 ) ;

//
// To produce a list of similar ms from an array of speeds
//
.ms_array .= ( ms_function ) -> ( A ) -> {
//** A : array of speeds
	r := [] ;
	foreach ( a : A ) {
		r := r _ ms_function ( a ) ;
	} ;
	:= r ;
} ;


.ms_array_1_arg .= ( ms_function ) -> ( A , j ) -> {
//** A : array of speed indices
//** j : speed index
	r := [] ;
	foreach ( a : A ) {
		r := r _ ms_function ( a , j ) ;
	} ;
	:= r ;
} ;


//----------------------
//  SIGNAL ENCODING
//----------------------

.ms_main_set .= ms_name_2_os_arg ( "main_" ) ;
.ms_main .= ( i )  -> {	:= ms_main_set ( i , [] ); } ;
.ms_border_right .= ms_name_1_arg ( "border-right_" ) ;
.ms_border_right_array .= ms_array ( ms_border_right ) ;
.ms_border_left .= ms_name_1_arg ( "border-left_" ) ;
.ms_border_left_array .= ms_array ( ms_border_left ) ;
.ms_id .= ms_name_1_arg ( "id_" ) ;
.ms_id_array .= ms_array ( ms_id ) ;


//----------------------
//  RULES
//----------------------

.ms_if .= ms_name_2_arg ( "if_" ) ;
.ms_if_array .= ms_array_1_arg ( ms_if ) ;
.ms_then .= ms_name_2_arg ( "then_" ) ;
.ms_then_array .= ms_array_1_arg ( ms_then ) ;
.ms_rule_middle .= ms_name_1_arg ( "rule-middle_" ) ;
.ms_rule_middle_array .= ms_array ( ms_rule_middle ) ;
.ms_rule_bound .= ms_name_1_arg ( "rule-border_" ) ;
.ms_rule_bound_array .= ms_array ( ms_rule_bound ) ;


//----------------------
//  ID GATHERING
//----------------------

.ms_collect .= ms_name_2_arg ( "collect_" ) ;
.ms_cross_ok .= ms_name_1_arg ( "cross-ok_" ) ;
.ms_cross_back_ok .= ms_name_1_arg ( "cross-back-ok_" ) ;


//----------------------
//  RULE SELECTION
//----------------------

.ms_cross .= ms_name_1_arg ( "cross_" ) ;
.ms_cross_back .= ms_name_1_arg ( "cross-back_" ) ;
.ms_if_ok .= ms_name_2_arg ( "if-ok_" ) ;
.ms_rule_bound_fail .= ms_name_1_arg ( "rule-border-fail_" ) ;
.ms_rule_middle_fail .= ms_name_1_arg ( "rule-middle-fail_" ) ;


//----------------------
//  SELECTED RULE
//----------------------

.ms_id_copy .= ms_name_2_arg ( "id-copy_" ) ;
.ms_id_selected .= ms_name_2_arg ( "id-selected_" ) ;

.ms_ready .= ms_name_2_os_arg ( "ready_" ) ;
.ms_ready_no .= ms_name_2_os_arg ( "ready-no_" ) ;
.ms_ready_up_1 .= () -> { := "ready-up-1_" ; } ;
.ms_ready_up_2 .= () -> { := "ready-up-2" ; } ;


//----------------------
//  OUTPUT
//----------------------

.ms_fast_left .= ms_name_1_arg ( "fast-left_" ) ;
.ms_fast_right .= ms_name_1_arg ( "fast-right_" ) ;


//----------------------
//  SHRINKING
//----------------------

.ms_shrink_top .= ms_name_2_arg ( "shrink-top_" ) ;
.ms_shrink_top_test .= ms_name_2_arg ( "shrink-top-test_" ) ;
.ms_shrink_bottom .= ms_name_2_arg ( "shrink-bottom_" ) ;
.ms_shrink_bottom_both .= ms_name_2_arg ( "shrink-bottom-both_" ) ;
.ms_shrink_back .= ms_name_2_arg ( "shrink-back_" ) ;
.ms_shrink_test_left .= ms_name_1_arg ( "shrink-test-left_" ) ;
.ms_shrink_test_right .= ms_name_1_arg ( "shrink-test-right_" ) ;
.ms_shrink_id .= ms_name_1_arg ( "shrink-id_" ) ;
.ms_shrink_rule_bound .= ms_name_1_arg ( "shrink-rule_bound_" ) ;
.ms_shrink_rule_middle .= ms_name_1_arg ( "shrink-rule_middle_" ) ;
.ms_shrink_if .= ms_name_2_arg ( "shrink-if_" ) ;
.ms_shrink_then .= ms_name_2_arg ( "shrink-then_" ) ;
.ms_shrink_test .= ms_name_2_arg ( "shrink-test_" ) ;
.ms_shrink_test_ok .= ms_name_1_arg ( "shrink-test-ok_" ) ;
.ms_shrink_test_fail .= ms_name_1_arg ( "shrink-test-fail_" ) ;
.ms_shrink_order .= ms_name_1_arg ( "shrink-order_" ) ;
.ms_test_start .= ms_name_1_arg ( "test-start_" ) ;
.ms_shrink_delayed .= ms_name_2_arg ( "shrink-delayed_" ) ;  


//----------------------
//  TEST
//----------------------

.ms_test_left .= ms_name_1_arg ( "test-left_" ) ;
.ms_test_left_up .= ms_name_2_arg ( "test-left-up_" ) ;
.ms_test_left_ok .= ms_name_1_arg ( "test-left-ok_" ) ;
.ms_test_right .= ms_name_3_arg ( "test-right_" ) ;
.ms_test_right_up .= ms_name_1_arg ( "test-right-up_" ) ;
.ms_test_right_ok .= ms_name_2_arg ( "test-right-ok_" ) ;
.ms_test_right_wait .= ms_name_3_arg ( "test-right-wait_" ) ;
.ms_test_left_fail .= ms_name_1_arg ( "test-left-fail_" ) ;
.ms_test_left_up_fail .= ms_name_1_arg ( "test-left-up-fail_" ) ;
.ms_test_right_fail .= ms_name_1_arg ( "test-right-fail_" ) ;
.ms_test_main_ok .= ms_name_1_arg ( "test-main-ok_" ) ;
.ms_main_test_fail_l .= ms_name_1_arg ( "main-test-fail_l_" ) ;
.ms_main_test_fail_r .= ms_name_1_arg ( "main-test-fail_r_" ) ;


//----------------------
//  CHECK
//----------------------

.ms_check_maybe .= ms_name_2_arg ( "check-maybe_" ) ;
.ms_check .= ms_name_2_arg ( "check_" ) ;
.ms_check_up .= ms_name_2_arg ( "check-up_" ) ;
.ms_check_intersect .= ms_name_3_arg ( "check-intersect_" ) ;
.ms_check_ok .= ms_name_2_arg ( "check-ok_" ) ;
.ms_check_fail .= ms_name_2_arg ( "check-fail_" ) ;
