//
//  Library for the universal signal machine simulator
//
//  This file provide a function for testing the library.
//

// Load the library (it is not loaded by the maid library
load "./lib_agc_iuniv_simulate.agc" ;


/** This function generates 2 space-time diagrams (in pdf) corresponding to a the simulated and simulation.
  The parameters are:
  - configuration to simulate
  - the number of collisions for the simulated
  - the number of collisions for the simulation
  - file name (without suffix) for the output 
  - parameters for the output of the simulated
  - parameters for the output of the simulation
 */
 
.generate_both_diagram .= (
	configuration , 
	number_collision_tiks_ed , 
	number_collision_tiks_ing , 
	file_name , 
	output_arguments_ed, 
	output_arguments_ing
) -> {

	// OUTPUT FOR SIMULATED

	.run .= configuration . run () ; //Create a run
	//	configuration . print_signal_list () ;  // To list present signals
	//	run . print_signal_list () ;  // To list present signals
	run . step ( number_collision_tiks_ed ) ;  //advance by maximum number_collision_tiks collisions times
	//Create a pdf output for the simulated
	run . export ( "PDF" , file_name , output_arguments_ed ) ;
	
	// OUTPUT FOR SIMULATION

	.configuration_sim .= cretate_simulating_configuration ( configuration ) ;
	.run_sim .= configuration_sim.run () ; //Create a run
	//	run_sim . print_signal_list () ;  // To list present signals
	run_sim . step ( number_collision_tiks_ing ) ;  //advance by maximum number_collision_tiks collisions times
	//	run_sim . print_signal_list () ;  // To list present signals
	// Create a pdf output for the simulation
	run_sim . export ( "PDF" ,  file_name _ "_sim", output_arguments_ing ) ;

	//	println ( run_sim.machine ) ;  // to get a full description of the machine
} ;

