/** This library contains functions to use on list. 
 *
 * Various types of lists are concerned:
 * - list_ (regular ones)
 * - list_unique_ (no element is duplicated)
 * - list_sorted_unique_ (sorted in increasing order, no element is duplicated)
 */


/*
 * LIST REGULAR
 */

// returns the minimal value in a list with at least one element
.list_min .= ( list ) -> {
	m := list [ 0 ] ;
	foreach ( v : list ) {
		if ( v < m ) {
			m := v ;
		} ;
	} ;
	:= m ;
} ;

// returns the maximal value in a list with at least one element
.list_max .= ( list ) -> {
	m := list [ 0 ] ;
	foreach ( v : list ) {
		if ( m < v ) {
			m := v ;
		} ;
	} ;
	:= m ;
} ;


// returns the maximal absolute value in a list of numbers with at least one element
.list_max_abs .= ( list ) -> {
	m := abs ( list [ 0 ] ) ;
	foreach ( v : list ) {
		if ( m < abs ( v ) ) {
			m := abs ( v ) ;
		} ;
	} ;
	:= m ;
} ;


//** Between 2 consecutive values
list_min_diff := ( list ) -> {
//** Min difference between two consecutive elements
	md := list [ 1 ] - list [ 0 ] ;
	i := 0 ;
	while ( ( i+1 ) < ( #list ) ) {
		if ( list [ i+1 ] - list [ i ] < md ) {
			md := list [ i+1 ] - list [ i ] ;
		} ;
		i := i + 1 ;
	} ;
	:= md ;
} ;



//** Returns first index where the value is found
//**  otherwise -1 (not found)
.list_get_index .= ( list , val ) -> {
	index := 0 ;
	foreach ( elem : list ) {
		if ( elem == val ) {
			:= index ;
		} ;
		index := index + 1 ;
	} ;
	:= -1 ;
} ; 



/** To get a sorted list of the elements without repetition.
 */
.list_sort_unique .= ( list ) -> {
	res := [] ;
	foreach ( val : list ) {
		res := list_sorted_unique_insert ( res , val ) ;
	} ;
	:= res ;
} ;



/*
 * LIST UNIQUE
 */
 
.list_unique_add .= ( list , val ) -> {
	is_not_inside := true ;
	foreach ( v : list ) {
		if ( v == val ) {
			is_not_inside := false ;
		} ;
	} ;
	if ( is_not_inside ) {
		:= list _ [ val ] ;
	} else {
		:= list ;
	} ;
} ;


/*
 * LIST SORTED UNIQUE
 */

.list_sorted_unique_insert .= ( orered_list , elem ) -> {
	res := [] ;
	is_not_inserted := true ;
	foreach ( value : orered_list ) {
		if ( is_not_inserted ) {
			if ( elem == value ) {
				is_not_inserted := false ;
			} ;
			if ( elem < value ) {
				res := res _ elem ;
				is_not_inserted := false ;
			} ;
		} ;
		res := res _ value ;
	} ;
	if ( is_not_inserted ) {
		res := res _ elem ;
	} ;
	:= res ;
} ;


.list_sorted_unique_list_all_sublist .= ( list ) -> {
 	R := [ [] ] ;
 	foreach ( s : list ) {
 		l := [] ;
 		foreach ( r : R ) {
 			l := l _ [ r ] _ [ r _ [ s ] ] ;
 		} ;
 		R := l ;
 	} ;
 	:= R ;
} ;




// A list of zeros with specified length
.zeros .= (len) -> {
    r := [] ;
    .i := 0 ;
    while ( i < len ) {
        r := r _ 0 ;
        i := i + 1 ;
    } ;
    := r ;
} ;


// A sublist of a list
.sub_list .= (list, start, len) -> {
    r := [] ;
    .i := 0 ;
    while ( i < len ) {
        r := r _ list[i+start] ;
        i := i + 1 ;
    } ;
    := r ;
} ;


.list_unique_eq .= (list1, list2) -> {

    //println("list_eq: " & list1 & " " & list2) ;

    .l1 := list_sort_unique(list1) ;
    .l2 := list_sort_unique(list2) ;

    .r := true ;
    if (#l1 != #l2) {
        r := false ;
    } ;
    .i := 0 ;
    while (i < #l1 && i < #l2) {
        if (l1[i] != l2[i]) {
            r := false ;
            i := #l1 ;
        } ;
        i := i + 1 ;
    } ;
    //println("list_eq done " & r) ;
    := r ;
} ;


.is_in_list .= (list, m) -> {
    .r := false ;
    foreach (l : list) {
        if (l == m) {
            r := true ;
        } ;
    } ;
    := r ;
} ;


.list_copy .= (l) -> {
    .r := [] ;
    foreach (x : l) {
        r := r _ [x] ;
    } ;
    := r ;
} ;


.list_copy_copy .= (l) -> {
    .r := [] ;
    foreach (x : l) {
        r := r _ [list_copy(x)] ;
    } ;
    := r ;
} ;


.list_xnd .= (set, x) -> {
    r := [] ;
    foreach (s : set) {
        r := r _ [s[x]] ;
    } ;
    := r ;
} ;


.set_minus .= (lst, a) -> {
    .r := [] ;
    foreach (l : lst) {
        if (l != a) {
            r := r _ [l] ;
        } ;
    } ;
    :=r ;
} ;


.recursive_call_on_every_subset_aux .= (set, f, s, i) -> {
    //println("rec call " & s & " " & i ) ;
    if (i == #set) {
        f(s) ;
    } else {
        .x := s ;
        recursive_call_on_every_subset_aux(set, f, x, i+1) ;
        x := s _ set[i] ;
        recursive_call_on_every_subset_aux(set, f, x, i+1) ;
    } ;
} ;


.recursive_call_on_every_subset .= (set, f) -> {
    recursive_call_on_every_subset_aux(set, f, [], 0) ;
} ;

