//
//  This is a specific file for testing the implementation of the intrinsically universal signal machine.
//
//  This file provide a basic example: one signal machine, one initial configuration and then
//  one space-time diagrams for the simulated and one for the simulation are output.
//

// Load the necessary libraries for the simulation
load "./lib_agc_iuniv_simulate_test.agc" ;



// SIGNAL MACHINE CREATION

.signal_machine .= create_signal_machine {

	// META-SIGNAL Definitions
	// add_meta_signal (  <id>  , <speed >  ) { <optional parameters> }  ;
	.ms1 .= add_meta_signal ( "m1" , 1 / 2 ) { color => Black ; } ;
	.ms2 .= add_meta_signal ( "m2" , -1 ) { color => Blue ; } ;
	.ms3 .= add_meta_signal ( "m3" , 1 ) { color => Red ; } ;
	.ms4 .= add_meta_signal ( "m4" , 0 ) { color => Green ; } ;

	// RULE Definitions
	// <meta-signal list>   -->  <meta-signal list>
	[ ms1 , ms2 ] --> [ "m3" ] ;  // Meta-signals can also be referred by their id
	[ ms3 , "m2" ] --> [ "m4" ] ;
} ;


// INITIAL CONFIGURATION CREATION

.configuration_to_simulate.= signal_machine . create_configuration {
	// pointed notation on the signal machine
	// <meta-signal>  @  <rational>    
	"m1" @ 10 ;
	"m2" @ 40 ;
	"m2" @ 80 ;	
} ;


// RUN THE SIMULATOR AND GENERATE PICTURES

generate_both_diagram (
	configuration_to_simulate ,
	400 , // number of iterations for the simulated
	4000 , // number of iterations for the simulation
	DIR_OUT  _ "test_1" ,   // File name without suffix 
	{} ,  // Parameters for the space-time diagram output for the simulated
	{   // Parameters for the space-time diagram output for the simulation
		// To scale the picture
		scale := 1 / 2 ;
		//	scale_x := 1 ;      // please avoid using both scale and scale_x
		//	scale_y := 2 / 3 ;  // the order of reading/applying these parameters is undefined
		// To clip the picture
		clip_left := -10 ;
		// clip_right := 110 ;
		// clip_end := 100;
		// clip_start :=  0 ;
	}
) ;
