//
//  This is a specific file for testing the implementation of the intrinsically universal signal machine.
//
//  This file provide a basic example: one signal machine, one initial configuration and then
//  one space-time diagrams for the simulated and one for the simulation are output.
//


load "./lib_agc_iuniv_simulate_test.agc" ;


// SIGNAL MACHINE CREATION
.signal_machine .= create_signal_machine {

	// META-SIGNAL Definitions
	.ms1 .= add_meta_signal ( "m1" , 1 / 2 ) { color => Black ; } ;
	.ms2 .= add_meta_signal ( "m2" , -1 ) { color => Blue ; } ;
	.ms3 .= add_meta_signal ( "m3" , 1 ) { color => Red ; } ;
	.ms4 .= add_meta_signal ( "m4" , 0 ) { color => Green ; } ;
	add_meta_signal ( "dummy1" , 0 ) { color => DarkYellow ; } ;
	add_meta_signal ( "dummy2" , 0 ) { color => DarkYellow ; } ;
	add_meta_signal ( "dummy3" , -1 ) { color => DarkYellow ; } ;
	add_meta_signal ( "dummy4" , -1/2 ) { color => DarkYellow ; } ;
	add_meta_signal ( "dummy5" , 1/2 ) { color => DarkYellow ; } ;
	add_meta_signal ( "dummy6" , 1 ) { color => DarkYellow ; } ;
	add_meta_signal ( "dummy7" , 1 ) { color => DarkYellow ; } ;

	// RULE Definitions
	[ ms1 , ms2 ] --> [ "m3" ] ;  // Meta-signals can also be referred by their id
	[ ms3 , "m2" ] --> [  ms1 , ms2 , "m3", "m4" ] ;
	[ ms3 , ms4 ] --> [] ;	
	[ "dummy1" ,"dummy3" ] -->	[ "dummy5" ,"dummy6" ] ;
	[ "dummy1" ,"dummy4" ] -->	[ "dummy5" ,"dummy6" ] ;
} ;


// INITIAL CONFIGURATION CREATION

.configuration_to_simulate.= signal_machine . create_configuration {
	"m1" @ 10 ;
	"m2" @ 50 ;
	"m2" @ 90 ;	
	"m3" @ 110 ;	
	"m2" @ 190 ;	
} ;


generate_both_diagram (
	configuration_to_simulate ,
	400 ,
	40000 ,
	DIR_OUT  _ "test_2" , {
		scale := 1/5 ;
		clip_left :=  0 ;
		clip_right := 200 ;
		clip_start := 0  ;
		clip_end   :=  200 ;
	} , {
		scale := 1/5 ;
		clip_left :=  0 ;
		clip_right := 200 ;
		clip_start := 0  ;
		clip_end   :=  200 ;
} ) ;
