//
//  This is a specific file for testing the implementation of the intrinsically universal signal machine.
//
//  This file provide a basic example: one signal machine, one initial configuration and then
//  one space-time diagrams for the simulated and one for the simulation are output.
//

// FAST SPEED version of test 2


load "./lib_agc_iuniv_simulate_test.agc" ;



// SIGNAL MACHINE CREATION
.signal_machine .= create_signal_machine {

	// META-SIGNAL Definitions
	.ms1 .= add_meta_signal ( "m1" , 5 / 2 ) { color => Black ; } ;
	.ms2 .= add_meta_signal ( "m2" , -5 ) { color => Blue ; } ;
	.ms3 .= add_meta_signal ( "m3" , 5 ) { color => Red ; } ;
	.ms4 .= add_meta_signal ( "m4" , 0 ) { color => Green ; } ;

	// RULE Definitions
	[ ms1 , ms2 ] --> [ "m3" ] ;  // Meta-signals can also be referred by their id
	[ ms3 , "m2" ] --> [  ms1 , ms2 , "m3", "m4" ] ;
	[ ms3 , ms4 ] --> [] ;
	
} ;


// INITIAL CONFIGURATION CREATION

.configuration_to_simulate.= signal_machine . create_configuration {
	"m1" @ 10 ;
	"m2" @ 50 ;
	"m2" @ 90 ;	
	"m3" @ 110 ;	
	"m2" @ 190 ;	
} ;


// to provide the same arguments twice
arg .= {
	scale := 1 ;
	clip_left :=  0 ;
	clip_right := 200 ;
	clip_start := 0  ;
	clip_end   :=  60 ;
} ;
	
generate_both_diagram (
	configuration_to_simulate ,
	400 ,
	11000 ,
	DIR_OUT  _ "test_3" , 
	arg,
	arg
 ) ;

