//
//  This is a specific file for testing the implementation of the intrinsically universal signal machine.
//
//  This file provide a basic example: one signal machine, one initial configuration and then
//  one space-time diagrams for the simulated and one for the simulation are output.
//
// This is a simulation of a continuous version of a firing squad synchronization.
// The number of signal increases exponentially as iterations increase.
// It uses exact 3-signals collisions.

load "./lib_agc_iuniv_simulate_test.agc" ;


println ( "This one is long" ) ;


// SIGNAL MACHINE CREATION
.signal_machine .= create_signal_machine {

	// META-SIGNAL Definitions
	border := add_meta_signal ( "border" , 0) { color := Red ; };
  	up_right := add_meta_signal ( "up_right" , 1/3 ){ color := Blue ; } ;
  	bot_right := add_meta_signal ( "bot_right" , 10/10 ){ color := Green ; } ;
  	up_left := add_meta_signal ( "up_left" , -1 / 3 ){ color := Yellow ; } ;
  	bot_left := add_meta_signal ( "bot_left" , -10/10 ){ color := Brown ; } ;
	launch := add_meta_signal ( "launch" , 1) { color := Black ; } ;

	// RULE Definitions
	[ launch , border ] --> [border , up_right , bot_right];
		[ bot_right , border ] --> [ bot_left , border ] ;
	[ border , bot_left ] --> [ border , bot_right ] ;
	[ bot_right , border , bot_left ] --> [ bot_left , border , bot_right ] ;
	[ up_right , bot_left ] --> [ border , up_right , bot_right , bot_left , up_left] ;
	[ bot_right , up_left ] --> [ border , up_right , bot_right , bot_left , up_left] ;
	[ bot_right , bot_left ] --> [ border , bot_right , up_right , bot_left , up_left] ;
		
} ;


// INITIAL CONFIGURATION CREATION

.configuration_to_simulate.= signal_machine . create_configuration {
	signal_machine . launch @ -10 ;   // Add a signal at a position
	signal_machine . border @ 0 ;
	signal_machine . border @ 50 ;
} ;


generate_both_diagram (
	configuration_to_simulate ,
	14 ,
	 80000 ,
	DIR_OUT  _ "test_4" , {
	} , {
	clip_left := -30 ;
	clip_right := 90 ;
} ) ;

