//
//  This is a specific file for testing the implementation of the intrinsically universal signal machine.
//
//  This file provide a basic example: one signal machine, one initial configuration and then
//  one space-time diagrams for the simulated and one for the simulation are output.
//


load "./lib_agc_iuniv_simulate_test.agc" ;


// SIGNAL MACHINE CREATION
.signal_machine .= create_signal_machine {

	// META-SIGNAL Definitions
	.ms1 .= add_meta_signal ( "m1" , -2 ) { color => Black ; } ;
	.ms2 .= add_meta_signal ( "m2" , -2/2 ) { color => Blue ; } ;
	.ms3 .= add_meta_signal ( "m3" , 0) { color => Red ; } ;
	.ms4 .= add_meta_signal ( "m4" , 2/2 ) { color => Green ; } ;
	.ms5 .= add_meta_signal ( "m5" , 2 ) { color => Red ; } ;

	// RULE Definitions

	[ ms1 , ms2 ] --> [ "m3" ] ;  // Meta-signals can also be referred by their id
	[ ms3 , "m2" ] --> [  ms1 , ms2 , "m3", "m4" ] ;
	[ ms1 , ms3 ] --> [ ms2 ] ;
	[ ms5 , ms3 ] --> [] ;
	[ ms4 , ms2 ] --> [ ms3 ] ;
	
	[ ms5 , ms3 , ms1] --> [ ms2 , ms4 ] ;
} ;


// INITIAL CONFIGURATION CREATION

.configuration_to_simulate.= signal_machine . create_configuration {
	"m5" @ 10 ;
	"m3" @ 50 ;	
	"m2" @ 78 ;
	
	"m4" @ 122 ;
	"m3" @ 150 ;	
	"m1" @ 195 ;
	
	"m5" @ 240 ;
	"m3" @ 280 ;	
	"m1" @ 320 ;
} ;


generate_both_diagram (
	configuration_to_simulate ,
	400 ,
	16000 ,
	DIR_OUT  _ "test_5" , {
		scale_y := 2 ; 
		clip_end   :=  40 ; 
		clip_left :=  0 ;
		clip_right := 350 ;
	} , {
		scale_x :=  1 ;  
		scale_y :=  2 ;  
		clip_left :=  0 ;
		clip_right := 350 ;
		clip_start := 0  ;
		clip_end   := 31 ;
} ) ;
