//
//  This is a specific file for testing the implementation of the intrinsically universal signal machine.
//
//  This file provide a basic example: one signal machine, one initial configuration and then
//  one space-time diagrams for the simulated and one for the simulation are output.
//

//This a simple accumulation on one point 


load "./lib_agc_iuniv_simulate_test.agc" ;


// SIGNAL MACHINE CREATION
.signal_machine .= create_signal_machine {

	// META-SIGNAL Definitions
	.bl .= add_meta_signal ( "bl" , 1/2 ) { color => Black ; } ;
	.br .= add_meta_signal ( "br" , -1/2 ) { color => DarkGreen ; } ;
	.zig .= add_meta_signal ( "zig" , 3) { color => Blue ; } ;
	.zag .= add_meta_signal ( "zag" , -3 ) { color => Red ; } ;

	// RULE Definitions
	[ zig , br ] --> [ br, zag ] ;
	[ zag , bl ] --> [  bl , zig ] ;	
} ;


// INITIAL CONFIGURATION CREATION

.configuration_to_simulate.= signal_machine . create_configuration {
	"bl" @ -50 ;
	"zig" @ 0 ;	
	"br" @ 50 ;
} ;



generate_both_diagram (
	configuration_to_simulate ,
	40 ,
	20000 ,
	DIR_OUT  _ "test_7" , 
	{} ,
	{} ) ;
