
// Load the library for list manipulation
load ".//lib_list.agc" ;


// Returns the minimum of two comparable values
.min .= ( a , b ) -> {
	if ( a < b ) {
		:= a ;
	} ;
	:= b ;  // return 
} ;

// Returns the maximum of two comparable values
.max .= ( a , b ) -> {
	if ( a < b ) {
		:= b ;
	} ;
	:= a ;
} ;

// Returns the absolute value of a number
.abs .= ( x ) -> {
	if ( x < 0 ) {
		:= -x ;
	} ;
	:= x ;
} ;

// Return the concatenations of the representation (strings) of the value in the list
// separated and surrounded by "."
.setToStr .= ( A ) -> {
	R := "." ;
	foreach ( a: A ) {
		R := R _ a _ "." ;
	} ;
	:= R ;
} ;
