/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms;

import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import bridge.interfaces.Map;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class StepAlgo<V, E extends Link<V>>
extends Observable
implements Runnable {
    private static final String PAUSE_NOTIFICATION_MESSAGE = "PAUSE";
    private static final String END_NOTIFICATION_MESSAGE = "END";
    private static final String DISPLAY_GRAPH_NEW_WINDOW_MESSAGE = "DISPLAY_GRAPH_NEW_WINDOW";
    private static final String EDGES_LABEL_MESSAGE = "EDGES_LABEL";
    private static final String VERTICES_LABEL_MESSAGE = "VERTICES_LABEL";
    private boolean end_ = false;
    private volatile boolean blockMode;
    private final boolean demoMode;
    private int time_;
    private Lock aLock = new ReentrantLock();
    private Condition condVar = this.aLock.newCondition();

    public StepAlgo(boolean demoMode) {
        this.blockMode = demoMode;
        this.demoMode = demoMode;
        this.time_ = 1000;
    }

    public void setTime(int time) {
        this.time_ = time;
    }

    public Thread start() {
        this.end_ = false;
        this.blockMode = this.demoMode;
        if (this.demoMode) {
            Thread t = new Thread(this);
            t.start();
            return t;
        }
        this.run();
        return null;
    }

    public void nextStep() {
        this.aLock.lock();
        this.condVar.signal();
        this.aLock.unlock();
    }

    public final boolean isEnded() {
        return this.end_;
    }

    public void ends() {
        this.aLock.lock();
        this.end_ = true;
        this.aLock.unlock();
        if (this.demoMode) {
            this.notifyEnd();
        }
    }

    public void setPauseMode(boolean pauseMode) {
        this.aLock.lock();
        this.blockMode = pauseMode;
        this.aLock.unlock();
    }

    public final boolean getStepMode() {
        return this.blockMode && this.demoMode;
    }

    public final boolean getDemoMode() {
        return this.demoMode;
    }

    public final void pause() {
        if (this.demoMode) {
            block8: {
                this.aLock.lock();
                try {
                    try {
                        if (this.blockMode) {
                            this.condVar.await();
                        } else {
                            Thread.sleep(this.time_);
                        }
                    }
                    catch (InterruptedException e) {
                        System.err.println("await : " + e.getMessage());
                        this.aLock.unlock();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.aLock.unlock();
                    throw throwable;
                }
                this.aLock.unlock();
            }
            this.notifyPause();
        }
    }

    @Override
    public abstract void run();

    private void notifyPause() {
        if (this.getDemoMode()) {
            this.setChanged();
            this.notifyObservers(new StepAlgoMessage(PAUSE_NOTIFICATION_MESSAGE));
        }
    }

    private void notifyEnd() {
        if (this.getDemoMode()) {
            this.setChanged();
            this.notifyObservers(new StepAlgoMessage(END_NOTIFICATION_MESSAGE));
        }
    }

    protected final void notifyGraphDisplayRequest(Graph<V, E> g) {
        if (this.getDemoMode()) {
            Object[] args = new Object[]{g, "Default Name"};
            this.setChanged();
            this.notifyObservers(new StepAlgoMessage(DISPLAY_GRAPH_NEW_WINDOW_MESSAGE, args));
        }
    }

    protected final void notifyGraphDisplayRequest(Graph<V, E> g, String name) {
        if (this.getDemoMode()) {
            Object[] args = new Object[]{g, name};
            this.setChanged();
            this.notifyObservers(new StepAlgoMessage(DISPLAY_GRAPH_NEW_WINDOW_MESSAGE, args));
        }
    }

    protected final void notifyLabelEdgesRequest(Graph<V, E> g, Map m, Object context, String label) {
        if (this.getDemoMode()) {
            Object[] args = new Object[]{g, m, context, label.split(System.getProperty("line.separator"))};
            this.setChanged();
            this.notifyObservers(new StepAlgoMessage(EDGES_LABEL_MESSAGE, args));
        }
    }

    protected final void notifyLabelVerticesRequest(Graph<V, E> g, Map m, Object context, String label) {
        if (this.getDemoMode()) {
            Object[] args = new Object[]{g, m, context, label.split(System.getProperty("line.separator"))};
            this.setChanged();
            this.notifyObservers(new StepAlgoMessage(VERTICES_LABEL_MESSAGE, args));
        }
    }

    public class StepAlgoMessage {
        private final String type;
        private final Object[] args;

        StepAlgoMessage(String type, Object[] args) {
            this.type = type;
            this.args = args;
        }

        StepAlgoMessage(String type) {
            this(type, null);
        }

        public final StepAlgoMessageType getType() {
            if (this.type.equals(StepAlgo.PAUSE_NOTIFICATION_MESSAGE)) {
                return StepAlgoMessageType.PAUSE_NOTIFICATION;
            }
            if (this.type.equals(StepAlgo.END_NOTIFICATION_MESSAGE)) {
                return StepAlgoMessageType.END_NOTIFICATION;
            }
            if (this.type.equals(StepAlgo.DISPLAY_GRAPH_NEW_WINDOW_MESSAGE)) {
                return StepAlgoMessageType.DISPLAY_GRAPH_NEW_WINDOW;
            }
            if (this.type.equals(StepAlgo.EDGES_LABEL_MESSAGE)) {
                return StepAlgoMessageType.EDGES_LABEL;
            }
            if (this.type.equals(StepAlgo.VERTICES_LABEL_MESSAGE)) {
                return StepAlgoMessageType.VERTICES_LABEL;
            }
            assert (false);
            return null;
        }

        public Object[] getMessageArgs() {
            return this.args;
        }
    }

    public static enum StepAlgoMessageType {
        PAUSE_NOTIFICATION,
        END_NOTIFICATION,
        DISPLAY_GRAPH_NEW_WINDOW,
        EDGES_LABEL,
        VERTICES_LABEL;

    }
}

