/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common;

import bridge.abstractClasses.AbstractScalar;
import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import bridge.interfaces.Map;
import bridge.interfaces.Path;
import java.util.HashMap;
import tools.dataStructures.Fifo;
import tools.dataStructures.Pair;

public abstract class AugmentingPath<V, E extends Link<V>, G extends Graph<V, E>> {
    private G graph_;
    private Map capacityMap_;
    private Map costMap_;
    private String capacityName_ = "Capacity";
    private Object capacityContext_ = null;
    private String costName_ = "Cost";
    private Object costContext_ = null;
    private AbstractScalar pathFlow_ = null;

    protected abstract Path<V, E> createPath();

    protected abstract AbstractScalar createInteger(int var1);

    public AugmentingPath(G g) {
        this.graph_ = g;
    }

    public void setCapacityMap(Map capacityMap) {
        this.capacityMap_ = capacityMap;
    }

    public void setCapacityName(String capacityName) {
        this.capacityName_ = capacityName;
    }

    public void setCapacityContext(Object capacityContext) {
        this.capacityContext_ = capacityContext;
    }

    public void setCostMap(Map costMap) {
        this.costMap_ = costMap;
    }

    public void setCostName(String costName) {
        this.costName_ = costName;
    }

    public void setCostContext(Object costContext) {
        this.costContext_ = costContext;
    }

    private AbstractScalar getEdgeCapacity(Link<V> e) {
        return this.capacityMap_.getValue(e, this.capacityName_, this.capacityContext_ == null ? e : this.capacityContext_);
    }

    private AbstractScalar getEdgeCost(Link<V> e) {
        if (this.costMap_ == null) {
            return this.createInteger(1);
        }
        return this.costMap_.getValue(e, this.costName_, this.costContext_ == null ? e : this.costContext_);
    }

    private AbstractScalar getVertexDistance(HashMap<Object, Pair<AbstractScalar, AbstractScalar>> orderAndFlow, Object v) {
        return orderAndFlow.get(v).getKey();
    }

    private AbstractScalar getVertexFlow(HashMap<Object, Pair<AbstractScalar, AbstractScalar>> orderAndFlow, Object v) {
        return orderAndFlow.get(v).getValue();
    }

    public Path<V, E> getBestPath(V source, V destination) {
        Path result = this.createPath();
        Fifo<Object> fifo = new Fifo<Object>();
        HashMap<Object, Link> father = new HashMap<Object, Link>();
        HashMap<Object, Pair<AbstractScalar, AbstractScalar>> orderAndFlow = new HashMap<Object, Pair<AbstractScalar, AbstractScalar>>();
        for (Link current : this.graph_.outEdges(source)) {
            AbstractScalar edgeCapacity = this.getEdgeCapacity(current);
            if (edgeCapacity.equals(edgeCapacity.zero())) continue;
            V currentVertex = current.getOpposite(source);
            if (currentVertex == destination) {
                this.pathFlow_ = edgeCapacity;
            }
            Pair<AbstractScalar, AbstractScalar> p = new Pair<AbstractScalar, AbstractScalar>(this.getEdgeCost(current), edgeCapacity);
            orderAndFlow.put(currentVertex, p);
            fifo.put(currentVertex);
            father.put(currentVertex, current);
        }
        while (!fifo.isEmpty()) {
            Object currentVertex = fifo.get();
            AbstractScalar flow = this.getVertexFlow(orderAndFlow, currentVertex);
            AbstractScalar distance = this.getVertexDistance(orderAndFlow, currentVertex);
            for (Link currentEdge : this.graph_.outEdges(currentVertex)) {
                Object currentOpposite;
                AbstractScalar edgeCapacity = this.getEdgeCapacity(currentEdge);
                if (edgeCapacity.compareTo(edgeCapacity.zero()) == 0 || orderAndFlow.containsKey(currentOpposite = currentEdge.getOpposite(currentVertex)) && (this.getVertexFlow(orderAndFlow, currentOpposite).compareTo(edgeCapacity) >= 0 || this.getVertexFlow(orderAndFlow, currentOpposite).compareTo(flow) >= 0 || this.getVertexDistance(orderAndFlow, currentOpposite).compareTo(distance.clone().add(this.getEdgeCost(currentEdge))) != 0)) continue;
                orderAndFlow.put(currentOpposite, new Pair<AbstractScalar, AbstractScalar>(distance.clone().add(this.getEdgeCost(currentEdge)), AbstractScalar.Min(edgeCapacity, flow)));
                father.put(currentOpposite, currentEdge);
                if (currentOpposite != destination) {
                    fifo.put(currentOpposite);
                    continue;
                }
                this.pathFlow_ = AbstractScalar.Min(edgeCapacity, flow).clone();
            }
        }
        if (orderAndFlow.containsKey(destination)) {
            V lastVertex = destination;
            while (!result.contains(source)) {
                Link currentEdge = (Link)father.get(lastVertex);
                result.concat(currentEdge);
                lastVertex = currentEdge.getOpposite(lastVertex);
            }
        }
        return result;
    }

    public AbstractScalar getFlow() {
        return this.pathFlow_;
    }
}

