/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common;

import bridge.interfaces.Graph;
import bridge.interfaces.HierarchicalSet;
import bridge.interfaces.Link;
import java.util.Iterator;

public abstract class CopyGraph<V, E extends Link<V>, G extends Graph<V, E>> {
    protected abstract HierarchicalSet<E> createEdgeSet(HierarchicalSet<V> var1);

    protected abstract HierarchicalSet<E> createSubEdgeSet(HierarchicalSet<E> var1);

    protected abstract HierarchicalSet<V> createVertexSet();

    protected abstract HierarchicalSet<V> createVertexSet(HierarchicalSet<V> var1);

    public G copyGraph(G g) {
        HierarchicalSet<V> newVertexSet = g.vertexSet().getSuperSet() != null ? this.createVertexSet(g.vertexSet().getSuperSet()) : this.createVertexSet();
        Iterator vertexIt = g.vertexSet().iterator();
        while (vertexIt.hasNext()) {
            newVertexSet.add(vertexIt.next());
        }
        HierarchicalSet<Link<Object>> newEdgeSet = g.edgeSet().getSuperSet() != null ? this.createSubEdgeSet(g.edgeSet().getSuperSet()) : this.createEdgeSet(newVertexSet);
        Iterator edgeIt = g.edgeSet().iterator();
        while (edgeIt.hasNext()) {
            newEdgeSet.add((Link)edgeIt.next());
        }
        G result = this.createGraph(newEdgeSet);
        return result;
    }

    protected abstract G createGraph(HierarchicalSet<E> var1);
}

