/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common;

import bridge.abstractClasses.AbstractScalar;
import bridge.algorithms.common.CopyGraph;
import bridge.algorithms.common.FindElementaryCyclesFrom;
import bridge.interfaces.Cycle;
import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import bridge.interfaces.Map;
import java.util.HashSet;

public abstract class FindElementaryCycles<V, E extends Link<V>, G extends Graph<V, E>> {
    private G g_;
    private Map edgeCost_;
    private AbstractScalar maxCost_;
    private HashSet<Cycle<V, E>> solutions_;
    private String edgeCostName = "EDGE_COST_NAME";
    private Object edgeCostContext_;

    protected abstract CopyGraph<V, E, G> createCopyGraph();

    protected abstract FindElementaryCyclesFrom<V, E, G> createFindElementaryCyclesFrom(G var1, V var2, Map var3, AbstractScalar var4);

    public FindElementaryCycles(G g, Map edgeCost, AbstractScalar maxCost) {
        this.g_ = g;
        this.edgeCost_ = edgeCost;
        this.maxCost_ = maxCost;
        this.edgeCostContext_ = g;
        this.solutions_ = new HashSet();
    }

    public FindElementaryCycles(G g, AbstractScalar maxCost) {
        this(g, null, maxCost);
    }

    public void run() {
        CopyGraph<V, E, G> copyGraph = this.createCopyGraph();
        G copy = copyGraph.copyGraph(this.g_);
        for (Object currentVertex : this.g_.vertexSet()) {
            FindElementaryCyclesFrom subProblem = this.createFindElementaryCyclesFrom(copy, currentVertex, this.edgeCost_, this.maxCost_);
            subProblem.setEdgeCostName(this.edgeCostName);
            subProblem.setEdgeCostContext(this.edgeCostContext_);
            subProblem.run();
            this.solutions_.addAll(subProblem.getCycles());
            copy.removeVertex(currentVertex);
        }
    }

    public void setEdgeCostName(String name) {
        this.edgeCostName = name;
    }

    public void setEdgeCostContext(Object context) {
        this.edgeCostContext_ = context;
    }

    public HashSet<Cycle<V, E>> getSolution() {
        return this.solutions_;
    }
}

