/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common.shortestPath;

import bridge.algorithms.common.shortestPath.ShortestPathWithSingleOrigin;
import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import java.util.Iterator;

public abstract class BellmanFord<V, E extends Link<V>, G extends Graph<V, E>>
extends ShortestPathWithSingleOrigin<V, E, G> {
    private boolean findNegativeCycle = false;

    public BellmanFord(G g, boolean byStep) {
        super(g, byStep);
    }

    public BellmanFord(G g) {
        this(g, false);
    }

    @Override
    public void run() {
        if (this.infiniteDistance == null) {
            throw new RuntimeException("You must specify infiniteDistance with setInfiniteDistance method");
        }
        this.Initialize(this.infiniteDistance.zero().clone());
        int vertexSetSize = this.g_.vertexSet().size();
        int i = 0;
        while (i < vertexSetSize) {
            Iterator edgeIt = this.g_.edgeSet().iterator();
            this.pause();
            while (edgeIt.hasNext()) {
                Link currentEdge = (Link)edgeIt.next();
                Object v0 = currentEdge.toArray()[0];
                Object v1 = currentEdge.toArray()[1];
                if (currentEdge.leavesFrom(v0)) {
                    this.updateVerticesDistance(v0, v1, currentEdge);
                }
                if (!currentEdge.leavesFrom(v1)) continue;
                this.updateVerticesDistance(v1, v0, currentEdge);
            }
            ++i;
        }
        for (Link currentEdge : this.g_.edgeSet()) {
            Object v0 = currentEdge.toArray()[0];
            Object v1 = currentEdge.toArray()[1];
            if (!currentEdge.leavesFrom(v0) || this.getDistanceTo(v1).compareTo(this.getDistanceTo(v0).clone().add(this.getDistanceMap().getValue(currentEdge, this.getDistanceName(), this.getDistanceContext() == null ? currentEdge : this.getDistanceContext()))) <= 0) continue;
            this.findNegativeCycle = true;
            this.ends();
            return;
        }
        this.ends();
    }

    public boolean foundNegativeCycle() {
        return this.findNegativeCycle;
    }
}

