/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common.shortestPath;

import bridge.abstractClasses.AbstractScalar;
import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import bridge.interfaces.Map;
import bridge.interfaces.Path;
import java.util.Iterator;

public abstract class FloydWarshall<V, E extends Link<V>, G extends Graph<V, E>> {
    private G graph_;
    private Map lengthMap_;
    private String lengthName_;
    private Object lengthContext_;
    private AbstractScalar lengthMax_;
    private MatrixGraph shortestPathAlgo_;
    private boolean shortestPathComputed_ = false;

    public FloydWarshall(G graph) {
        this.graph_ = graph;
    }

    protected abstract Path<V, E> createPath();

    public boolean computeShortestPath() {
        this.shortestPathComputed_ = true;
        this.shortestPathAlgo_ = new MatrixGraph(this, this.graph_);
        return this.shortestPathAlgo_.computeShortestPath();
    }

    public AbstractScalar getDistance(V source, V destination) {
        if (!this.shortestPathComputed_) {
            throw new IllegalStateException("You must call computeShortestPath before");
        }
        return this.shortestPathAlgo_.getDistance(source, destination);
    }

    public Path<V, E> getShortestPath(V source, V destination) {
        if (!this.shortestPathComputed_) {
            throw new IllegalStateException("You must call computeShortestPath before");
        }
        if (this.shortestPathAlgo_.getDistance(source, destination).compareTo(this.lengthMax_) == 0) {
            return null;
        }
        Path<V, Link> result = this.createPath();
        Object current = destination;
        while (current != source) {
            Object prec = this.shortestPathAlgo_.getFather(source, current);
            assert (prec != null);
            assert (this.graph_ != null);
            assert (this.graph_.outEdges((Object)prec) != null);
            Iterator goodEdgeIt = this.graph_.outEdges((Object)prec).iterator();
            Link goodEdge = null;
            while (goodEdgeIt.hasNext()) {
                goodEdge = (Link)goodEdgeIt.next();
                if (goodEdge.leadsTo(current)) break;
            }
            result.concat(goodEdge);
            current = prec;
        }
        return result;
    }

    public void setDistanceMap(Map distance) {
        this.lengthMap_ = distance;
    }

    public void setDistanceContext(Object distanceContext) {
        this.lengthContext_ = distanceContext;
    }

    public void setDistanceName(String distanceName) {
        this.lengthName_ = distanceName;
    }

    public void setInfiniteDistance(AbstractScalar infiniteDistance) {
        this.lengthMax_ = infiniteDistance.clone();
    }

    private static class MatrixGraph {
        private Object[] graphVertices_;
        private AbstractScalar[][] edges_;
        private Object[][] shortestsPaths_;
        final /* synthetic */ FloydWarshall this$0;

        public MatrixGraph(G g) {
            this.this$0 = var1_1;
            this.graphVertices_ = new Object[g.vertexSet().size()];
            Iterator verticesIt = g.vertexSet().iterator();
            int i = 0;
            while (verticesIt.hasNext()) {
                this.graphVertices_[i] = verticesIt.next();
                ++i;
            }
            this.edges_ = this.initAdjacenceTable();
            this.shortestsPaths_ = new Object[this.graphVertices_.length][this.graphVertices_.length];
            for (Link current : g.edgeSet()) {
                V[] vertices = current.toArray();
                AbstractScalar currentDistance = ((FloydWarshall)var1_1).lengthMap_.getValue(current, ((FloydWarshall)var1_1).lengthName_, ((FloydWarshall)var1_1).lengthContext_ == null ? current : ((FloydWarshall)var1_1).lengthContext_);
                assert (currentDistance != null);
                int index0 = this.getIndexOfVertex(vertices[0]);
                int index1 = this.getIndexOfVertex(vertices[1]);
                if (current.leadsTo(vertices[0])) {
                    this.edges_[index1][index0] = AbstractScalar.Min(currentDistance, this.edges_[index1][index0]);
                    this.shortestsPaths_[index1][index0] = vertices[1];
                }
                if (!current.leadsTo(vertices[1])) continue;
                this.edges_[index0][index1] = AbstractScalar.Min(currentDistance, this.edges_[index0][index1]);
                this.shortestsPaths_[index0][index1] = vertices[0];
            }
        }

        private AbstractScalar[][] initAdjacenceTable() {
            AbstractScalar[][] result = new AbstractScalar[this.graphVertices_.length][this.graphVertices_.length];
            int i = 0;
            while (i < this.graphVertices_.length) {
                int j = 0;
                while (j < this.graphVertices_.length) {
                    result[i][j] = i != j ? this.this$0.lengthMax_ : this.this$0.lengthMax_.zero();
                    ++j;
                }
                ++i;
            }
            return result;
        }

        boolean computeShortestPath() {
            int k = 0;
            while (k < this.graphVertices_.length) {
                int i = 0;
                while (i < this.graphVertices_.length) {
                    int j = 0;
                    while (j < this.graphVertices_.length) {
                        AbstractScalar tmp = this.edges_[i][k].clone().add(this.edges_[k][j]);
                        if (tmp.compareTo(this.edges_[i][j]) < 0) {
                            this.edges_[i][j] = tmp;
                            this.shortestsPaths_[i][j] = this.shortestsPaths_[k][j];
                        }
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
            return false;
        }

        private V getFather(V shortestPathRoot, V vertex) {
            return this.shortestsPaths_[this.getIndexOfVertex(shortestPathRoot)][this.getIndexOfVertex(vertex)];
        }

        private int getIndexOfVertex(V v) {
            int i = 0;
            while (i < this.graphVertices_.length) {
                if (this.graphVertices_[i] == v) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private AbstractScalar getDistance(V v1, V v2) {
            return this.edges_[this.getIndexOfVertex(v1)][this.getIndexOfVertex(v2)];
        }
    }
}

