/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.directed;

import bridge.abstractClasses.AbstractScalar;
import bridge.interfaces.Arc;
import bridge.interfaces.Flow;
import bridge.interfaces.Graph;
import bridge.interfaces.Path;
import java.util.Iterator;

public abstract class ExtractFlow<V, A extends Arc<V>> {
    private AbstractScalar infinityFlow = null;
    private Graph<V, A> graph;
    private V source;
    private Flow<V, A> flow;

    protected abstract Flow<V, A> createFlow(Graph<V, A> var1);

    protected abstract Path<V, A> createDirectedPath();

    public ExtractFlow(Graph<V, A> subGraph, V source, Flow<V, A> flow) {
        this.graph = subGraph;
        this.source = source;
        this.flow = flow;
    }

    public void setInfinity(AbstractScalar infinity) {
        this.infinityFlow = infinity.clone();
    }

    public Flow<V, A> getFlowTo(V destination) {
        AbstractScalar currentFlowValue;
        Flow<V, Arc> f = this.createFlow(this.flow.getUnderlyingGraph());
        Path<V, A> currentPath = this.createDirectedPath();
        AbstractScalar totalFlowValue = null;
        while ((currentFlowValue = this.findPath(destination, currentPath, this.infinityFlow)) != null) {
            if (totalFlowValue == null) {
                totalFlowValue = currentFlowValue.clone();
            } else {
                totalFlowValue.add(currentFlowValue);
            }
            Iterator<A> edgeIt = currentPath.edgeIterator(currentPath.getFirstVertex());
            while (edgeIt.hasNext()) {
                Arc currentArc = (Arc)edgeIt.next();
                this.flow.setFlow(currentArc, this.flow.getFlow(currentArc).subtract(currentFlowValue));
                f.setFlow(currentArc, f.getFlow(currentArc).add(currentFlowValue));
            }
            currentPath = this.createDirectedPath();
        }
        f.setFlow(this.source, destination, totalFlowValue);
        assert (f.verify());
        return f;
    }

    private AbstractScalar findPath(V destination, Path<V, A> result, AbstractScalar value) {
        for (Arc current : this.graph.inEdges(destination)) {
            if (this.flow.getFlow(current).compareTo(this.flow.getFlow(current).zero()) <= 0) continue;
            AbstractScalar flowValue = this.flow.getFlow(current);
            result.concat(current);
            if (current.getOpposite(destination) == this.source) {
                return AbstractScalar.Min(flowValue, value);
            }
            return this.findPath(current.getOpposite(destination), result, AbstractScalar.Min(flowValue, value));
        }
        return null;
    }
}

