/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.undirected;

import bridge.algorithms.StepAlgo;
import bridge.interfaces.Edge;
import bridge.interfaces.Graph;
import bridge.interfaces.Map;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public abstract class Kruskal<V, E extends Edge<V>, G extends Graph<V, E>>
extends StepAlgo<V, E> {
    private G graph_;
    private G result_;
    private Map lengthMap_;
    private String lengthName_ = "Length";
    private Object lengthContext_;

    protected abstract G createGraph(G var1);

    public Kruskal(G g, Map map) {
        this(g, map, false);
    }

    public Kruskal(G g, Map map, boolean demoMode) {
        super(demoMode);
        this.graph_ = g;
        this.lengthMap_ = map;
    }

    public void setLengthName(String name) {
        this.lengthName_ = name;
    }

    public void setLengthContext(Object context) {
        this.lengthContext_ = context;
    }

    @Override
    public void run() {
        this.result_ = this.createGraph(this.graph_);
        Iterator itGN = this.graph_.vertexSet().iterator();
        Vector<LinkedList<V>> trees = new Vector<LinkedList<V>>();
        while (itGN.hasNext()) {
            Object current = itGN.next();
            LinkedList currentList = new LinkedList();
            currentList.add(current);
            trees.add(currentList);
        }
        int edgeset_length = this.graph_.edgeSet().size();
        Object[] edges = this.graph_.edgeSet().toArray(new Object[0]);
        Iterator itEs = this.graph_.edgeSet().iterator();
        int i = 0;
        while (i < edgeset_length) {
            edges[i] = itEs.next();
            ++i;
        }
        Comparator<Object> comparateur = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return Kruskal.this.lengthMap_.getValue(o1, Kruskal.this.lengthName_, Kruskal.this.lengthContext_ == null ? o1 : Kruskal.this.lengthContext_).compareTo(Kruskal.this.lengthMap_.getValue(o2, Kruskal.this.lengthName_, Kruskal.this.lengthContext_ == null ? o2 : Kruskal.this.lengthContext_));
            }
        };
        Arrays.sort(edges, comparateur);
        int numberOfVertices = this.graph_.vertexSet().size();
        int i2 = 0;
        while (i2 < edgeset_length) {
            LinkedList<V> l1;
            V[] w;
            LinkedList<V> l0;
            if (this.getDemoMode()) {
                this.lengthMap_.putString(edges[i2], "Color", "" + Color.green.getRGB());
                this.pause();
            }
            if ((l0 = this.getListFromVertex(trees, (w = ((Edge)edges[i2]).toArray())[0])) != (l1 = this.getListFromVertex(trees, w[1]))) {
                l0.union(l1);
                trees.remove(l1);
                if (this.getDemoMode()) {
                    this.lengthMap_.putString(edges[i2], "Color", "" + Color.red.getRGB());
                    this.pause();
                }
                this.result_.addEdge((Edge)((Edge)edges[i2]));
                if (this.result_.edgeSet().size() == numberOfVertices - 1) {
                    if (!this.getDemoMode()) break;
                    int j = i2 + 1;
                    while (j < edgeset_length) {
                        this.graph_.removeEdge(edges[j]);
                        ++j;
                    }
                    break;
                }
            } else if (this.getDemoMode()) {
                this.graph_.removeEdge(edges[i2]);
                this.pause();
            }
            ++i2;
        }
        this.ends();
    }

    private LinkedList<V> getListFromVertex(Vector<LinkedList<V>> lists, V o) {
        for (LinkedList<V> current : lists) {
            if (!current.contain(o)) continue;
            return current;
        }
        throw new RuntimeException("One vertex doesn't belong to list");
    }

    public G getMST() {
        if (this.result_ == null) {
            throw new IllegalStateException("You must call run method before getting result");
        }
        return this.result_;
    }

    private class LinkedList<T> {
        private LinkedNode first_ = null;
        private LinkedNode last_ = null;

        public void add(T element) {
            this.first_ = new LinkedNode(element, this.first_);
            if (this.last_ == null) {
                this.last_ = this.first_;
            }
        }

        public boolean contain(T element) {
            if (this.first_ == null) {
                return false;
            }
            LinkedNode current = this.first_;
            do {
                if (current.getElement() != element) continue;
                return true;
            } while ((current = current.getNext()) != null);
            return false;
        }

        public void union(LinkedList<T> list) {
            this.last_.next_ = list.first_;
            this.last_ = list.last_;
        }

        private class LinkedNode {
            private LinkedNode next_;
            private T element_;

            public LinkedNode(T element, LinkedNode next) {
                this.next_ = next;
                this.element_ = element;
            }

            public LinkedNode getNext() {
                return this.next_;
            }

            public T getElement() {
                return this.element_;
            }
        }
    }
}

