/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.undirected.minCut;

import bridge.abstractClasses.AbstractScalar;
import bridge.algorithms.StepAlgo;
import bridge.algorithms.common.CopyGraph;
import bridge.interfaces.Edge;
import bridge.interfaces.Graph;
import bridge.interfaces.HierarchicalSet;
import bridge.interfaces.Map;
import java.awt.Color;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public abstract class NagamochiMinCut<V, E extends Edge<V>, G extends Graph<V, E>>
extends StepAlgo<V, E> {
    private G g_;
    private HierarchicalSet<E> edgeCut_;
    private HierarchicalSet<V>[] vertexCut_;
    private AbstractScalar cutValue_;
    private HashMap<V, HierarchicalSet<V>> contractedVertexToVertex = new HashMap();
    private HashMap<E, E> contractedEdgeToEdge = new HashMap();
    private Map edgesValuesMap;
    private String edgesValuesName = "WEIGTH";
    private Object edgesValuesContext = null;

    protected abstract HierarchicalSet<V> createEmptyVertexSet();

    protected abstract HierarchicalSet<E> createEmptySet();

    protected abstract G createEmptyGraph();

    protected abstract CopyGraph<V, E, G> createCopier();

    protected abstract E createEdge(V var1, V var2);

    private E getRealEdge(E e) {
        Object realEdge = e;
        while (!this.g_.edgeSet().contains(realEdge)) {
            realEdge = (Edge)this.contractedEdgeToEdge.get(realEdge);
        }
        return realEdge;
    }

    private AbstractScalar getEdgeValue(E edge) {
        E realEdge = this.getRealEdge(edge);
        return this.edgesValuesMap.getValue(realEdge, this.edgesValuesName, this.edgesValuesContext == null ? realEdge : this.edgesValuesContext);
    }

    private HierarchicalSet<E> getOutgoingEdges(HierarchicalSet<E> edgeSet, HierarchicalSet<V> set) {
        HierarchicalSet<E> outEdge = this.createEmptySet();
        outEdge.addAll(edgeSet);
        Iterator edgeIt = outEdge.iterator();
        while (edgeIt.hasNext()) {
            Edge currentEdge = (Edge)edgeIt.next();
            V[] vertices = currentEdge.toArray();
            if ((!set.contains(vertices[0]) || !set.contains(vertices[1])) && (set.contains(vertices[0]) || set.contains(vertices[1]))) continue;
            edgeIt.remove();
        }
        return outEdge;
    }

    private V getBiggerOutgoingEdges(HierarchicalSet<V> set, Graph<V, E> graph) {
        V result = null;
        AbstractScalar resultValue = null;
        for (Object current : graph.vertexSet()) {
            HierarchicalSet<E> outEdge;
            if (set.contains(current) || (outEdge = this.getOutgoingEdges(graph.inOutEdges(current), set)).size() == 0) continue;
            AbstractScalar currentVal = this.getCutValue(outEdge);
            if (result != null && currentVal.compareTo(resultValue) <= 0) continue;
            result = (V)current;
            resultValue = currentVal;
        }
        return result;
    }

    private AbstractScalar getCutValue(HierarchicalSet<E> cut) {
        AbstractScalar result = null;
        for (Edge currentEdge : cut) {
            AbstractScalar edgeValue = this.getEdgeValue(currentEdge);
            if (result == null) {
                result = edgeValue.clone();
                continue;
            }
            result.add(edgeValue);
        }
        return result;
    }

    private G makeOrder(G graph) {
        G result = graph;
        Object firstVertex = graph.vertexSet().iterator().next();
        HierarchicalSet<V> currentSet = this.createEmptyVertexSet();
        currentSet.add(firstVertex);
        V lastVertex = null;
        while (currentSet.size() < graph.vertexSet().size() - 1) {
            lastVertex = this.getBiggerOutgoingEdges(currentSet, (Graph<V, E>)graph);
            currentSet.add(lastVertex);
        }
        HierarchicalSet<V> save = this.createEmptyVertexSet();
        save.addAll(graph.vertexSet());
        save.removeAll(currentSet);
        Object biggerVertex = save.iterator().next();
        HierarchicalSet newCut = this.getOutgoingEdges(graph.inOutEdges(biggerVertex), currentSet);
        if (newCut.size() != 0) {
            AbstractScalar newCutValue = this.getCutValue(newCut);
            if (this.cutValue_ == null || newCutValue.compareTo(this.cutValue_) < 0) {
                this.edgeCut_ = newCut;
                this.cutValue_ = newCutValue;
                this.vertexCut_[0].clear();
                this.vertexCut_[0].addAll((Collection)this.contractedVertexToVertex.get(biggerVertex));
                this.vertexCut_[1].clear();
                Iterator vertexIt = currentSet.iterator();
                while (vertexIt.hasNext()) {
                    this.vertexCut_[1].addAll((Collection)this.contractedVertexToVertex.get(vertexIt.next()));
                }
            }
        }
        for (Edge currentEdge : graph.inOutEdges(biggerVertex)) {
            Object opposite = currentEdge.getOpposite(biggerVertex);
            if (opposite == lastVertex) continue;
            E newEdge = this.createEdge(lastVertex, opposite);
            result.addEdge(newEdge);
            this.contractedEdgeToEdge.put(newEdge, currentEdge);
        }
        this.contractedVertexToVertex.get(lastVertex).addAll((Collection)this.contractedVertexToVertex.get(biggerVertex));
        result.removeVertex(biggerVertex);
        return result;
    }

    public NagamochiMinCut(G g, boolean stepMode) {
        super(stepMode);
        this.g_ = g;
        for (Object current : g.vertexSet()) {
            HierarchicalSet<V> set = this.createEmptyVertexSet();
            set.add(current);
            this.contractedVertexToVertex.put((HierarchicalSet<V>)current, (HierarchicalSet<HierarchicalSet<V>>)set);
        }
        this.vertexCut_ = (HierarchicalSet[])Array.newInstance(this.createEmptyVertexSet().getClass(), 2);
        this.vertexCut_[0] = this.createEmptyVertexSet();
        this.vertexCut_[1] = this.createEmptyVertexSet();
    }

    public NagamochiMinCut(G g) {
        this(g, false);
    }

    public void setEdgesValueMap(Map m) {
        this.edgesValuesMap = m;
    }

    public void setEdgesValueName(String name) {
        this.edgesValuesName = name;
    }

    public void setEdgesValueContext(Object context) {
        this.edgesValuesContext = context;
    }

    private void colorizeEdgeCut(int color) {
        for (Edge currentEdge : this.edgeCut_) {
            Edge realEdge = this.getRealEdge(currentEdge);
            this.edgesValuesMap.putString(realEdge, "Color", "" + color);
        }
    }

    private void colorizeVertexCut(int color0, int color1) {
        for (Object current : this.vertexCut_[0]) {
            this.edgesValuesMap.putString(current, "Color", "" + color0);
        }
        for (Object current : this.vertexCut_[1]) {
            this.edgesValuesMap.putString(current, "Color", "" + color1);
        }
    }

    @Override
    public void run() {
        G workingGraph = this.createCopier().copyGraph(this.g_);
        while (workingGraph.vertexSet().size() > 2) {
            if (this.getDemoMode() && this.edgeCut_ != null) {
                this.colorizeEdgeCut(Color.blue.getRGB());
            }
            workingGraph = this.makeOrder(workingGraph);
            if (this.getDemoMode() && this.edgeCut_ != null) {
                this.colorizeEdgeCut(Color.red.getRGB());
                this.colorizeVertexCut(Color.yellow.getRGB(), Color.green.getRGB());
            }
            this.pause();
        }
        G realCut = this.createEmptyGraph();
        for (Edge current : this.edgeCut_) {
            Edge realEdge = this.getRealEdge(current);
            realCut.addVertex(realEdge.toArray()[0]);
            realCut.addVertex(realEdge.toArray()[1]);
            realCut.addEdge((Edge)realEdge);
        }
        this.edgeCut_ = realCut.edgeSet();
        this.ends();
    }

    public HierarchicalSet<E> getEdgeMinCut() {
        return this.edgeCut_;
    }

    public HierarchicalSet<V>[] getVertexMinCut() {
        return this.vertexCut_;
    }
}

