/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algorithms.common.shortestPath;

import bridge.abstractClasses.AbstractScalar;
import bridge.interfaces.Map;
import bridge.interfaces.Path;
import java.io.FileNotFoundException;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import mascoptLib.algorithms.common.shortestPath.MascoptBellmanFordTest;
import mascoptLib.algorithms.common.shortestPath.MascoptDijkstraAdvanced;
import mascoptLib.algorithms.common.shortestPath.MascoptFloydWarshall;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.io.reader.mgl.dom.MGLDOMReader;
import mascoptLib.numeric.MascoptDouble;

public class MascoptDijkstraAdvancedTest
extends TestCase {
    private MascoptFloydWarshall sp;
    private MascoptDijkstraAdvanced verified;

    private AbstractScalar computePathWeight(Path<MascoptVertex, MascoptAbstractLink> p, Map map, String valueName, MascoptObject context) {
        AbstractScalar result = null;
        Iterator<MascoptAbstractLink> it1 = p.edgeIterator(p.isDirected() ? p.getFirstVertex() : p.getEnds()[0]);
        while (it1.hasNext()) {
            MascoptAbstractLink e1 = it1.next();
            AbstractScalar value = map.getValue(e1, valueName, context);
            if (result == null) {
                result = value.zero();
            }
            result.add(value);
        }
        return result;
    }

    private void verifySameWeight(Map map, String valueName, MascoptObject context, Path<MascoptVertex, MascoptAbstractLink> p1, Path<MascoptVertex, MascoptAbstractLink> p2) {
        if (p1 == null && p2 == null) {
            return;
        }
        if (p1 == null || p2 == null) {
            Assert.fail();
        }
        if (this.computePathWeight(p2, map, valueName, context).compareTo(this.computePathWeight(p1, map, valueName, context)) != 0) {
            Assert.fail();
        }
    }

    private void computeShortestPathAndVerify(String fileName) {
        MGLDOMReader reader = null;
        try {
            reader = new MGLDOMReader(fileName);
            reader.parse();
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        MascoptMap map = reader.getMaps().next();
        Iterator<MascoptAbstractGraph<? extends MascoptAbstractLink>> graphIt = reader.getGraphs();
        while (graphIt.hasNext()) {
            String valueName;
            MascoptAbstractGraph<? extends MascoptAbstractLink> currentGraph = graphIt.next();
            if (MascoptMap.isDefined(map, currentGraph.edgeSet(), "Capacity", currentGraph)) {
                valueName = "Capacity";
            } else {
                if (!MascoptMap.isDefined(map, currentGraph.edgeSet(), "Request Size", currentGraph)) continue;
                valueName = "Request Size";
            }
            this.sp = new MascoptFloydWarshall<MascoptAbstractLink>(currentGraph);
            this.sp.setDistanceMap(map);
            this.sp.setDistanceName(valueName);
            this.sp.setDistanceContext(currentGraph);
            this.sp.setInfiniteDistance(new MascoptDouble(Double.POSITIVE_INFINITY));
            this.sp.computeShortestPath();
            for (MascoptVertex source : currentGraph.vertexSet()) {
                Iterator it2 = currentGraph.vertexSet().iterator();
                this.verified = new MascoptDijkstraAdvanced<MascoptAbstractLink>(currentGraph, valueName, map);
                this.verified.setDistanceMap(map);
                this.verified.setDistanceName(valueName);
                this.verified.setDistanceContext(currentGraph);
                this.verified.setInfiniteDistance(new MascoptDouble(Double.POSITIVE_INFINITY));
                this.verified.valuateFromSource(source);
                while (it2.hasNext()) {
                    MascoptVertex destination = (MascoptVertex)it2.next();
                    if (source == destination) continue;
                    this.verifySameWeight(map, valueName, currentGraph, this.sp.getShortestPath(source, destination), this.verified.getShortestPathTo(destination));
                    if (this.sp.getDistance(source, destination).compareTo(this.verified.getDistanceTo(destination)) == 0) continue;
                    System.out.println(source + "->" + destination + " fail");
                }
            }
        }
    }

    public void testGetShortestPathTo() {
        int i = 0;
        while (i < MascoptBellmanFordTest.files.length) {
            this.computeShortestPathAndVerify("../mascoptData/files/" + MascoptBellmanFordTest.files[i]);
            ++i;
        }
    }
}

