/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algorithms.digraphs.route.multiFlowRouting;

import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.algorithms.digraphs.route.interfaces.MultiFlowRoutingWithCapacityConstraints;
import mascoptLib.algorithms.digraphs.route.multiFlowRouting.LPMultiFlowRouting;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.lpSolver.exception.LpException;
import mascoptLib.lpSolver.interfaces.LinearProgram;
import mascoptLib.lpSolver.interfaces.LpContinuousVariable;
import mascoptLib.lpSolver.interfaces.LpLinearContinuousExpr;
import mascoptLib.lpSolver.interfaces.LpLinearExpr;

public class LPMultiFlowRoutingWithCapacityConstraints
extends LPMultiFlowRouting
implements MultiFlowRoutingWithCapacityConstraints {
    private MascoptMap linkMap_;
    private String capacityName_ = "Capacity";
    private MascoptObject capacityContext_;
    private boolean capacityVariable_ = false;
    private HashMap<MascoptArc, LpLinearExpr> linkCapacityVar_;

    public LPMultiFlowRoutingWithCapacityConstraints(LinearProgram lp) {
        super(lp);
    }

    @Override
    public void setLinkCapacityValuesMap(MascoptMap m) {
        this.linkMap_ = m;
    }

    @Override
    public void setLinkCapacityValuesName(String name) {
        this.capacityName_ = name;
    }

    @Override
    public void setLinkCapacityValuesContext(MascoptObject context) {
        this.capacityContext_ = context;
    }

    public void setLinkToLinkCapacityLinearExpr(HashMap<MascoptArc, LpLinearExpr> m) {
        this.capacityVariable_ = true;
        this.linkCapacityVar_ = m;
    }

    @Override
    public void preSolve() {
        super.preSolve();
        for (MascoptArc current : this.getLinkGraph().edgeSet()) {
            LpLinearContinuousExpr currentVar = this.getVarOfEdgeFlow(current);
            try {
                if (this.capacityVariable_) {
                    this.getLinearProgram().addLesserConstraint((LpLinearExpr)currentVar, this.linkCapacityVar_.get(current));
                    continue;
                }
                this.getLinearProgram().addLesserConstraint((LpLinearExpr)currentVar, this.linkMap_ == null ? 1.0 : this.linkMap_.getValue(current, this.capacityName_, this.capacityContext_ == null ? current : this.capacityContext_).doubleValue());
            }
            catch (LpException e) {
                System.out.println(e);
                System.exit(1);
            }
        }
    }

    public void addSumMinFlowObjective() {
        Iterator linkIt = ((MascoptAbstractLinkSet)this.getLinkGraph().edgeSet()).iterator();
        try {
            LpLinearContinuousExpr objective = this.getLinearProgram().newLinearContinuousExpr();
            while (linkIt.hasNext()) {
                MascoptArc current = (MascoptArc)linkIt.next();
                objective.addExpr(this.getVarOfEdgeFlow(current));
            }
            this.getLinearProgram().minimize(objective);
        }
        catch (LpException e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    public void addMinTrafficObjective() {
        try {
            LpContinuousVariable gamma = this.getLinearProgram().newContinuousVariable(0.0, Double.MAX_VALUE);
            LpLinearContinuousExpr objective = this.getLinearProgram().newLinearContinuousExpr();
            objective.addTerm(1.0, gamma);
            for (MascoptArc current : this.getLinkGraph().edgeSet()) {
                this.getLinearProgram().addLesserConstraint((LpLinearExpr)this.getVarOfEdgeFlow(current), gamma);
            }
            this.getLinearProgram().minimize(objective);
        }
        catch (LpException e) {
            System.out.println(e);
            System.exit(1);
        }
    }
}

