/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algorithms.digraphs.route.multiFlowRouting;

import mascoptLib.algorithms.digraphs.route.interfaces.MultiFlowRoutingWithCapacityConstraints;
import mascoptLib.algorithms.digraphs.route.multiFlowRouting.lowLevel.AddLinkFlowMonoRouting;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.lpSolver.exception.LpException;
import mascoptLib.lpSolver.interfaces.LinearProgram;

public class LpMultiFlowMonoRouting
implements MultiFlowRoutingWithCapacityConstraints {
    private LinearProgram solver_;
    private MascoptDiGraph linkGraph_;
    private MascoptDiGraph requestGraph_;
    private MascoptMap linkCapacityMap_;
    private String linkCapacityName_ = "Capacity";
    private MascoptObject linkCapacityContext_;
    private MascoptMap requestSizeMap_;
    private String requestSizeName_ = "Request Size";
    private MascoptObject requestSizeContext_;
    private AddLinkFlowMonoRouting problem_;

    public LpMultiFlowMonoRouting(LinearProgram solver) {
        this.solver_ = solver;
    }

    @Override
    public void setLinkCapacityValuesContext(MascoptObject context) {
        this.linkCapacityContext_ = context;
    }

    @Override
    public void setLinkCapacityValuesMap(MascoptMap m) {
        this.linkCapacityMap_ = m;
    }

    @Override
    public void setLinkCapacityValuesName(String name) {
        this.linkCapacityName_ = name;
    }

    @Override
    public double getFlowOnEdge(MascoptArc a) {
        try {
            return this.solver_.getExprValue(this.problem_.getLinkFlow(a));
        }
        catch (LpException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public double getFlowOnEdgeForRequest(MascoptArc a, MascoptArc r) {
        try {
            return this.solver_.getVarValue(this.problem_.getLinkRequestVariables(a, r));
        }
        catch (LpException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public void postSolve() {
    }

    @Override
    public void preSolve() {
        try {
            this.problem_ = new AddLinkFlowMonoRouting(this.linkGraph_, this.requestGraph_, this.linkCapacityMap_, this.requestSizeMap_, this.solver_);
            this.problem_.setLinkCapacityValuesName(this.linkCapacityName_);
            this.problem_.setLinkCapacityValuesContext(this.linkCapacityContext_);
            this.problem_.setRequestValueName(this.requestSizeName_);
            this.problem_.setRequestValueContext(this.requestSizeContext_);
            this.problem_.createLP();
        }
        catch (LpException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setGraph(MascoptDiGraph g) {
        this.linkGraph_ = g;
    }

    @Override
    public void setIntegerComputation(boolean state) {
        throw new IllegalStateException("No sense to set integer computation mode for monorouted multi flow routing");
    }

    @Override
    public void setRequestsGraph(MascoptDiGraph gr) {
        this.requestGraph_ = gr;
    }

    @Override
    public void setRequestsValuesContext(MascoptObject context) {
        this.requestSizeContext_ = context;
    }

    @Override
    public void setRequestsValuesMap(MascoptMap m) {
        this.requestSizeMap_ = m;
    }

    @Override
    public void setRequestsValuesName(String name) {
        this.requestSizeName_ = name;
    }

    @Override
    public boolean solve() {
        try {
            return this.solver_.solve();
        }
        catch (LpException e) {
            e.printStackTrace();
            return false;
        }
    }
}

