/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import bridge.interfaces.Cycle;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.Messages;
import mascoptLib.core.Notification;
import mascoptLib.core.factory.abstracts.MascoptAbstractMetaFactory;
import org.w3c.dom.Element;

public abstract class MascoptAbstractCycle<E extends MascoptAbstractLink>
extends MascoptObject
implements Cycle<MascoptVertex, E> {
    private static final String cycleBegin_ = "[ ";
    private static final String cycleEnd_ = " ]";
    private static final String cycleInterLink_ = "-";
    private static final String diCycleInterLink_ = "->";
    private final MascoptAbstractMetaFactory<E, ? extends MascoptAbstractGraph<E>> mascoptFactory_;
    protected Vector<MascoptVertex> orderedVertices = new Vector();
    protected Vector<E> orderedLinks = new Vector();

    MascoptAbstractCycle(MascoptAbstractPath<E> p, E e, MascoptAbstractMetaFactory<E, ? extends MascoptAbstractGraph<E>> factory, String id) {
        super(id);
        this.mascoptFactory_ = factory;
        if (p.length() != 0) {
            MascoptVertex[] edgeVertices;
            MascoptVertex[] pathEnds = p.getEnds();
            if (pathEnds[0] == (edgeVertices = ((MascoptAbstractLink)e).toArray((MascoptVertex[])new MascoptVertex[0]))[0] && pathEnds[1] == edgeVertices[1] || pathEnds[0] == edgeVertices[1] && pathEnds[1] == edgeVertices[0]) {
                Iterator<MascoptVertex> vertexIt = p.vertexIterator(p.isDirected() ? p.getFirstVertex() : pathEnds[0]);
                while (vertexIt.hasNext()) {
                    this.orderedVertices.add(vertexIt.next());
                }
                Iterator<E> edgeIt = p.edgeIterator(p.isDirected() ? p.getFirstVertex() : pathEnds[0]);
                while (edgeIt.hasNext()) {
                    this.orderedLinks.add((MascoptAbstractLink)edgeIt.next());
                }
                this.orderedLinks.add(e);
                return;
            }
        } else {
            MascoptVertex[] edgeVertices = ((MascoptAbstractLink)e).toArray((MascoptVertex[])new MascoptVertex[0]);
            if (edgeVertices[0] == edgeVertices[1]) {
                this.orderedVertices.add(edgeVertices[0]);
                this.orderedVertices.add(edgeVertices[1]);
                this.orderedLinks.add(e);
                return;
            }
        }
        throw new IllegalArgumentException(Messages.getString("MascoptAbstractCycle.edgeDontClose"));
    }

    @Override
    public boolean contains(MascoptVertex vertex) {
        return this.orderedVertices.contains(vertex);
    }

    @Override
    public boolean contains(E edge) {
        return this.orderedLinks.contains(edge);
    }

    @Override
    public Iterator<MascoptVertex> vertexIterator() {
        return new IteratorWithoutRemove<MascoptVertex>(this.orderedVertices);
    }

    @Override
    public Iterator<MascoptVertex> vertexIterator(MascoptVertex firstVertex) {
        return new IteratorWithoutRemove(this, this.orderedVertices, (MascoptObject)firstVertex);
    }

    @Override
    public Iterator<E> edgeIterator() {
        return new IteratorWithoutRemove<E>(this.orderedLinks);
    }

    @Override
    public Iterator<E> edgeIterator(E firstEdge) {
        return new IteratorWithoutRemove(this, this.orderedLinks, firstEdge);
    }

    @Override
    public E[] getEdges(MascoptVertex vertex) throws NoSuchElementException {
        int vertexIndex = this.orderedVertices.indexOf(vertex);
        if (vertexIndex == -1) {
            throw new NoSuchElementException(Messages.getString("MascoptAbstractCycle.vertexDontBelong"));
        }
        MascoptAbstractLink[] result = (MascoptAbstractLink[])Array.newInstance(((MascoptAbstractLink)this.orderedLinks.get(0)).getClass(), 2);
        result[0] = vertexIndex != 0 ? (MascoptAbstractLink)this.orderedLinks.get(vertexIndex - 1) : (MascoptAbstractLink)this.orderedLinks.lastElement();
        result[1] = (MascoptAbstractLink)this.orderedLinks.get(vertexIndex);
        return result;
    }

    @Override
    public int length() {
        return this.orderedLinks.size();
    }

    public MascoptAbstractMetaFactory<E, ? extends MascoptAbstractGraph<E>> getFactory() {
        return this.mascoptFactory_;
    }

    @Override
    public MascoptAbstractCycle<E> clone() {
        MascoptAbstractCycle result = (MascoptAbstractCycle)super.clone();
        result.orderedVertices = (Vector)this.orderedVertices.clone();
        result.orderedLinks = (Vector)this.orderedLinks.clone();
        return result;
    }

    @Override
    public String toString() {
        String result = new String();
        result = String.valueOf(result) + cycleBegin_;
        Iterator<MascoptVertex> vIt = this.vertexIterator();
        while (vIt.hasNext()) {
            result = String.valueOf(result) + vIt.next().toString();
            if (!vIt.hasNext()) continue;
            result = String.valueOf(result) + (this.isDirected() ? diCycleInterLink_ : cycleInterLink_);
        }
        result = String.valueOf(result) + cycleEnd_;
        return result;
    }

    @Override
    public String getDOMTagHierarchy() {
        return "CYCLES";
    }

    @Override
    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        Iterator<E> it_edges = this.edgeIterator();
        while (it_edges.hasNext()) {
            MascoptAbstractLink e = (MascoptAbstractLink)it_edges.next();
            e.toDOMTreeAsRef(node_to_go);
        }
        return node_to_go;
    }

    @Override
    public void update(MascoptObservableObject observable, Notification message) {
    }

    private class IteratorWithoutRemove<T extends MascoptObject>
    implements Iterator<T> {
        private Vector<T> vector;
        private int initialIndex;
        private int index;

        public IteratorWithoutRemove(Vector<T> v) {
            this.index = 0;
            this.vector = v;
            this.initialIndex = 0;
        }

        public IteratorWithoutRemove(Vector<T> v, T begin) {
            this.index = 0;
            this.vector = v;
            this.initialIndex = this.vector.indexOf(begin);
            if (this.initialIndex == -1) {
                throw new IllegalArgumentException(Messages.getString("MascoptAbstractCycle.vertexDontBelong"));
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.vector.size();
        }

        @Override
        public T next() {
            return (T)((MascoptObject)this.vector.get((this.initialIndex + this.index++) % this.vector.size()));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

