/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptArcSet;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptEdgeSet;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.factory.MascoptDirectedMetaFactory;
import mascoptLib.core.factory.MascoptUndirectedMetaFactory;
import mascoptLib.numeric.MascoptInteger;

public class MascoptAbstractGraphTest
extends TestCase {
    private static final int NB_VERTEX = 20;
    private MascoptVertex[] vertices_;
    private MascoptEdge[] edges_;
    private MascoptArc[] arcs_;
    private MascoptVertexSet vertexSet_;
    private MascoptEdgeSet edgeSet_;
    private MascoptArcSet arcSet_;
    private MascoptGraph graph_;
    private MascoptDiGraph digraph_;

    protected void setUp() throws Exception {
        int j;
        super.setUp();
        this.vertexSet_ = new MascoptVertexSet();
        this.edgeSet_ = new MascoptEdgeSet(this.vertexSet_);
        this.arcSet_ = new MascoptArcSet(this.vertexSet_);
        this.graph_ = new MascoptGraph(this.edgeSet_);
        this.digraph_ = new MascoptDiGraph(this.arcSet_);
        new MascoptDiGraph(this.digraph_);
        new MascoptGraph(this.graph_);
        this.vertices_ = new MascoptVertex[20];
        int i = 0;
        while (i < 20) {
            this.vertices_[i] = new MascoptVertex();
            this.vertexSet_.add(this.vertices_[i]);
            ++i;
        }
        this.edges_ = new MascoptEdge[400];
        i = 0;
        while (i < 20) {
            j = 0;
            while (j < 20) {
                this.edges_[i * 20 + j] = new MascoptEdge(this.vertices_[i], this.vertices_[j]);
                ++j;
            }
            ++i;
        }
        this.graph_ = new MascoptGraph(this.edgeSet_);
        this.graph_.addEdge(this.edges_[0]);
        this.graph_.addEdge(this.edges_[1]);
        this.arcs_ = new MascoptArc[400];
        i = 0;
        while (i < 20) {
            j = 0;
            while (j < 20) {
                this.arcs_[i * 20 + j] = new MascoptArc(this.vertices_[i], this.vertices_[j]);
                ++j;
            }
            ++i;
        }
        this.digraph_ = new MascoptDiGraph(this.arcSet_);
        this.digraph_.addEdge(this.arcs_[0]);
        this.digraph_.addEdge(this.arcs_[1]);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.vertexSet_ = null;
        this.edgeSet_ = null;
        this.arcSet_ = null;
        this.graph_ = null;
        this.digraph_ = null;
        this.vertices_ = null;
        this.edges_ = null;
        this.arcs_ = null;
    }

    public void testInverse() {
        MascoptGraph invGraph = this.graph_.inverse();
        Assert.assertTrue((this.graph_.vertexSet() == invGraph.vertexSet() ? 1 : 0) != 0);
        Assert.assertTrue((((MascoptFixedSet)this.graph_.edgeSet()).size() == ((MascoptFixedSet)invGraph.edgeSet()).size() ? 1 : 0) != 0);
        for (MascoptEdge current : this.graph_.edgeSet()) {
            Assert.assertTrue((boolean)((MascoptFixedSet)invGraph.edgeSet()).contains(current));
        }
        MascoptDiGraph invDiGraph = this.digraph_.inverse();
        Assert.assertTrue((this.digraph_.vertexSet() == invDiGraph.vertexSet() ? 1 : 0) != 0);
        Assert.assertTrue((((MascoptFixedSet)this.digraph_.edgeSet()).size() == ((MascoptFixedSet)invDiGraph.edgeSet()).size() ? 1 : 0) != 0);
        for (MascoptArc current : this.digraph_.arcSet()) {
            MascoptFixedSet arcs = invDiGraph.getEdgesConnected(current.getHead(), current.getTail());
            Assert.assertTrue((arcs.size() == 1 ? 1 : 0) != 0);
        }
    }

    public void testBreadthFirstIterator() {
        MascoptVertex V7 = new MascoptVertex(772.0, 564.0);
        MascoptVertex V1 = new MascoptVertex(650.0, 685.0);
        MascoptVertex V6 = new MascoptVertex(646.0, 573.0);
        MascoptVertex V10 = new MascoptVertex(773.0, 681.0);
        MascoptVertex V9 = new MascoptVertex(892.0, 683.0);
        MascoptVertex V2 = new MascoptVertex(768.0, 473.0);
        MascoptVertex V8 = new MascoptVertex(912.0, 360.0);
        MascoptVertex V4 = new MascoptVertex(909.0, 469.0);
        MascoptVertex V3 = new MascoptVertex(642.0, 471.0);
        MascoptVertex V0 = new MascoptVertex(904.0, 578.0);
        MascoptVertex V5 = new MascoptVertex(767.0, 749.0);
        MascoptVertexSet VS0 = new MascoptVertexSet();
        VS0.add(V7);
        VS0.add(V1);
        VS0.add(V6);
        VS0.add(V10);
        VS0.add(V9);
        VS0.add(V2);
        VS0.add(V8);
        VS0.add(V4);
        VS0.add(V3);
        VS0.add(V0);
        VS0.add(V5);
        MascoptEdge E1 = new MascoptEdge(V0, V4);
        MascoptEdge E10 = new MascoptEdge(V5, V10);
        MascoptEdge E13 = new MascoptEdge(V6, V1);
        MascoptEdge E2 = new MascoptEdge(V3, V2);
        MascoptEdge E5 = new MascoptEdge(V2, V8);
        MascoptEdge E14 = new MascoptEdge(V6, V3);
        MascoptEdge E6 = new MascoptEdge(V5, V1);
        MascoptEdge E7 = new MascoptEdge(V6, V2);
        MascoptEdge E3 = new MascoptEdge(V8, V4);
        MascoptEdge E11 = new MascoptEdge(V4, V7);
        MascoptEdge E8 = new MascoptEdge(V6, V7);
        MascoptEdge E12 = new MascoptEdge(V7, V10);
        MascoptEdge E0 = new MascoptEdge(V9, V0);
        MascoptEdge E4 = new MascoptEdge(V5, V9);
        MascoptEdge E9 = new MascoptEdge(V2, V4);
        MascoptEdgeSet ES0 = new MascoptEdgeSet(VS0);
        ES0.add(E1);
        ES0.add(E10);
        ES0.add(E13);
        ES0.add(E2);
        ES0.add(E5);
        ES0.add(E14);
        ES0.add(E6);
        ES0.add(E7);
        ES0.add(E3);
        ES0.add(E11);
        ES0.add(E8);
        ES0.add(E12);
        ES0.add(E0);
        ES0.add(E4);
        ES0.add(E9);
        MascoptGraph G0 = new MascoptGraph(ES0);
        MascoptMap M0 = new MascoptMap();
        M0.putValue(V7, "rank", V7, new MascoptInteger(2));
        M0.putValue(V1, "rank", V1, new MascoptInteger(1));
        M0.putValue(V6, "rank", V6, new MascoptInteger(2));
        M0.putValue(V10, "rank", V10, new MascoptInteger(1));
        M0.putValue(V9, "rank", V9, new MascoptInteger(1));
        M0.putValue(V2, "rank", V2, new MascoptInteger(3));
        M0.putValue(V8, "rank", V8, new MascoptInteger(4));
        M0.putValue(V4, "rank", V4, new MascoptInteger(3));
        M0.putValue(V3, "rank", V3, new MascoptInteger(3));
        M0.putValue(V0, "rank", V0, new MascoptInteger(2));
        M0.putValue(V5, "rank", V5, new MascoptInteger(0));
        MascoptInteger lastValue = new MascoptInteger(0);
        Iterator<MascoptVertex> vertexIt = G0.breadthFirstIterator(V5);
        while (vertexIt.hasNext()) {
            MascoptVertex current = vertexIt.next();
            MascoptInteger currentValue = (MascoptInteger)M0.getValue(current, "rank");
            lastValue = currentValue;
            MascoptAbstractGraphTest.assertTrue((lastValue.intValue() <= currentValue.intValue() ? 1 : 0) != 0);
            try {
                vertexIt.remove();
            }
            catch (UnsupportedOperationException e) {
                continue;
            }
            Assert.fail();
        }
    }

    public void testDepthFirstIterator() {
        MascoptVertex V7 = new MascoptVertex(812.0, 768.0);
        MascoptVertex V1 = new MascoptVertex(938.0, 445.0);
        MascoptVertex V6 = new MascoptVertex(749.0, 555.0);
        MascoptVertex V9 = new MascoptVertex(875.0, 557.0);
        MascoptVertex V2 = new MascoptVertex(815.0, 453.0);
        MascoptVertex V8 = new MascoptVertex(813.0, 365.0);
        MascoptVertex V4 = new MascoptVertex(919.0, 667.0);
        MascoptVertex V3 = new MascoptVertex(687.0, 452.0);
        MascoptVertex V0 = new MascoptVertex(813.0, 668.0);
        MascoptVertex V5 = new MascoptVertex(681.0, 662.0);
        MascoptVertexSet VS0 = new MascoptVertexSet();
        VS0.add(V7);
        VS0.add(V1);
        VS0.add(V6);
        VS0.add(V9);
        VS0.add(V2);
        VS0.add(V8);
        VS0.add(V4);
        VS0.add(V3);
        VS0.add(V0);
        VS0.add(V5);
        MascoptEdge E4 = new MascoptEdge(V4, V6);
        MascoptEdge E0 = new MascoptEdge(V9, V3);
        MascoptEdge E15 = new MascoptEdge(V0, V9);
        MascoptEdge E12 = new MascoptEdge(V4, V9);
        MascoptEdge E11 = new MascoptEdge(V9, V1);
        MascoptEdge E2 = new MascoptEdge(V6, V0);
        MascoptEdge E8 = new MascoptEdge(V1, V8);
        MascoptEdge E14 = new MascoptEdge(V8, V2);
        MascoptEdge E5 = new MascoptEdge(V6, V1);
        MascoptEdge E9 = new MascoptEdge(V0, V7);
        MascoptEdge E3 = new MascoptEdge(V2, V6);
        MascoptEdge E6 = new MascoptEdge(V7, V5);
        MascoptEdge E7 = new MascoptEdge(V5, V9);
        MascoptEdge E16 = new MascoptEdge(V7, V4);
        MascoptEdge E13 = new MascoptEdge(V5, V6);
        MascoptEdge E1 = new MascoptEdge(V3, V8);
        MascoptEdge E10 = new MascoptEdge(V9, V2);
        MascoptEdge E17 = new MascoptEdge(V6, V3);
        MascoptEdgeSet ES0 = new MascoptEdgeSet(VS0);
        ES0.add(E4);
        ES0.add(E0);
        ES0.add(E15);
        ES0.add(E12);
        ES0.add(E11);
        ES0.add(E2);
        ES0.add(E8);
        ES0.add(E14);
        ES0.add(E5);
        ES0.add(E9);
        ES0.add(E3);
        ES0.add(E6);
        ES0.add(E7);
        ES0.add(E16);
        ES0.add(E13);
        ES0.add(E1);
        ES0.add(E10);
        ES0.add(E17);
        MascoptGraph G0 = new MascoptGraph(ES0);
        MascoptMap M0 = new MascoptMap();
        M0.putValue(V7, "rank", V7, new MascoptInteger(0));
        M0.putValue(V1, "rank", V1, new MascoptInteger(3));
        M0.putValue(V6, "rank", V6, new MascoptInteger(2));
        M0.putValue(V9, "rank", V9, new MascoptInteger(2));
        M0.putValue(V2, "rank", V2, new MascoptInteger(3));
        M0.putValue(V8, "rank", V8, new MascoptInteger(4));
        M0.putValue(V4, "rank", V4, new MascoptInteger(1));
        M0.putValue(V3, "rank", V3, new MascoptInteger(3));
        M0.putValue(V0, "rank", V0, new MascoptInteger(1));
        M0.putValue(V5, "rank", V5, new MascoptInteger(1));
        int lastValue = -1;
        boolean ascending = true;
        Iterator<MascoptVertex> vertexIt = G0.depthFirstIterator(V7);
        while (vertexIt.hasNext()) {
            MascoptVertex current = vertexIt.next();
            int currentValue = M0.getValue(current, "rank").intValue();
            if (ascending && lastValue > currentValue) {
                ascending = false;
            }
            Assert.assertTrue((lastValue < currentValue == ascending ? 1 : 0) != 0);
            lastValue = currentValue;
        }
    }

    public void testAddEdgeEdge() {
        this.vertexSet_.add(this.edges_[2].getVertices()[0]);
        this.vertexSet_.add(this.edges_[2].getVertices()[1]);
        this.graph_.addEdge(this.edges_[2]);
        Assert.assertTrue((boolean)this.edgeSet_.contains(this.edges_[2]));
        this.digraph_.addEdge(this.arcs_[2]);
        Assert.assertTrue((boolean)this.arcSet_.contains(this.arcs_[2]));
    }

    public void testAddEdgeObjectObject() {
        this.vertexSet_.add(this.vertices_[19]);
        this.vertexSet_.add(this.vertices_[18]);
        this.graph_.addEdge(this.vertices_[19], this.vertices_[18]);
        this.digraph_.addEdge(this.vertices_[19], this.vertices_[18]);
        Assert.assertTrue((boolean)this.graph_.neighborhood(this.vertices_[19]).contains(this.vertices_[18]));
        Assert.assertTrue((boolean)this.graph_.neighborhood(this.vertices_[18]).contains(this.vertices_[19]));
        Assert.assertTrue((boolean)this.graph_.inNeighborhood(this.vertices_[19]).contains(this.vertices_[18]));
        Assert.assertTrue((boolean)this.graph_.inNeighborhood(this.vertices_[18]).contains(this.vertices_[19]));
        Assert.assertTrue((boolean)this.graph_.outNeighborhood(this.vertices_[19]).contains(this.vertices_[18]));
        Assert.assertTrue((boolean)this.graph_.outNeighborhood(this.vertices_[18]).contains(this.vertices_[19]));
        Assert.assertTrue((boolean)this.digraph_.neighborhood(this.vertices_[19]).contains(this.vertices_[18]));
        Assert.assertTrue((boolean)this.digraph_.neighborhood(this.vertices_[18]).contains(this.vertices_[19]));
        Assert.assertFalse((boolean)this.digraph_.inNeighborhood(this.vertices_[19]).contains(this.vertices_[18]));
        Assert.assertTrue((boolean)this.digraph_.inNeighborhood(this.vertices_[18]).contains(this.vertices_[19]));
        Assert.assertTrue((boolean)this.digraph_.outNeighborhood(this.vertices_[19]).contains(this.vertices_[18]));
        Assert.assertFalse((boolean)this.digraph_.outNeighborhood(this.vertices_[18]).contains(this.vertices_[19]));
    }

    public void testAddVertex() {
        this.graph_.addVertex(this.vertices_[0]);
        Assert.assertTrue((boolean)this.vertexSet_.contains(this.vertices_[0]));
    }

    public void testRemoveEdgeEdge() {
        Assert.assertTrue((boolean)this.edgeSet_.contains(this.edges_[0]));
        this.graph_.removeEdge(this.edges_[0]);
        Assert.assertFalse((boolean)this.edgeSet_.contains(this.edges_[0]));
        Assert.assertTrue((boolean)this.arcSet_.contains(this.arcs_[0]));
        this.digraph_.removeEdge(this.arcs_[0]);
        Assert.assertFalse((boolean)this.arcSet_.contains(this.arcs_[0]));
    }

    public void testRemoveEdgeObjectObject() {
        Assert.assertTrue((boolean)this.edgeSet_.contains(this.edges_[1]));
        this.graph_.removeEdge(this.edges_[1].getVertices()[0], this.edges_[1].getVertices()[1]);
        Assert.assertFalse((boolean)this.edgeSet_.contains(this.edges_[1]));
        Assert.assertTrue((boolean)this.arcSet_.contains(this.arcs_[1]));
        this.digraph_.removeEdge(this.arcs_[1].getTail(), this.arcs_[1].getHead());
        Assert.assertFalse((boolean)this.arcSet_.contains(this.arcs_[1]));
    }

    public void testRemoveVertex() {
        this.graph_.removeVertex(this.edges_[0].getVertices()[0]);
        Assert.assertFalse((boolean)this.edgeSet_.contains(this.edges_[0]));
        this.digraph_.removeVertex(this.arcs_[1].getVertices()[0]);
        Assert.assertFalse((boolean)this.arcSet_.contains(this.arcs_[1]));
    }

    public void testGetFactory() {
        Assert.assertTrue((boolean)(this.graph_.getFactory() instanceof MascoptUndirectedMetaFactory));
        Assert.assertTrue((boolean)(this.digraph_.getFactory() instanceof MascoptDirectedMetaFactory));
    }

    public void testClone() {
        MascoptGraph gCopy = this.graph_.clone();
        Assert.assertTrue((((MascoptFixedSet)gCopy.vertexSet()).size() == ((MascoptFixedSet)this.graph_.vertexSet()).size() ? 1 : 0) != 0);
        Assert.assertTrue((((MascoptFixedSet)gCopy.edgeSet()).size() == ((MascoptFixedSet)this.graph_.edgeSet()).size() ? 1 : 0) != 0);
        ((MascoptAbstractLinkSet)gCopy.edgeSet()).removeAll(this.graph_.edgeSet());
        Assert.assertTrue((((MascoptFixedSet)gCopy.edgeSet()).size() == 0 ? 1 : 0) != 0);
        ((MascoptSet)gCopy.vertexSet()).removeAll(this.graph_.vertexSet());
        Assert.assertTrue((((MascoptFixedSet)gCopy.vertexSet()).size() == 0 ? 1 : 0) != 0);
        MascoptDiGraph dgCopy = this.digraph_.clone();
        Assert.assertTrue((((MascoptFixedSet)dgCopy.vertexSet()).size() == ((MascoptFixedSet)this.digraph_.vertexSet()).size() ? 1 : 0) != 0);
        Assert.assertTrue((((MascoptFixedSet)dgCopy.edgeSet()).size() == ((MascoptFixedSet)this.digraph_.edgeSet()).size() ? 1 : 0) != 0);
        ((MascoptAbstractLinkSet)dgCopy.edgeSet()).removeAll(this.digraph_.edgeSet());
        Assert.assertTrue((((MascoptFixedSet)dgCopy.edgeSet()).size() == 0 ? 1 : 0) != 0);
        ((MascoptSet)dgCopy.vertexSet()).removeAll(this.digraph_.vertexSet());
        Assert.assertTrue((((MascoptFixedSet)dgCopy.vertexSet()).size() == 0 ? 1 : 0) != 0);
    }

    public void testComplement() {
        MascoptGraph graphComplement = (MascoptGraph)this.graph_.complement();
        MascoptDiGraph digraphComplement = (MascoptDiGraph)this.digraph_.complement();
        Assert.assertTrue((this.graph_.vertexSet() == graphComplement.vertexSet() ? 1 : 0) != 0);
        Assert.assertTrue((this.digraph_.vertexSet() == digraphComplement.vertexSet() ? 1 : 0) != 0);
        int nVertex = ((MascoptFixedSet)this.graph_.vertexSet()).size();
        int nLink = nVertex * nVertex;
        int i = 0;
        while (i < nLink) {
            boolean isInDigraphComplement;
            MascoptVertex[] verticesLink = this.edges_[i].getVertices();
            Assert.assertTrue((verticesLink[0] == this.arcs_[i].getVertices()[0] ? 1 : 0) != 0);
            Assert.assertTrue((verticesLink[1] == this.arcs_[i].getVertices()[1] ? 1 : 0) != 0);
            boolean isInGraph = this.graph_.getEdgesConnected(verticesLink[0], verticesLink[1]).size() >= 1;
            boolean isInDigraph = this.digraph_.getEdgesConnected(verticesLink[0], verticesLink[1]).size() >= 1;
            MascoptFixedSet existingEdges = graphComplement.getEdgesConnected(verticesLink[0], verticesLink[1]);
            boolean isInGraphComplement = existingEdges.size() == 1;
            MascoptFixedSet existingArcs = digraphComplement.getEdgesConnected(verticesLink[0], verticesLink[1]);
            boolean bl = isInDigraphComplement = existingArcs.size() >= 1;
            if (verticesLink[0] != verticesLink[1]) {
                Assert.assertTrue((isInGraph && !isInGraphComplement || !isInGraph && isInGraphComplement ? 1 : 0) != 0);
                Assert.assertTrue((isInDigraph && !isInDigraphComplement || !isInDigraph && isInDigraphComplement ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testInducedSubGraph() {
        MascoptSet<MascoptVertex> vertices = new MascoptSet<MascoptVertex>();
        int nVertex = 10;
        int nLink = 400;
        int i = 0;
        while (i < 20) {
            if (i < nVertex) {
                vertices.add(this.vertices_[i]);
            }
            this.graph_.addVertex(this.vertices_[i]);
            this.digraph_.addVertex(this.vertices_[i]);
            ++i;
        }
        i = 0;
        while (i < nLink) {
            this.graph_.addEdge(this.edges_[i]);
            this.digraph_.addEdge(this.arcs_[i]);
            ++i;
        }
        MascoptGraph subGraph = (MascoptGraph)this.graph_.inducedSubGraph(vertices);
        MascoptAbstractGraphTest.assertTrue((((MascoptFixedSet)subGraph.edgeSet()).size() == nVertex * nVertex ? 1 : 0) != 0);
        MascoptDiGraph subDigraph = (MascoptDiGraph)this.digraph_.inducedSubGraph(vertices);
        MascoptAbstractGraphTest.assertTrue((((MascoptFixedSet)subDigraph.edgeSet()).size() == nVertex * nVertex ? 1 : 0) != 0);
    }

    public void testNeighborhood() {
        Assert.assertEquals((int)this.graph_.neighborhood(this.vertices_[0]).size(), (int)2);
        Assert.assertEquals((int)this.digraph_.neighborhood(this.vertices_[0]).size(), (int)2);
        Assert.assertEquals((int)this.graph_.neighborhood(this.vertices_[1]).size(), (int)1);
        Assert.assertEquals((int)this.digraph_.neighborhood(this.vertices_[1]).size(), (int)1);
    }

    public void testOutNeighborhood() {
        Assert.assertEquals((int)this.graph_.outNeighborhood(this.vertices_[0]).size(), (int)2);
        Assert.assertEquals((int)this.digraph_.outNeighborhood(this.vertices_[0]).size(), (int)2);
        Assert.assertEquals((int)this.graph_.outNeighborhood(this.vertices_[1]).size(), (int)1);
        Assert.assertEquals((int)this.digraph_.outNeighborhood(this.vertices_[1]).size(), (int)0);
    }

    public void testInNeighborhood() {
        Assert.assertEquals((int)this.graph_.inNeighborhood(this.vertices_[0]).size(), (int)2);
        Assert.assertEquals((int)this.digraph_.inNeighborhood(this.vertices_[0]).size(), (int)1);
        Assert.assertEquals((int)this.graph_.inNeighborhood(this.vertices_[1]).size(), (int)1);
        Assert.assertEquals((int)this.digraph_.inNeighborhood(this.vertices_[1]).size(), (int)1);
    }

    public void testInEdges() {
        Assert.assertTrue((boolean)this.graph_.inEdges(this.edges_[1].getVertices()[0]).contains(this.edges_[1]));
        Assert.assertTrue((boolean)this.graph_.inEdges(this.edges_[1].getVertices()[1]).contains(this.edges_[1]));
        Assert.assertFalse((boolean)this.digraph_.inEdges(this.arcs_[1].getTail()).contains(this.arcs_[1]));
        Assert.assertTrue((boolean)this.digraph_.inEdges(this.arcs_[1].getHead()).contains(this.arcs_[1]));
    }

    public void testOutEdges() {
        Assert.assertTrue((boolean)this.graph_.outEdges(this.edges_[1].getVertices()[0]).contains(this.edges_[1]));
        Assert.assertTrue((boolean)this.graph_.outEdges(this.edges_[1].getVertices()[1]).contains(this.edges_[1]));
        Assert.assertTrue((boolean)this.digraph_.outEdges(this.arcs_[1].getTail()).contains(this.arcs_[1]));
        Assert.assertFalse((boolean)this.digraph_.outEdges(this.arcs_[1].getHead()).contains(this.arcs_[1]));
    }

    public void testInOutEdges() {
        Assert.assertTrue((boolean)this.graph_.inOutEdges(this.edges_[1].getVertices()[0]).contains(this.edges_[1]));
        Assert.assertTrue((boolean)this.graph_.inOutEdges(this.edges_[1].getVertices()[1]).contains(this.edges_[1]));
        Assert.assertTrue((boolean)this.digraph_.inOutEdges(this.arcs_[1].getTail()).contains(this.arcs_[1]));
        Assert.assertTrue((boolean)this.digraph_.inOutEdges(this.arcs_[1].getHead()).contains(this.arcs_[1]));
    }

    public void testGetEdgesConnected() {
        MascoptFixedSet firstSet = this.graph_.getEdgesConnected(this.vertices_[0], this.vertices_[1]);
        Assert.assertEquals((int)firstSet.size(), (int)1);
        Assert.assertEquals(firstSet.iterator().next(), (Object)this.edges_[1]);
        MascoptFixedSet secondSet = this.digraph_.getEdgesConnected(this.vertices_[0], this.vertices_[1]);
        Assert.assertEquals((int)secondSet.size(), (int)1);
        Assert.assertEquals(secondSet.iterator().next(), (Object)this.arcs_[1]);
    }
}

