/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.Messages;
import mascoptLib.core.Notification;
import mascoptLib.core.factory.abstracts.MascoptAbstractMetaFactory;
import org.w3c.dom.Element;

public abstract class MascoptAbstractLinkSet<E extends MascoptAbstractLink>
extends MascoptSet<E> {
    private MascoptVertexSet vertexSet_ = null;
    private HashMap<MascoptVertex, AdjacenceTableEntry<E>> incomingEdges_;
    private HashMap<MascoptVertex, AdjacenceTableEntry<E>> outgoingEdges_;
    private HashMap<MascoptVertex, AdjacenceTableEntry<E>> incomingOutgoingEdges_;

    private static final <T extends MascoptAbstractLink> MascoptFixedSet<T> getSet(MascoptVertex vertex, HashMap<MascoptVertex, AdjacenceTableEntry<T>> map, MascoptAbstractLinkSet<T> thisEdgeSet) {
        MascoptFixedSet<T> result;
        if (!thisEdgeSet.getVertexSet().contains(vertex)) {
            return null;
        }
        AdjacenceTableEntry<T> entry = map.get(vertex);
        if (entry != null && entry.getStrongRef() != null) {
            return entry.getStrongRef();
        }
        assert (entry == null || entry.getWeakRef() != null);
        MascoptFixedSet<T> mascoptFixedSet = result = entry != null ? (MascoptFixedSet<T>)entry.getWeakRef().get() : null;
        if (result == null) {
            result = new MascoptFixedSet<T>(thisEdgeSet);
            WeakReference<MascoptFixedSet<T>> newRef = new WeakReference<MascoptFixedSet<T>>(result);
            AdjacenceTableEntry<T> newEntry = new AdjacenceTableEntry<T>(newRef);
            map.put(vertex, newEntry);
        }
        return result;
    }

    private static final <T extends MascoptAbstractLink> void updateAdd(MascoptVertex vertex, T edge, HashMap<MascoptVertex, AdjacenceTableEntry<T>> map, MascoptAbstractLinkSet<T> thisEdgeSet) {
        MascoptFixedSet<T> theSet;
        AdjacenceTableEntry<T> entry = map.get(vertex);
        if (entry != null && entry.getStrongRef() != null) {
            theSet = entry.getStrongRef();
        } else {
            assert (entry == null || entry.getWeakRef() != null);
            MascoptFixedSet<T> mascoptFixedSet = theSet = entry != null ? (MascoptFixedSet<T>)entry.getWeakRef().get() : null;
            if (theSet == null) {
                theSet = new MascoptFixedSet<T>(thisEdgeSet);
                theSet.setName(String.valueOf(Messages.getString("MascoptAbstractEdgeSet.0")) + vertex.getId());
            }
            map.remove(vertex);
            AdjacenceTableEntry<T> newEntry = new AdjacenceTableEntry<T>(theSet);
            map.put(vertex, newEntry);
        }
        theSet.addProtected(edge);
    }

    private static final <T extends MascoptAbstractLink> void updateRemove(MascoptVertex v, T abstractEdge, HashMap<MascoptVertex, AdjacenceTableEntry<T>> map) {
        MascoptFixedSet<T> theSet = null;
        AdjacenceTableEntry<T> entry = map.get(v);
        if (entry != null) {
            theSet = entry.getStrongRef();
        }
        if (theSet != null) {
            theSet.removeProtected(abstractEdge);
            if (theSet.isEmpty()) {
                map.remove(v);
            }
        }
    }

    private void addIn(MascoptVertex abstractVertex, E abstractEdge) {
        MascoptAbstractLinkSet.updateAdd(abstractVertex, abstractEdge, this.incomingEdges_, this);
        MascoptAbstractLinkSet.updateAdd(abstractVertex, abstractEdge, this.incomingOutgoingEdges_, this);
    }

    private void addOut(MascoptVertex abstractVertex, E abstractEdge) {
        MascoptAbstractLinkSet.updateAdd(abstractVertex, abstractEdge, this.outgoingEdges_, this);
        MascoptAbstractLinkSet.updateAdd(abstractVertex, abstractEdge, this.incomingOutgoingEdges_, this);
    }

    public MascoptAbstractLinkSet(MascoptVertexSet nodeSet, String id) {
        super(id);
        this.vertexSet_ = nodeSet;
        this.vertexSet_.addRemoveObserver(this);
        this.incomingEdges_ = new HashMap();
        this.outgoingEdges_ = new HashMap();
        this.incomingOutgoingEdges_ = new HashMap();
    }

    public MascoptAbstractLinkSet(MascoptAbstractLinkSet<E> edgeSet, String id) {
        super(edgeSet, id);
        this.vertexSet_ = edgeSet.getVertexSet();
        this.vertexSet_.addRemoveObserver(this);
        this.incomingEdges_ = new HashMap();
        this.outgoingEdges_ = new HashMap();
        this.incomingOutgoingEdges_ = new HashMap();
    }

    public abstract MascoptAbstractMetaFactory<E, ? extends MascoptAbstractGraph<E>> getFactory();

    @Override
    public boolean add(E e) {
        assert (MascoptAbstractLinkSet.classInvariant(this));
        if (this.contains(e)) {
            return false;
        }
        MascoptVertex[] vertices = ((MascoptAbstractLink)e).toArray();
        MascoptVertex vertex0 = vertices[0];
        MascoptVertex vertex1 = vertices[1];
        if (!this.vertexSet_.contains(vertex0) || !this.vertexSet_.contains(vertex1)) {
            throw new IllegalArgumentException(Messages.getString("MascoptAbstractEdgeSet.1"));
        }
        super.add(e);
        if (e.leavesFrom((MascoptVertex)vertex0)) {
            this.addOut(vertex0, e);
        }
        if (e.leadsTo((MascoptVertex)vertex0)) {
            this.addIn(vertex0, e);
        }
        if (e.leavesFrom((MascoptVertex)vertex1)) {
            this.addOut(vertex1, e);
        }
        if (e.leadsTo((MascoptVertex)vertex1)) {
            this.addIn(vertex1, e);
        }
        assert (MascoptAbstractLinkSet.classInvariant(this));
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        assert (MascoptAbstractLinkSet.classInvariant(this));
        Iterator<E> it_edge = collection.iterator();
        boolean ok = true;
        while (it_edge.hasNext()) {
            boolean adding_ok = this.add((E)((MascoptAbstractLink)it_edge.next()));
            boolean bl = ok = ok && adding_ok;
        }
        assert (MascoptAbstractLinkSet.classInvariant(this));
        return ok;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        assert (MascoptAbstractLinkSet.classInvariant(this));
        Iterator<?> edgeIt = collection.iterator();
        boolean ok = false;
        while (edgeIt.hasNext()) {
            ok &= this.remove(edgeIt.next());
        }
        assert (MascoptAbstractLinkSet.classInvariant(this));
        return ok;
    }

    @Override
    public boolean remove(Object o) {
        assert (MascoptAbstractLinkSet.classInvariant(this));
        if (!super.remove(o)) {
            return false;
        }
        MascoptAbstractLink theAbstractEdge = (MascoptAbstractLink)o;
        MascoptVertex[] vertices = theAbstractEdge.toArray();
        MascoptVertex vertex0 = vertices[0];
        MascoptVertex vertex1 = vertices[1];
        if (theAbstractEdge.leavesFrom(vertex0)) {
            this.removeOut(vertex0, theAbstractEdge);
        }
        if (theAbstractEdge.leadsTo(vertex0)) {
            this.removeIn(vertex0, theAbstractEdge);
        }
        if (theAbstractEdge.leavesFrom(vertex1)) {
            this.removeOut(vertex1, theAbstractEdge);
        }
        if (theAbstractEdge.leadsTo(vertex1)) {
            this.removeIn(vertex1, theAbstractEdge);
        }
        assert (MascoptAbstractLinkSet.classInvariant(this));
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new MascoptAbstractEdgeSetIterator(super.iterator());
    }

    public MascoptVertexSet getVertexSet() {
        return this.vertexSet_;
    }

    public MascoptFixedSet<E> inEdges(MascoptVertex vertex) {
        return MascoptAbstractLinkSet.getSet(vertex, this.incomingEdges_, this);
    }

    public MascoptFixedSet<E> outEdges(MascoptVertex vertex) {
        return MascoptAbstractLinkSet.getSet(vertex, this.outgoingEdges_, this);
    }

    public MascoptFixedSet<E> inOutEdges(MascoptVertex vertex) {
        return MascoptAbstractLinkSet.getSet(vertex, this.incomingOutgoingEdges_, this);
    }

    public MascoptAbstractLinkSet<E> getEdgesConnected(MascoptVertex v1, MascoptVertex v2) {
        MascoptAbstractLinkSet<MascoptAbstractLink> result = this.getFactory().getLinkSetFactory().newLinkSet(this);
        for (MascoptAbstractLink current : this.outEdges(v1)) {
            if (!current.leadsTo(v2)) continue;
            result.add(current);
        }
        return result;
    }

    private static <T extends MascoptAbstractLink> MascoptVertexSet constructNeighborhoodSet(MascoptVertex v, MascoptFixedSet<T> edgeSet) {
        MascoptVertexSet result = new MascoptVertexSet();
        if (edgeSet != null) {
            for (MascoptAbstractLink current : edgeSet) {
                MascoptVertex opposite = current.getOpposite(v);
                assert (opposite != null);
                result.add(opposite);
            }
        }
        return result;
    }

    public MascoptVertexSet neighborhood(MascoptVertex v) {
        return MascoptAbstractLinkSet.constructNeighborhoodSet(v, this.inOutEdges(v));
    }

    public MascoptVertexSet outNeighborhood(MascoptVertex v) {
        return MascoptAbstractLinkSet.constructNeighborhoodSet(v, this.outEdges(v));
    }

    public MascoptVertexSet inNeighborhood(MascoptVertex v) {
        return MascoptAbstractLinkSet.constructNeighborhoodSet(v, this.inEdges(v));
    }

    private void removeIn(MascoptVertex abstractVertex, E abstractEdge) {
        MascoptAbstractLinkSet.updateRemove(abstractVertex, abstractEdge, this.incomingEdges_);
        MascoptAbstractLinkSet.updateRemove(abstractVertex, abstractEdge, this.incomingOutgoingEdges_);
    }

    private void removeOut(MascoptVertex abstractVertex, E abstractEdge) {
        MascoptAbstractLinkSet.updateRemove(abstractVertex, abstractEdge, this.outgoingEdges_);
        MascoptAbstractLinkSet.updateRemove(abstractVertex, abstractEdge, this.incomingOutgoingEdges_);
    }

    private void copyHashMapWithValueCopy(HashMap<MascoptVertex, AdjacenceTableEntry<E>> original, HashMap<MascoptVertex, AdjacenceTableEntry<E>> copy) {
        for (MascoptVertex currentKey : original.keySet()) {
            MascoptFixedSet value = MascoptAbstractLinkSet.getSet(currentKey, original, this);
            if (value == null) continue;
            MascoptObject valueCopy = value.clone();
            AdjacenceTableEntry newEntry = new AdjacenceTableEntry(valueCopy);
            copy.put(currentKey, newEntry);
        }
    }

    @Override
    public MascoptAbstractLinkSet<E> clone() {
        MascoptAbstractLinkSet copy = (MascoptAbstractLinkSet)super.clone();
        copy.incomingEdges_ = new HashMap();
        this.copyHashMapWithValueCopy(this.incomingEdges_, copy.incomingEdges_);
        copy.outgoingEdges_ = new HashMap();
        this.copyHashMapWithValueCopy(this.outgoingEdges_, copy.outgoingEdges_);
        copy.incomingOutgoingEdges_ = new HashMap();
        this.copyHashMapWithValueCopy(this.incomingOutgoingEdges_, copy.incomingOutgoingEdges_);
        return copy;
    }

    @Override
    protected void finalize() {
        super.finalize();
        this.incomingEdges_.clear();
        this.incomingEdges_ = null;
        this.outgoingEdges_.clear();
        this.outgoingEdges_ = null;
        this.incomingOutgoingEdges_.clear();
        this.incomingOutgoingEdges_ = null;
    }

    @Override
    public void update(MascoptObservableObject o, Notification arg) {
        assert (MascoptAbstractLinkSet.classInvariant(this));
        Object[] objs = arg.getObjects();
        MascoptObservableObject.MascoptEventType message = arg.getEventType();
        if (message == MascoptObservableObject.MascoptEventType.REMOVE && objs[0] instanceof MascoptVertex) {
            MascoptVertex theRemovedVertex = (MascoptVertex)objs[0];
            MascoptFixedSet<E> tmp = this.inOutEdges(theRemovedVertex);
            Iterator<E> eIt = tmp.iterator();
            ArrayList<MascoptAbstractLink> toRemove = new ArrayList<MascoptAbstractLink>();
            while (eIt.hasNext()) {
                toRemove.add((MascoptAbstractLink)eIt.next());
            }
            this.removeAll(toRemove);
        }
        assert (MascoptAbstractLinkSet.classInvariant(this));
    }

    @Override
    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        this.getVertexSet().toDOMTreeAsRef(node_to_go);
        return node_to_go;
    }

    private static <T extends MascoptAbstractLink> boolean testAllSetOfMapIsEmpty(HashMap<MascoptVertex, AdjacenceTableEntry<T>> map) {
        Iterator<MascoptVertex> it = map.keySet().iterator();
        while (it.hasNext()) {
            MascoptFixedSet<T> set;
            AdjacenceTableEntry<T> entry = map.get(it.next());
            if (entry != null && entry.getWeakRef() != null) {
                return true;
            }
            if (entry == null || entry.getStrongRef() == null || (set = entry.getStrongRef()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static <T extends MascoptAbstractLink> void verifyAdjacenceTable(HashMap<MascoptVertex, AdjacenceTableEntry<T>> adjacenceTable, MascoptFixedSet<T> edgeSet) {
        for (AdjacenceTableEntry<T> value : adjacenceTable.values()) {
            MascoptFixedSet currentSet = value.getStrongRef() != null ? value.getStrongRef() : (MascoptFixedSet)value.getWeakRef().get();
            if (currentSet != null && !edgeSet.containsAll(currentSet)) assert (false);
        }
    }

    static <T extends MascoptAbstractLink> boolean classInvariant(MascoptAbstractLinkSet<T> current) {
        if (current.isEmpty()) {
            if (!MascoptAbstractLinkSet.testAllSetOfMapIsEmpty(current.incomingEdges_) || !MascoptAbstractLinkSet.testAllSetOfMapIsEmpty(current.outgoingEdges_) || !MascoptAbstractLinkSet.testAllSetOfMapIsEmpty(current.incomingOutgoingEdges_)) assert (false);
            return true;
        }
        for (MascoptAbstractLink edge : current) {
            MascoptFixedSet<T> outV0;
            MascoptFixedSet<T> inV1;
            MascoptFixedSet<T> outV1;
            MascoptFixedSet<T> inV0;
            MascoptVertex[] vertices = edge.toArray();
            MascoptFixedSet<T> inoutV0 = MascoptAbstractLinkSet.getSet(vertices[0], current.incomingOutgoingEdges_, current);
            MascoptFixedSet<T> inoutV1 = MascoptAbstractLinkSet.getSet(vertices[1], current.incomingOutgoingEdges_, current);
            if (!inoutV0.contains(edge) || !inoutV1.contains(edge)) assert (false);
            if (edge.leadsTo(vertices[0])) {
                inV0 = MascoptAbstractLinkSet.getSet(vertices[0], current.incomingEdges_, current);
                outV1 = MascoptAbstractLinkSet.getSet(vertices[1], current.outgoingEdges_, current);
                if (!inV0.contains(edge) || !outV1.contains(edge)) assert (false);
            }
            if (edge.leadsTo(vertices[1])) {
                inV1 = MascoptAbstractLinkSet.getSet(vertices[1], current.incomingEdges_, current);
                outV0 = MascoptAbstractLinkSet.getSet(vertices[0], current.outgoingEdges_, current);
                if (!inV1.contains(edge) || !outV0.contains(edge)) assert (false);
            }
            if (edge.leavesFrom(vertices[0])) {
                inV1 = MascoptAbstractLinkSet.getSet(vertices[1], current.incomingEdges_, current);
                outV0 = MascoptAbstractLinkSet.getSet(vertices[0], current.outgoingEdges_, current);
                if (!inV1.contains(edge) || !outV0.contains(edge)) assert (false);
            }
            if (!edge.leavesFrom(vertices[1])) continue;
            inV0 = MascoptAbstractLinkSet.getSet(vertices[0], current.incomingEdges_, current);
            outV1 = MascoptAbstractLinkSet.getSet(vertices[1], current.outgoingEdges_, current);
            if (!inV0.contains(edge) || !outV1.contains(edge)) assert (false);
        }
        MascoptAbstractLinkSet.verifyAdjacenceTable(current.incomingEdges_, current);
        MascoptAbstractLinkSet.verifyAdjacenceTable(current.outgoingEdges_, current);
        MascoptAbstractLinkSet.verifyAdjacenceTable(current.incomingOutgoingEdges_, current);
        return true;
    }

    private static class AdjacenceTableEntry<T extends MascoptAbstractLink> {
        private WeakReference<MascoptFixedSet<T>> weakRef;
        private MascoptFixedSet<T> strongRef;

        public AdjacenceTableEntry(WeakReference<MascoptFixedSet<T>> ref) {
            this.weakRef = ref;
            this.strongRef = null;
        }

        public AdjacenceTableEntry(MascoptFixedSet<T> set) {
            this.weakRef = null;
            this.strongRef = set;
        }

        public WeakReference<MascoptFixedSet<T>> getWeakRef() {
            return this.weakRef;
        }

        public MascoptFixedSet<T> getStrongRef() {
            return this.strongRef;
        }
    }

    private class MascoptAbstractEdgeSetIterator
    implements Iterator<E> {
        private Iterator<E> realIt_;
        private E lastObjectReturn_;

        public MascoptAbstractEdgeSetIterator(Iterator<E> realIt) {
            this.realIt_ = realIt;
            this.lastObjectReturn_ = null;
        }

        @Override
        public boolean hasNext() {
            return this.realIt_.hasNext();
        }

        @Override
        public E next() {
            this.lastObjectReturn_ = (MascoptAbstractLink)this.realIt_.next();
            return this.lastObjectReturn_;
        }

        @Override
        public void remove() {
            if (this.lastObjectReturn_ != null) {
                MascoptAbstractLinkSet.this.throwExceptionForAddRemoveOperation();
                this.realIt_.remove();
                MascoptVertex[] vertices = ((MascoptAbstractLink)this.lastObjectReturn_).toArray();
                MascoptVertex vertex0 = vertices[0];
                MascoptVertex vertex1 = vertices[1];
                if (this.lastObjectReturn_.leavesFrom((MascoptVertex)vertex0)) {
                    MascoptAbstractLinkSet.this.removeOut(vertex0, this.lastObjectReturn_);
                }
                if (this.lastObjectReturn_.leadsTo((MascoptVertex)vertex0)) {
                    MascoptAbstractLinkSet.this.removeIn(vertex0, this.lastObjectReturn_);
                }
                if (this.lastObjectReturn_.leavesFrom((MascoptVertex)vertex1)) {
                    MascoptAbstractLinkSet.this.removeOut(vertex1, this.lastObjectReturn_);
                }
                if (this.lastObjectReturn_.leadsTo((MascoptVertex)vertex1)) {
                    MascoptAbstractLinkSet.this.removeIn(vertex1, this.lastObjectReturn_);
                }
                this.lastObjectReturn_ = null;
                return;
            }
            throw new IllegalStateException();
        }
    }
}

