/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptEdgeSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;

public class MascoptAbstractLinkSetTest
extends TestCase {
    private MascoptVertexSet vertexSet_;
    private MascoptEdgeSet edgeSet_;
    private MascoptVertex[] vertices_;
    private MascoptEdge[] edges_;
    private final int NB_VERTEX = 20;

    private void fillEdgeSet(HashSet<MascoptEdge> addedEdges) {
        int i = 0;
        while (i < 400) {
            if (addedEdges != null) {
                addedEdges.add(this.edges_[i]);
            }
            this.edgeSet_.add(this.edges_[i]);
            i += 3;
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.vertexSet_ = new MascoptVertexSet();
        this.edgeSet_ = new MascoptEdgeSet(this.vertexSet_);
        this.vertices_ = new MascoptVertex[20];
        this.edges_ = new MascoptEdge[400];
        int i = 0;
        while (i < 20) {
            this.vertices_[i] = new MascoptVertex();
            this.vertexSet_.add(this.vertices_[i]);
            ++i;
        }
        i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                this.edges_[i * 20 + j] = new MascoptEdge(this.vertices_[i], this.vertices_[j]);
                ++j;
            }
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.vertexSet_.clear();
        this.vertexSet_ = null;
        this.edgeSet_.clear();
        this.edgeSet_ = null;
        this.vertices_ = null;
        this.edges_ = null;
    }

    public static Test suite() {
        return new TestSuite(MascoptAbstractLinkSetTest.class);
    }

    public void testRemoveAll() {
        HashSet<MascoptEdge> tmp = new HashSet<MascoptEdge>();
        this.fillEdgeSet(tmp);
        this.edgeSet_.removeAll(tmp);
        Assert.assertTrue((boolean)this.edgeSet_.isEmpty());
    }

    public void testRemoveObject() {
        try {
            this.edgeSet_.remove(new Boolean(true));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddMascoptAbstractEdge() {
        Assert.assertTrue((boolean)this.edgeSet_.isEmpty());
        this.edgeSet_.add(this.edges_[0]);
        Assert.assertTrue((boolean)this.edgeSet_.contains(this.edges_[0]));
        Assert.assertTrue((this.edgeSet_.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((!this.edgeSet_.isEmpty() ? 1 : 0) != 0);
    }

    public void testAddAllMascoptAbstractEdgeSet() {
        HashSet<MascoptEdge> tmp = new HashSet<MascoptEdge>();
        this.fillEdgeSet(tmp);
        this.edgeSet_.clear();
        Assert.assertEquals((int)this.edgeSet_.size(), (int)0);
        this.edgeSet_.addAll(tmp);
        Assert.assertEquals((int)this.edgeSet_.size(), (int)tmp.size());
    }

    public void testRemoveMascoptAbstractEdge() {
        Assert.assertTrue((!this.edgeSet_.contains(this.edges_[0]) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.edgeSet_.isEmpty());
        this.edgeSet_.add(this.edges_[0]);
        Assert.assertTrue((boolean)this.edgeSet_.contains(this.edges_[0]));
        Assert.assertTrue((this.edgeSet_.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((!this.edgeSet_.isEmpty() ? 1 : 0) != 0);
        this.edgeSet_.remove(this.edges_[0]);
        Assert.assertTrue((boolean)this.edgeSet_.isEmpty());
        Assert.assertTrue((!this.edgeSet_.contains(this.edges_[0]) ? 1 : 0) != 0);
    }

    public void testInEdges() {
        this.edgeSet_.add(this.edges_[0]);
        this.edgeSet_.add(this.edges_[1]);
        Assert.assertTrue((this.edgeSet_.inEdges(this.vertices_[0]).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((this.edgeSet_.inEdges(this.vertices_[1]).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.edgeSet_.size() == 2 ? 1 : 0) != 0);
    }

    public void testOutEdges() {
        this.edgeSet_.add(this.edges_[0]);
        this.edgeSet_.add(this.edges_[1]);
        Assert.assertTrue((this.edgeSet_.outEdges(this.vertices_[0]).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((this.edgeSet_.outEdges(this.vertices_[1]).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.edgeSet_.size() == 2 ? 1 : 0) != 0);
    }

    public void testInOutEdges() {
        this.edgeSet_.add(this.edges_[0]);
        this.edgeSet_.add(this.edges_[1]);
        Assert.assertTrue((this.edgeSet_.inOutEdges(this.vertices_[0]).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((this.edgeSet_.inOutEdges(this.vertices_[1]).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.edgeSet_.size() == 2 ? 1 : 0) != 0);
    }

    public void testNeighborhood() {
        this.edgeSet_.add(this.edges_[0]);
        this.edgeSet_.add(this.edges_[20]);
        MascoptVertexSet neighbors = this.edgeSet_.neighborhood(this.vertices_[0]);
        Assert.assertEquals((int)neighbors.size(), (int)2);
        Assert.assertTrue((boolean)neighbors.contains(this.vertices_[0]));
        Assert.assertTrue((boolean)neighbors.contains(this.vertices_[1]));
    }

    public void testOutNeighborhood() {
        this.edgeSet_.add(this.edges_[0]);
        this.edgeSet_.add(this.edges_[20]);
        MascoptVertexSet neighbors = this.edgeSet_.outNeighborhood(this.vertices_[0]);
        Assert.assertEquals((int)neighbors.size(), (int)2);
        Assert.assertTrue((boolean)neighbors.contains(this.vertices_[0]));
        Assert.assertTrue((boolean)neighbors.contains(this.vertices_[1]));
    }

    public void testInNeighborhood() {
        this.edgeSet_.add(this.edges_[0]);
        this.edgeSet_.add(this.edges_[20]);
        MascoptVertexSet neighbors = this.edgeSet_.inNeighborhood(this.vertices_[0]);
        Assert.assertEquals((int)neighbors.size(), (int)2);
        Assert.assertTrue((boolean)neighbors.contains(this.vertices_[0]));
        Assert.assertTrue((boolean)neighbors.contains(this.vertices_[1]));
    }

    private boolean isPresent(Object[] array, Object element) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void testIterator() {
        int i = 0;
        while (i < this.edges_.length) {
            this.edgeSet_.add(this.edges_[i]);
            ++i;
        }
        Iterator it = this.edgeSet_.iterator();
        while (it.hasNext()) {
            MascoptEdge current = (MascoptEdge)it.next();
            Assert.assertTrue((boolean)this.isPresent(this.edges_, current));
            it.remove();
        }
        try {
            it.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.edgeSet_.isEmpty());
    }

    public void testClone() {
        this.fillEdgeSet(null);
        MascoptEdgeSet copy = this.edgeSet_.clone();
        Assert.assertTrue((boolean)MascoptAbstractLinkSet.classInvariant(copy));
        Assert.assertTrue((copy.size() == this.edgeSet_.size() ? 1 : 0) != 0);
        copy.removeAll(this.edgeSet_);
        Assert.assertTrue((copy.size() == 0 ? 1 : 0) != 0);
    }
}

