/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import bridge.interfaces.Graph;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptArcSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.factory.MascoptDirectedMetaFactory;
import mascoptLib.core.factory.abstracts.MascoptAbstractMetaFactory;

public class MascoptDiGraph
extends MascoptAbstractGraph<MascoptArc>
implements Graph<MascoptVertex, MascoptArc> {
    private static int idGenerator = 0;

    public MascoptDiGraph(MascoptArcSet arcSet) {
        this(arcSet, (MascoptAbstractMetaFactory<MascoptArc, MascoptAbstractGraph<MascoptArc>>)new MascoptDirectedMetaFactory());
    }

    public MascoptDiGraph(MascoptArcSet arcSet, MascoptAbstractMetaFactory<MascoptArc, MascoptAbstractGraph<MascoptArc>> factory) {
        super(arcSet, factory, "DG" + idGenerator++);
        arcSet.addAddObserver(this);
        arcSet.addRemoveObserver(this);
        arcSet.addValueObserver(this);
    }

    public MascoptDiGraph(MascoptDiGraph digraph) {
        this(digraph, (MascoptAbstractMetaFactory<MascoptArc, MascoptAbstractGraph<MascoptArc>>)new MascoptDirectedMetaFactory());
    }

    public MascoptDiGraph(MascoptDiGraph digraph, MascoptAbstractMetaFactory<MascoptArc, MascoptAbstractGraph<MascoptArc>> factory) {
        super(digraph, factory, "DG" + idGenerator++);
        MascoptArcSet subEdgeSet = new MascoptArcSet((MascoptArcSet)digraph.edgeSet());
        subEdgeSet.addAddObserver(this);
        subEdgeSet.addRemoveObserver(this);
        subEdgeSet.addValueObserver(this);
    }

    public MascoptArcSet arcSet() {
        return (MascoptArcSet)this.edgeSet();
    }

    public MascoptDiGraph inverse() {
        MascoptArcSet newArcSet = new MascoptArcSet((MascoptVertexSet)this.vertexSet());
        for (MascoptArc current : this.edgeSet()) {
            MascoptArc invCurrent = new MascoptArc(current.getHead(), current.getTail());
            newArcSet.add(invCurrent);
        }
        MascoptDiGraph newGraph = new MascoptDiGraph(newArcSet);
        return newGraph;
    }

    @Override
    public MascoptDiGraph clone() {
        return (MascoptDiGraph)super.clone();
    }

    @Override
    public String getDOMTagName() {
        return "DIGRAPH";
    }
}

