/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import bridge.interfaces.HierarchicalSet;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.Messages;
import mascoptLib.core.Notification;
import mascoptLib.exception.MascoptAddRemoveSetException;
import org.w3c.dom.Element;

public class MascoptFixedSet<E extends MascoptObject>
extends MascoptObject
implements HierarchicalSet<E> {
    private static int idGenerator = 0;
    private MascoptFixedSet<E> superSet = null;
    private HashSet<WeakReference<MascoptFixedSet<E>>> subSet = new HashSet();
    private HashSet<E> realSet = new HashSet();

    private void addToSubSetList(MascoptFixedSet<E> subSet) {
        WeakReference<MascoptFixedSet<E>> newRef = new WeakReference<MascoptFixedSet<E>>(subSet);
        this.subSet.add(newRef);
    }

    private void removeFromSubSetList(MascoptFixedSet<E> toSuppress) {
        Iterator<WeakReference<MascoptFixedSet<E>>> it = this.subSet.iterator();
        while (it.hasNext()) {
            WeakReference<MascoptFixedSet<E>> ref = it.next();
            MascoptFixedSet set = (MascoptFixedSet)ref.get();
            if (set != toSuppress) continue;
            it.remove();
            return;
        }
    }

    private void RemoveElementInSubSet(Object o) {
        Iterator<WeakReference<MascoptFixedSet<E>>> it = this.subSet.iterator();
        while (it.hasNext()) {
            WeakReference<MascoptFixedSet<E>> ref = it.next();
            MascoptFixedSet set = (MascoptFixedSet)ref.get();
            if (set != null) {
                set.removeProtected((MascoptObject)o);
                continue;
            }
            it.remove();
        }
    }

    @Override
    public boolean isSubSetOf(HierarchicalSet<?> set) {
        return this.superSet == set;
    }

    @Override
    public HierarchicalSet<E> newSubSet() {
        return new MascoptFixedSet<E>(this, "FS" + idGenerator++);
    }

    @Override
    public HierarchicalSet<E> newSubSet(Iterator<? extends E> it) throws IllegalArgumentException {
        MascoptFixedSet<MascoptObject> result = new MascoptFixedSet<MascoptObject>(this, "FS" + idGenerator++);
        while (it.hasNext()) {
            MascoptObject elem = (MascoptObject)it.next();
            result.addProtected(elem);
        }
        return result;
    }

    MascoptFixedSet(String id) {
        super(id);
    }

    MascoptFixedSet(MascoptFixedSet<E> superSet, String id) {
        this(id);
        this.superSet = superSet;
        super.addToSubSetList(this);
    }

    MascoptFixedSet(MascoptFixedSet<E> superSet) {
        this(superSet, "FS" + idGenerator++);
    }

    @Override
    public HierarchicalSet<E> getSuperSet() {
        return this.superSet;
    }

    public boolean isSubSet() {
        return this.superSet != null;
    }

    @Override
    public int hashCode() {
        return this.realSet.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this.realSet.equals(object);
    }

    @Override
    public boolean contains(Object object) {
        return this.realSet.contains(object);
    }

    @Override
    public int size() {
        return this.realSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.realSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator<E> it = this.iterator();
        T[] result = a;
        int i = 0;
        while (i < size) {
            result[i] = it.next();
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public Iterator<E> iterator() {
        return new FixedIterator();
    }

    @Override
    public boolean isEmpty() {
        return this.realSet.isEmpty();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.realSet.containsAll(collection);
    }

    @Override
    public void disconnect() {
        super.removeFromSubSetList(this);
        this.superSet = null;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        Iterator<E> elements = this.iterator();
        String toS = "{ " + elements.next();
        while (elements.hasNext()) {
            toS = String.valueOf(toS) + " , " + elements.next();
        }
        toS = String.valueOf(toS) + " }";
        return toS;
    }

    @Override
    public MascoptFixedSet<E> clone() {
        MascoptFixedSet copy = (MascoptFixedSet)super.clone();
        copy.realSet = (HashSet)this.realSet.clone();
        copy.subSet = new HashSet();
        if (this.superSet != null) {
            super.addToSubSetList(copy);
        }
        return copy;
    }

    protected void finalize() {
        this.realSet = null;
    }

    @Override
    public boolean add(E object) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    @Override
    public boolean remove(Object object) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    @Override
    public void clear() {
        this.throwExceptionForAddRemoveOperation();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    protected boolean addProtected(E mascoptobject) {
        boolean result;
        if (this.superSet != null && !this.superSet.contains(mascoptobject)) {
            new IllegalArgumentException(Messages.getString("MascoptFixedSet.notInSuperSet"));
        }
        if (result = this.realSet.add(mascoptobject)) {
            Object[] t = new Object[]{mascoptobject};
            this.notifyAddObservers(t);
        }
        return result;
    }

    protected boolean removeProtected(MascoptObject mascoptobject) {
        boolean result;
        if (this.contains(mascoptobject)) {
            Object[] t = new Object[]{mascoptobject, this};
            this.notifyRemoveObservers(t);
        }
        if (result = this.realSet.remove(mascoptobject)) {
            this.RemoveElementInSubSet(mascoptobject);
        }
        return result;
    }

    protected void clearProtected() {
        Iterator<E> it = this.realSet.iterator();
        while (it.hasNext()) {
            MascoptObject current = (MascoptObject)it.next();
            Object[] t = new Object[]{current, this};
            this.notifyRemoveObservers(t);
            it.remove();
            this.RemoveElementInSubSet(current);
        }
    }

    protected boolean removeAllProtected(Collection<?> collection) {
        boolean result = false;
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            result |= this.removeProtected((MascoptObject)it.next());
        }
        return result;
    }

    protected boolean retainAllProtected(Collection<?> collection) {
        boolean result = false;
        Iterator<E> it = this.realSet.iterator();
        while (it.hasNext()) {
            MascoptObject current = (MascoptObject)it.next();
            if (collection.contains(current)) continue;
            Object[] t = new Object[]{current, this};
            this.notifyRemoveObservers(t);
            it.remove();
            this.RemoveElementInSubSet(current);
        }
        return result;
    }

    protected void throwExceptionForAddRemoveOperation() throws MascoptAddRemoveSetException {
        throw new MascoptAddRemoveSetException();
    }

    @Override
    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        for (MascoptObject object : this) {
            object.toDOMTreeAsRef(node_to_go);
        }
        if (this.isSubSet()) {
            ((MascoptObject)((Object)this.getSuperSet())).toDOMTreeAsRef(node_to_go);
        }
        return node_to_go;
    }

    @Override
    public String getDOMTagHierarchy() {
        return "SETS";
    }

    @Override
    public String getDOMTagName() {
        return "FIXED_SET";
    }

    @Override
    public void update(MascoptObservableObject observable, Notification message) {
    }

    private class FixedIterator
    implements Iterator<E> {
        Iterator<E> realIt;

        public FixedIterator() {
            this.realIt = MascoptFixedSet.this.realSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.realIt.hasNext();
        }

        @Override
        public E next() {
            return (MascoptObject)this.realIt.next();
        }

        @Override
        public void remove() {
            MascoptFixedSet.this.throwExceptionForAddRemoveOperation();
            this.realIt.remove();
        }
    }
}

