/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import bridge.interfaces.Graph;
import java.util.Iterator;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptEdgeSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.factory.MascoptUndirectedMetaFactory;
import mascoptLib.core.factory.abstracts.MascoptAbstractMetaFactory;

public class MascoptGraph
extends MascoptAbstractGraph<MascoptEdge>
implements Graph<MascoptVertex, MascoptEdge> {
    private static int idGenerator_ = 0;

    public MascoptGraph(MascoptEdgeSet edgeSet, MascoptUndirectedMetaFactory factory) {
        super(edgeSet, factory, "G" + idGenerator_++);
        edgeSet.addAddObserver(this);
        edgeSet.addRemoveObserver(this);
        edgeSet.addValueObserver(this);
    }

    public MascoptGraph(MascoptEdgeSet edgeSet) {
        this(edgeSet, new MascoptUndirectedMetaFactory());
    }

    public MascoptGraph(MascoptGraph graph, MascoptAbstractMetaFactory<MascoptEdge, MascoptAbstractGraph<MascoptEdge>> factory) {
        super(graph, factory, "G" + idGenerator_++);
        MascoptEdgeSet subEdgeSet = new MascoptEdgeSet((MascoptEdgeSet)graph.edgeSet());
        subEdgeSet.addAddObserver(this);
        subEdgeSet.addRemoveObserver(this);
        subEdgeSet.addValueObserver(this);
    }

    public MascoptGraph(MascoptGraph graph) {
        this(graph, (MascoptAbstractMetaFactory<MascoptEdge, MascoptAbstractGraph<MascoptEdge>>)new MascoptUndirectedMetaFactory());
    }

    public MascoptGraph inverse() {
        MascoptEdgeSet newEdgeSet = new MascoptEdgeSet((MascoptVertexSet)this.vertexSet());
        Iterator edgeIt = ((MascoptAbstractLinkSet)this.edgeSet()).iterator();
        while (edgeIt.hasNext()) {
            newEdgeSet.add((MascoptEdge)edgeIt.next());
        }
        MascoptGraph newGraph = new MascoptGraph(newEdgeSet);
        return newGraph;
    }

    @Override
    public MascoptGraph clone() {
        return (MascoptGraph)super.clone();
    }

    public MascoptUndirectedMetaFactory getFactory() {
        return (MascoptUndirectedMetaFactory)super.getFactory();
    }

    @Override
    public String getDOMTagName() {
        return "GRAPH";
    }
}

