/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import bridge.abstractClasses.AbstractScalar;
import bridge.interfaces.HierarchicalSet;
import bridge.interfaces.Map;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.Messages;
import mascoptLib.core.Notification;
import mascoptLib.core.factory.MascoptMapFactory;
import org.w3c.dom.Element;
import tools.dataStructures.Pair;

public class MascoptMap
extends MascoptObject
implements Map {
    private static final String packagePathRegExp = "[^\\.]+\\.";
    private HashMap<MascoptObject, HashMap<MascoptObject, Vector<Pair<String, Object>>>> relations = new HashMap();
    private volatile long modCount;
    private static int idGenerator = 0;
    private final MascoptMapFactory factory;

    public MascoptMap(MascoptMapFactory factory) {
        super("M" + idGenerator++);
        this.factory = factory;
    }

    public MascoptMap() {
        this(new MascoptMapFactory());
    }

    private Object getObject(Object o, String name, Object context) {
        HashMap<MascoptObject, Vector<Pair<String, Object>>> subRelation;
        if (this.relations.containsKey(o) && (subRelation = this.relations.get(o)).containsKey(context)) {
            Vector<Pair<String, Object>> valueNames = subRelation.get(context);
            int i = 0;
            while (i < valueNames.size()) {
                if (valueNames.get(i).getKey().equals(name)) {
                    return valueNames.get(i).getValue();
                }
                ++i;
            }
        }
        return null;
    }

    private void putObject(MascoptObject o, String name, MascoptObject context, Object value) {
        if (this.relations.containsKey(o)) {
            HashMap<MascoptObject, Vector<Pair<String, Object>>> subRelation = this.relations.get(o);
            if (subRelation.containsKey(context)) {
                Vector<Pair<String, Object>> valueNames = subRelation.get(context);
                int i = 0;
                while (i < valueNames.size()) {
                    if (valueNames.get(i).getKey().equals(name)) {
                        valueNames.set(i, new Pair<String, Object>(name, value));
                        return;
                    }
                    ++i;
                }
                valueNames.add(new Pair<String, Object>(name, value));
            } else {
                Vector<Pair<String, Object>> valueNames = new Vector<Pair<String, Object>>();
                valueNames.add(new Pair<String, Object>(name, value));
                subRelation.put(context, valueNames);
            }
        } else {
            HashMap subRelation = new HashMap();
            this.relations.put(o, subRelation);
            Vector<Pair<String, Object>> valueNames = new Vector<Pair<String, Object>>();
            valueNames.add(new Pair<String, Object>(name, value));
            subRelation.put(context, valueNames);
        }
    }

    private boolean removeRelation(MascoptObject o, String name, MascoptObject context) {
        HashMap<MascoptObject, Vector<Pair<String, Object>>> subRelation;
        if (this.relations.containsKey(o) && (subRelation = this.relations.get(o)).containsKey(context)) {
            Vector<Pair<String, Object>> valueNames = subRelation.get(context);
            int i = 0;
            while (i < valueNames.size()) {
                if (valueNames.get(i).getKey().equals(name)) {
                    valueNames.remove(i);
                    if (valueNames.size() == 0) {
                        subRelation.remove(context);
                        if (subRelation.keySet().size() == 0) {
                            this.relations.remove(o);
                        }
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void notifyChange(Object o, String valueName, Object context) {
        Object[] obj = new Object[]{o, valueName, context};
        this.notifyValueObservers(obj);
    }

    private void notifyRemove(Object o, String valueName, Object context) {
        Object[] obj = new Object[]{o, valueName, context};
        this.notifyRemoveObservers(obj);
    }

    @Override
    public boolean contains(Object o, String name, Object context) {
        return this.getObject(o, name, context) != null;
    }

    @Override
    public boolean contains(Object o, String name) {
        return this.contains(o, name, o);
    }

    @Override
    public boolean contains(Object o) {
        return this.relations.containsKey(o);
    }

    public Iterator<? extends MascoptObject> keysIterator() {
        return new IteratorWithoutRemove<MascoptObject>(this.relations.keySet().iterator());
    }

    @Override
    public Iterator<String> namesIterator(Object o, Object context) {
        return new NameIterator((MascoptObject)o, (MascoptObject)context);
    }

    @Override
    public Iterator<String> namesIterator(Object o) {
        return this.namesIterator(o, o);
    }

    public Iterator<? extends MascoptObject> contextsIterator(Object o, String name) {
        return new ContextWithNameIterator(o, name);
    }

    public Iterator<? extends MascoptObject> contextsIterator(Object o) {
        return new ContextIterator((MascoptObject)o);
    }

    @Override
    public String getDataType(Object o, String name, Object context) {
        Object value = this.getObject(o, name, context);
        if (value == null) {
            return null;
        }
        return value.getClass().getName().replaceAll(packagePathRegExp, "");
    }

    @Override
    public String getDataType(Object o, String name) {
        return this.getDataType(o, name, o);
    }

    @Override
    public AbstractScalar getValue(Object o, String name, Object context) {
        return (AbstractScalar)this.getObject(o, name, context);
    }

    @Override
    public AbstractScalar getValue(Object o, String name) {
        return this.getValue(o, name, o);
    }

    @Override
    public String getString(Object o, String name, Object context) {
        assert (this.getDataType(o, name, context).equals("String"));
        return (String)this.getObject(o, name, context);
    }

    @Override
    public String getString(Object o, String name) {
        return this.getString(o, name, o);
    }

    @Override
    public void putValue(Object o, String name, Object context, AbstractScalar value) {
        ++this.modCount;
        this.putObject((MascoptObject)o, name, (MascoptObject)context, value);
        this.notifyChange(o, name, context);
    }

    @Override
    public void putValue(Object o, String name, AbstractScalar value) {
        this.putValue(o, name, o, value);
    }

    @Override
    public void putString(Object o, String name, Object context, String value) {
        ++this.modCount;
        this.putObject((MascoptObject)o, name, (MascoptObject)context, value);
        this.notifyChange(o, name, context);
    }

    @Override
    public void putString(Object o, String name, String value) {
        this.putString(o, name, o, value);
    }

    @Override
    public void putAll(java.util.Map<?, ?> m, String name, Object context) throws IllegalArgumentException {
        for (Map.Entry<?, ?> current : m.entrySet()) {
            Object key = current.getKey();
            Object value = current.getValue();
            if (value instanceof AbstractScalar) {
                this.putValue(key, name, context, (AbstractScalar)value);
                continue;
            }
            if (value instanceof String) {
                this.putString(key, name, context, (String)value);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void putAll(java.util.Map<?, ?> m, String name) throws IllegalArgumentException {
        for (Map.Entry<?, ?> current : m.entrySet()) {
            Object key = current.getKey();
            Object value = current.getValue();
            if (value instanceof AbstractScalar) {
                this.putValue(key, name, key, (AbstractScalar)value);
                continue;
            }
            if (value instanceof String) {
                this.putString(key, name, key, (String)value);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean remove(Object o, String name, Object context) {
        ++this.modCount;
        this.notifyRemove(o, name, context);
        boolean result = this.removeRelation((MascoptObject)o, name, (MascoptObject)context);
        return result;
    }

    @Override
    public boolean remove(Object o, String name) {
        return this.remove(o, name, o);
    }

    @Override
    public void removeAll(Object o, Object context) {
        ++this.modCount;
        NameIterator nameIt = new NameIterator((MascoptObject)o, (MascoptObject)context);
        while (nameIt.hasNext()) {
            nameIt.next();
            nameIt.remove();
        }
    }

    @Override
    public void removeAll(Object o) {
        ++this.modCount;
        ContextIterator contextIt = new ContextIterator((MascoptObject)o);
        while (contextIt.hasNext()) {
            contextIt.next();
            contextIt.remove();
        }
    }

    @Override
    public void clear() {
        HashSet<MascoptObject> copy = new HashSet<MascoptObject>(this.relations.keySet());
        Iterator<MascoptObject> keyIt = copy.iterator();
        while (keyIt.hasNext()) {
            this.removeAll(keyIt.next());
        }
    }

    @Override
    public String getDOMTagHierarchy() {
        return "MAPS";
    }

    @Override
    public String getDOMTagName() {
        return "MAP";
    }

    @Override
    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        Iterator<? extends MascoptObject> it_objects = this.keysIterator();
        while (it_objects.hasNext()) {
            MascoptObject o = it_objects.next();
            Iterator<? extends MascoptObject> it_contexts = this.contextsIterator(o);
            while (it_contexts.hasNext()) {
                MascoptObject context = it_contexts.next();
                Iterator<String> it_name = this.namesIterator(o, context);
                while (it_name.hasNext()) {
                    String name = it_name.next();
                    String type = this.getDataType(o, name, context);
                    Element new_node = element.getOwnerDocument().createElement("ENTRY");
                    new_node.setAttribute("type", type);
                    new_node.setAttribute("name", name);
                    Element entry_node = (Element)node_to_go.appendChild(new_node);
                    o.toDOMTreeAsRef(entry_node);
                    context.toDOMTreeAsRef(entry_node);
                    String value = type.compareTo("String") == 0 ? this.getString(o, name, context) : this.getValue(o, name, context).toString();
                    new_node.setAttribute("value", value);
                }
            }
        }
        return node_to_go;
    }

    @Override
    public String toString() {
        String result = new String();
        Iterator<? extends MascoptObject> it_keys = this.keysIterator();
        while (it_keys.hasNext()) {
            MascoptObject o = it_keys.next();
            result = String.valueOf(result) + Messages.getString("MascoptMap.object") + o.getName() + System.getProperty("line.separator");
            Iterator<? extends MascoptObject> contexts = this.contextsIterator(o);
            while (contexts.hasNext()) {
                MascoptObject c = contexts.next();
                Iterator<String> names = this.namesIterator(o, c);
                while (names.hasNext()) {
                    String name = names.next();
                    result = String.valueOf(result) + String.format(Messages.getString("MascoptMap.entry"), c.getName(), name, this.getDataType(o, name, c), System.getProperty("line.separator"));
                }
            }
        }
        return result;
    }

    public MascoptMapFactory getFactory() {
        return this.factory;
    }

    @Override
    public MascoptMap clone() {
        MascoptMap result = new MascoptMap();
        Iterator<? extends MascoptObject> it_keys = this.keysIterator();
        while (it_keys.hasNext()) {
            MascoptObject o = it_keys.next();
            Iterator<? extends MascoptObject> contexts = this.contextsIterator(o);
            while (contexts.hasNext()) {
                MascoptObject c = contexts.next();
                Iterator<String> names = this.namesIterator(o, c);
                while (names.hasNext()) {
                    String name = names.next();
                    if (this.getDataType(o, name, c).compareToIgnoreCase("String") == 0) {
                        result.putString(o, name, c, this.getString(o, name, c));
                        continue;
                    }
                    result.putValue(o, name, c, this.getValue(o, name, c));
                }
            }
        }
        return result;
    }

    public static boolean isDefined(Map m, HierarchicalSet<? extends MascoptObject> s, String name, Object context) {
        for (Object e : s) {
            if (m.contains(e, name, context == null ? e : context)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDefined(Map m, HierarchicalSet<? extends MascoptObject> s, Object context) {
        for (Object e : s) {
            Iterator<String> namesIt = m.namesIterator(e, context == null ? e : context);
            if (namesIt.hasNext()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(MascoptObservableObject observable, Notification message) {
    }

    private class ContextIterator
    implements Iterator<MascoptObject> {
        private Iterator<MascoptObject> realIterator;
        private MascoptObject key;
        private MascoptObject lastContextReturned = null;

        public ContextIterator(MascoptObject o) {
            this.key = o;
            this.realIterator = ((HashMap)MascoptMap.this.relations.get(o)).keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.realIterator.hasNext();
        }

        @Override
        public MascoptObject next() {
            this.lastContextReturned = this.realIterator.next();
            return this.lastContextReturned;
        }

        @Override
        public void remove() {
            NameIterator nameIt = new NameIterator(this.key, this.lastContextReturned);
            while (nameIt.hasNext()) {
                nameIt.next();
                nameIt.remove();
            }
        }
    }

    private class ContextWithNameIterator
    implements Iterator<MascoptObject> {
        private HashMap<MascoptObject, Vector<Pair<String, Object>>> subRelation = null;
        private Iterator<? extends MascoptObject> cIterator = null;
        private String name;
        private MascoptObject nextContext = null;
        private long expectedModCount;
        private Object key;
        private MascoptObject lastContext;
        private Vector<Pair<String, Object>> lastNamedValues;
        private int indexOfLastName;
        private boolean findNextCalled;

        private boolean findNext() {
            this.findNextCalled = true;
            while (this.cIterator != null && this.cIterator.hasNext()) {
                this.nextContext = this.cIterator.next();
                this.lastNamedValues = this.subRelation.get(this.nextContext);
                int i = 0;
                while (i < this.lastNamedValues.size()) {
                    if (this.lastNamedValues.get(i).getKey().equals(this.name)) {
                        this.indexOfLastName = i;
                        return true;
                    }
                    ++i;
                }
            }
            this.nextContext = null;
            return false;
        }

        ContextWithNameIterator(Object o, String n) {
            this.expectedModCount = MascoptMap.this.modCount;
            this.name = n;
            this.key = o;
            if (MascoptMap.this.relations.containsKey(o)) {
                this.subRelation = (HashMap)MascoptMap.this.relations.get(o);
                this.cIterator = ((HashMap)MascoptMap.this.relations.get(o)).keySet().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.findNextCalled) {
                return this.findNext();
            }
            return this.nextContext != null;
        }

        @Override
        public MascoptObject next() {
            if (MascoptMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextContext == null) {
                this.findNext();
            }
            this.findNextCalled = false;
            this.lastContext = this.nextContext;
            this.nextContext = null;
            return this.lastContext;
        }

        @Override
        public void remove() {
            MascoptMap.this.notifyRemove(this.key, this.lastNamedValues.get(this.indexOfLastName).getKey(), this.lastContext);
            this.lastNamedValues.remove(this.indexOfLastName);
            if (this.lastNamedValues.size() == 0) {
                this.subRelation.remove(this.lastContext);
                if (this.subRelation.keySet().size() == 0) {
                    MascoptMap.this.relations.remove(this.key);
                }
            }
        }
    }

    private class IteratorWithoutRemove<E>
    implements Iterator<E> {
        Iterator<E> realIt;

        public IteratorWithoutRemove(Iterator<E> it) {
            this.realIt = it;
        }

        @Override
        public boolean hasNext() {
            return this.realIt.hasNext();
        }

        @Override
        public E next() {
            return this.realIt.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class NameIterator
    implements Iterator<String> {
        private MascoptObject key;
        private MascoptObject context;
        private Vector<Pair<String, Object>> namedValue;
        private int index = 0;
        private long expectedModCount;

        NameIterator(MascoptObject o, MascoptObject c) {
            HashMap subRelation;
            this.expectedModCount = MascoptMap.this.modCount;
            this.key = o;
            this.context = c;
            if (MascoptMap.this.relations.containsKey(o) && (subRelation = (HashMap)MascoptMap.this.relations.get(o)).containsKey(c)) {
                this.namedValue = (Vector)subRelation.get(c);
                return;
            }
            this.namedValue = new Vector();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.namedValue.size();
        }

        @Override
        public String next() {
            if (MascoptMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.namedValue.get(this.index++).getKey();
        }

        @Override
        public void remove() {
            if (MascoptMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            MascoptMap.this.notifyRemove(this.key, this.namedValue.get(--this.index).getKey(), this.context);
            this.namedValue.remove(this.index);
            if (this.namedValue.size() == 0) {
                HashMap subRelation = (HashMap)MascoptMap.this.relations.get(this.key);
                subRelation.remove(this.context);
                if (subRelation.keySet().size() == 0) {
                    MascoptMap.this.relations.remove(this.key);
                }
            }
        }
    }
}

