/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptEdgeSet;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.Notification;
import mascoptLib.numeric.MascoptInteger;

public class MascoptMapTest
extends TestCase {
    private static int idGenerator = 0;
    private static final int NB_VERTEX = 20;
    private static final String VALUE_1 = "VALUE_1";
    private MascoptVertex[] vertices;
    private MascoptEdge[] edges;
    private MascoptVertexSet vertexSet;
    private MascoptEdgeSet edgeSet;
    private MascoptGraph graph;
    private MascoptMap map;
    private NotificationVerificator verif;

    protected void setUp() throws Exception {
        super.setUp();
        this.map = new MascoptMap();
        this.vertexSet = new MascoptVertexSet();
        this.edgeSet = new MascoptEdgeSet(this.vertexSet);
        this.graph = new MascoptGraph(this.edgeSet);
        this.vertices = new MascoptVertex[20];
        int i = 0;
        while (i < 20) {
            this.vertices[i] = new MascoptVertex();
            ++i;
        }
        this.edges = new MascoptEdge[400];
        i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                this.edges[i * 20 + j] = new MascoptEdge(this.vertices[i], this.vertices[j]);
                ++j;
            }
            ++i;
        }
        this.vertexSet.add(this.edges[0].getVertices()[0]);
        this.vertexSet.add(this.edges[0].getVertices()[1]);
        this.vertexSet.add(this.edges[1].getVertices()[0]);
        this.vertexSet.add(this.edges[1].getVertices()[1]);
        this.graph = new MascoptGraph(this.edgeSet);
        this.graph.addEdge(this.edges[0]);
        this.graph.addEdge(this.edges[1]);
        i = 0;
        while (i < 20) {
            this.map.putValue(this.vertices[i], VALUE_1, this.vertices[i], new MascoptInteger(i));
            ++i;
        }
        i = 0;
        while (i < 400) {
            this.map.putString(this.edges[i], VALUE_1, "" + i);
            ++i;
        }
        this.verif = new NotificationVerificator();
        this.map.addRemoveObserver(this.verif);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.vertices = null;
        this.edges = null;
        this.vertexSet = null;
        this.edgeSet = null;
        this.graph = null;
        this.map.clear();
        this.map = null;
    }

    private boolean verifyMapContent(MascoptMap m, Object[] v, Object context) {
        int i = 0;
        while (i < v.length) {
            Object currentKey = v[i];
            if (!m.contains(currentKey, VALUE_1, context == null ? currentKey : context)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void testContainsObjectStringObject() {
        int i = 0;
        while (i < 20) {
            MascoptMapTest.assertTrue((boolean)this.map.contains(this.vertices[i], VALUE_1, this.vertices[i]));
            ++i;
        }
    }

    public void testContainsObjectString() {
        int i = 0;
        while (i < 400) {
            MascoptMapTest.assertTrue((boolean)this.map.contains(this.edges[i], VALUE_1));
            ++i;
        }
    }

    public void testContainsObject() {
        int i = 0;
        while (i < 20) {
            MascoptMapTest.assertTrue((boolean)this.map.contains(this.vertices[i]));
            ++i;
        }
        i = 0;
        while (i < 400) {
            MascoptMapTest.assertTrue((boolean)this.map.contains(this.edges[i]));
            ++i;
        }
    }

    public void testContextsIteratorObjectString() {
        Iterator<? extends MascoptObject> it;
        int i = 0;
        while (i < 20) {
            it = this.map.contextsIterator(this.vertices[i], VALUE_1);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            ++i;
        }
        i = 0;
        while (i < 400) {
            it = this.map.contextsIterator(this.edges[i], VALUE_1);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            ++i;
        }
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.vertices, null));
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.edges, null));
    }

    public void testContextsIteratorObject() {
        Iterator<? extends MascoptObject> it;
        int i = 0;
        while (i < 20) {
            it = this.map.contextsIterator(this.vertices[i]);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            ++i;
        }
        i = 0;
        while (i < 400) {
            it = this.map.contextsIterator(this.edges[i]);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            ++i;
        }
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.vertices, null));
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.edges, null));
    }

    public void testGetDataTypeObjectStringObject() {
        int i = 0;
        while (i < 20) {
            MascoptMapTest.assertTrue((this.map.getDataType(this.vertices[i], VALUE_1, this.vertices[i]).compareTo("MascoptInteger") == 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testGetDataTypeObjectString() {
        int i = 0;
        while (i < 400) {
            MascoptMapTest.assertTrue((this.map.getDataType(this.edges[i], VALUE_1).compareTo("String") == 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testGetValueObjectStringObject() {
        int i = 0;
        while (i < 20) {
            MascoptMapTest.assertTrue((this.map.getValue(this.vertices[i], VALUE_1, this.vertices[i]).intValue() == i ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testGetValueObjectString() {
        int i = 0;
        while (i < 20) {
            MascoptMapTest.assertTrue((this.map.getValue(this.vertices[i], VALUE_1).intValue() == i ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testGetStringObjectStringObject() {
        int i = 0;
        while (i < 400) {
            MascoptMapTest.assertTrue((this.map.getString(this.edges[i], VALUE_1, this.edges[i]).compareTo("" + i) == 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testGetStringObjectString() {
        int i = 0;
        while (i < 400) {
            MascoptMapTest.assertTrue((this.map.getString(this.edges[i], VALUE_1).compareTo("" + i) == 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testKeysIterator() {
        int size = 0;
        HashSet<MascoptObject> keySet = new HashSet<MascoptObject>();
        Iterator<? extends MascoptObject> it = this.map.keysIterator();
        while (it.hasNext()) {
            MascoptObject currentKey = it.next();
            MascoptMapTest.assertFalse((boolean)keySet.contains(currentKey));
            keySet.add(currentKey);
            ++size;
        }
        MascoptMapTest.assertTrue((keySet.size() == size ? 1 : 0) != 0);
    }

    public void testNamesIteratorObjectObject() {
        Iterator<String> it;
        int i = 0;
        while (i < 20) {
            it = this.map.namesIterator(this.vertices[i], this.vertices[i]);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            ++i;
        }
        i = 0;
        while (i < 400) {
            it = this.map.namesIterator(this.edges[i], this.edges[i]);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            ++i;
        }
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.vertices, null));
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.edges, null));
    }

    public void testNamesIteratorObject() {
        Iterator<String> it;
        int i = 0;
        while (i < 20) {
            it = this.map.namesIterator(this.vertices[i]);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            ++i;
        }
        i = 0;
        while (i < 400) {
            it = this.map.namesIterator(this.edges[i]);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            ++i;
        }
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.vertices, null));
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.edges, null));
    }

    public void testPutAllMapStringObject() {
    }

    public void testPutAllMapString() {
    }

    public void testRemoveObjectStringObject() {
        int i = 0;
        while (i < 400) {
            this.map.remove(this.edges[i], VALUE_1, this.edges[i]);
            ++i;
        }
        i = 0;
        while (i < 400) {
            MascoptMapTest.assertFalse((boolean)this.map.contains(this.edges[i], VALUE_1, this.edges[i]));
            ++i;
        }
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.edges, null));
    }

    public void testRemoveObjectString() {
        int i = 0;
        while (i < 400) {
            this.map.remove(this.edges[i], VALUE_1);
            ++i;
        }
        i = 0;
        while (i < 400) {
            MascoptMapTest.assertFalse((boolean)this.map.contains(this.edges[i], VALUE_1));
            ++i;
        }
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.edges, null));
    }

    public void testRemoveAllObject() {
        int i = 0;
        while (i < 400) {
            this.map.removeAll(this.edges[i]);
            ++i;
        }
        i = 0;
        while (i < 400) {
            MascoptMapTest.assertFalse((boolean)this.map.contains(this.edges[i], VALUE_1));
            ++i;
        }
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.edges, null));
    }

    public void testRemoveAllObjectObject() {
        int i = 0;
        while (i < 400) {
            this.map.removeAll(this.edges[i], this.edges[i]);
            ++i;
        }
        i = 0;
        while (i < 400) {
            MascoptMapTest.assertFalse((boolean)this.map.contains(this.edges[i], VALUE_1));
            ++i;
        }
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.edges, null));
    }

    public void testClear() {
        this.map.clear();
        MascoptMapTest.assertFalse((boolean)this.map.keysIterator().hasNext());
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.edges, null));
        MascoptMapTest.assertTrue((boolean)this.verifyMapContent(this.verif.getMascoptMapCopy(), this.vertices, null));
    }

    private class NotificationVerificator
    extends MascoptObject {
        private MascoptMap copy;

        public NotificationVerificator() {
            StringBuilder stringBuilder = new StringBuilder("NV");
            int n = idGenerator;
            idGenerator = n + 1;
            super(stringBuilder.append(n).toString());
            this.copy = new MascoptMap();
        }

        @Override
        public String getDOMTagHierarchy() {
            return null;
        }

        @Override
        public String getDOMTagName() {
            return null;
        }

        @Override
        public void update(MascoptObservableObject observable, Notification message) {
            MascoptObservableObject.MascoptEventType notify = message.getEventType();
            Object[] data = message.getObjects();
            assert (observable == MascoptMapTest.this.map);
            if (notify == MascoptObservableObject.MascoptEventType.ADD) {
                throw new RuntimeException("Map can't send ADD_NOTIFICATION");
            }
            if (notify == MascoptObservableObject.MascoptEventType.REMOVE) {
                if (MascoptMapTest.this.map.getDataType(data[0], (String)data[1], data[2]).equals("String")) {
                    this.copy.putString(data[0], (String)data[1], data[2], MascoptMapTest.this.map.getString(data[0], (String)data[1], data[2]));
                } else {
                    this.copy.putValue(data[0], (String)data[1], data[2], MascoptMapTest.this.map.getValue(data[0], (String)data[1], data[2]));
                }
            } else if (notify != MascoptObservableObject.MascoptEventType.VALUE_CHANGE) {
                throw new RuntimeException("The notification message :" + (Object)((Object)notify) + " is unknow");
            }
        }

        @Override
        protected MascoptObject clone() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Clone not supported by this class");
        }

        MascoptMap getMascoptMapCopy() {
            return this.copy;
        }
    }
}

