/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import java.util.StringTokenizer;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.Notification;
import mascoptLib.core.interfaces.MascoptObjectInterface;
import mascoptLib.core.interfaces.MascoptObserver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class MascoptObject
extends MascoptObservableObject
implements MascoptObjectInterface,
Cloneable,
MascoptObserver {
    private String id_;
    private String name_ = null;
    private int color_ = -1;
    private int cloningCounter = 0;
    private Element xmlNode_;
    private Document currentDocument_ = null;

    protected MascoptObject(String id) {
        this.id_ = id;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public String getName() {
        if (this.name_ != null) {
            return this.name_;
        }
        return this.getId();
    }

    @Override
    public boolean setName(String name) {
        this.name_ = name;
        Object[] t = new Object[]{this, "name"};
        this.notifyValueObservers(t);
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public int getColor() {
        return this.color_;
    }

    public boolean setColor(int color) {
        this.color_ = color;
        Object[] t = new Object[]{this, "color"};
        this.notifyValueObservers(t);
        return true;
    }

    @Override
    protected MascoptObject clone() {
        try {
            MascoptObject copy = (MascoptObject)super.clone();
            copy.id_ = String.valueOf(this.id_) + "_Clone_" + this.cloningCounter++;
            copy.currentDocument_ = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Element toDOMTree(Element element) {
        StringTokenizer st = new StringTokenizer(this.getDOMTagHierarchy(), "/");
        Element current_element = element;
        if (this.currentDocument_ != element.getOwnerDocument()) {
            this.currentDocument_ = element.getOwnerDocument();
            while (st.hasMoreTokens()) {
                current_element = this.existOrCreateNodeWithoutId(st.nextToken(), current_element);
            }
            this.xmlNode_ = current_element.getOwnerDocument().createElement(this.getDOMTagName());
            current_element.appendChild(this.xmlNode_);
            this.xmlNode_.setAttribute("id", this.getId());
            if (!this.getId().equals(this.getName())) {
                Element nameNode = this.currentDocument_.createElement("NAME");
                Text nameValue = this.currentDocument_.createTextNode(this.getName());
                nameNode.appendChild(nameValue);
                this.xmlNode_.appendChild(nameNode);
            }
        }
        return this.xmlNode_;
    }

    private Element existOrCreateNodeWithoutId(String tag, Element fromHere) {
        Element new_node = null;
        NodeList nodes = fromHere.getElementsByTagName(tag);
        if (nodes.getLength() == 0) {
            new_node = fromHere.getOwnerDocument().createElement(tag);
            fromHere.appendChild(new_node);
        } else {
            new_node = (Element)nodes.item(0);
        }
        return new_node;
    }

    public final void toDOMTreeAsRef(Element element) {
        Element new_node = element.getOwnerDocument().createElement(String.valueOf(this.getDOMTagName()) + "_REF");
        element.appendChild(new_node);
        new_node.setAttribute("idref", this.getId());
        if (this.currentDocument_ != element.getOwnerDocument()) {
            this.toDOMTree(element.getOwnerDocument().getDocumentElement());
            this.currentDocument_ = element.getOwnerDocument();
        }
    }

    public abstract String getDOMTagHierarchy();

    public abstract String getDOMTagName();

    @Override
    public abstract void update(MascoptObservableObject var1, Notification var2);
}

