/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core.flows;

import bridge.abstractClasses.AbstractScalar;
import bridge.interfaces.Flow;
import bridge.interfaces.Graph;
import bridge.interfaces.MultiFlow;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.Notification;
import mascoptLib.core.flows.MascoptFlow;
import mascoptLib.numeric.MascoptDouble;
import org.w3c.dom.Element;

public class MascoptMultiFlow
extends MascoptObject
implements MultiFlow<MascoptVertex, MascoptArc> {
    private MascoptDiGraph supportingGraph;
    private Vector<MascoptVertex> sources = new Vector();
    private Vector<MascoptVertex> destinations = new Vector();
    private Vector<Flow<MascoptVertex, MascoptArc>> flows = new Vector();
    private static int idGenerator = 0;

    public MascoptMultiFlow(MascoptDiGraph g) {
        super("MF" + idGenerator++);
        this.supportingGraph = g;
    }

    @Override
    public void addFlow(Flow<MascoptVertex, MascoptArc> f) {
        this.flows.add(f);
        this.sources.add(f.getSource());
        this.destinations.add(f.getDestination());
    }

    @Override
    public Iterator<MascoptVertex> sourceIterator() {
        return new IteratorWithoutRemove<MascoptVertex>(this.sources.iterator());
    }

    @Override
    public Iterator<MascoptVertex> destinationIterator() {
        return new IteratorWithoutRemove<MascoptVertex>(this.destinations.iterator());
    }

    @Override
    public Iterator<MascoptArc> edgeWithFlowIterator() {
        return new EdgeIteratorOverFlow();
    }

    @Override
    public AbstractScalar getFlow(MascoptArc e) {
        AbstractScalar result = null;
        for (MascoptFlow mascoptFlow : this.flows) {
            if (result == null) {
                result = mascoptFlow.getFlow(e).clone();
                continue;
            }
            result.add(mascoptFlow.getFlow(e));
        }
        if (result == null) {
            return new MascoptDouble(0.0);
        }
        return result;
    }

    @Override
    public Flow<MascoptVertex, MascoptArc> getFlow(MascoptVertex source, MascoptVertex destination) {
        int i = 0;
        while (i < this.flows.size()) {
            if (this.sources.get(i) == source && this.destinations.get(i) == destination) {
                return this.flows.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public AbstractScalar getIncomingFlow(MascoptVertex v) {
        int index = this.destinations.indexOf(v);
        if (index != -1) {
            return this.flows.get(index).getIncomingFlow(v);
        }
        return new MascoptDouble(0.0);
    }

    @Override
    public AbstractScalar getOutgoingFlow(MascoptVertex v) {
        int index = this.sources.indexOf(v);
        if (index != -1) {
            return this.flows.get(index).getIncomingFlow(v);
        }
        return new MascoptDouble(0.0);
    }

    @Override
    public Graph<MascoptVertex, MascoptArc> getSupportingGraph() {
        return this.supportingGraph;
    }

    @Override
    public MascoptFlow clone() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean verify() {
        for (MascoptVertex currentVertex : this.supportingGraph.vertexSet()) {
            double flowValue = 0.0;
            Iterator inEdgeIt = this.supportingGraph.inEdges(currentVertex).iterator();
            while (inEdgeIt.hasNext()) {
                flowValue += this.getFlow((MascoptArc)inEdgeIt.next()).doubleValue();
            }
            Iterator outEdgeIt = this.supportingGraph.outEdges(currentVertex).iterator();
            while (outEdgeIt.hasNext()) {
                flowValue += this.getFlow((MascoptArc)outEdgeIt.next()).doubleValue();
            }
            if (flowValue == this.getIncomingFlow(currentVertex).doubleValue() - this.getOutgoingFlow(currentVertex).doubleValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Element toDOMTree(Element element) {
        Element flowNode = super.toDOMTree(element);
        this.supportingGraph.toDOMTreeAsRef(flowNode);
        Element flowsNode = flowNode.getOwnerDocument().createElement("FLOW_REF");
        flowNode.appendChild(flowsNode);
        for (MascoptFlow mascoptFlow : this.flows) {
            mascoptFlow.toDOMTreeAsRef(flowsNode);
        }
        return flowNode;
    }

    @Override
    public String getDOMTagHierarchy() {
        return "FLOWS";
    }

    @Override
    public String getDOMTagName() {
        return "MULTIFLOW";
    }

    @Override
    public void update(MascoptObservableObject observable, Notification message) {
    }

    private class EdgeIteratorOverFlow
    implements Iterator<MascoptArc> {
        private Iterator<Flow<MascoptVertex, MascoptArc>> flowsIt;
        private Iterator<MascoptArc> currentFlowIt = null;

        public EdgeIteratorOverFlow() {
            this.flowsIt = MascoptMultiFlow.this.flows.iterator();
        }

        @Override
        public boolean hasNext() {
            while ((this.currentFlowIt == null || !this.currentFlowIt.hasNext()) && this.flowsIt.hasNext()) {
                this.currentFlowIt = this.flowsIt.next().edgeWithFlowIterator();
                if (!this.currentFlowIt.hasNext()) continue;
                return this.currentFlowIt.hasNext();
            }
            return false;
        }

        @Override
        public MascoptArc next() {
            if (this.hasNext()) {
                return this.currentFlowIt.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing source or destination of a flow is forbiden");
        }
    }

    private class IteratorWithoutRemove<T extends MascoptObject>
    implements Iterator<T> {
        Iterator<T> realIt;

        IteratorWithoutRemove(Iterator<T> realIt) {
            this.realIt = realIt;
        }

        @Override
        public boolean hasNext() {
            return this.realIt.hasNext();
        }

        @Override
        public T next() {
            return (T)((MascoptObject)this.realIt.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing source or destination of a flow is forbiden");
        }
    }
}

