/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.actions;

import bridge.interfaces.Link;
import java.util.ArrayList;
import java.util.Random;
import mascoptLib.graphgenerator.actions.ActionOnGraph;
import mascoptLib.graphgenerator.actions.ChanceGenerator;
import mascoptLib.graphgenerator.actions.SimpleChanceGenerator;

public class PositiveNegativeChanceGenerator<V, E extends Link<V>>
implements ChanceGenerator<V, E> {
    private final Random random_ = new Random();
    private SimpleChanceGenerator<V, E> positive_;
    private SimpleChanceGenerator<V, E> negative_;

    public PositiveNegativeChanceGenerator(ArrayList<ActionOnGraph<V, E>> positiveActions, ArrayList<ActionOnGraph<V, E>> negativeActions) {
        this.positive_ = new SimpleChanceGenerator<V, E>(positiveActions);
        this.negative_ = new SimpleChanceGenerator<V, E>(negativeActions);
        assert (this.iAmConsistent());
    }

    private boolean iAmConsistent() {
        for (ActionOnGraph<V, E> action : this.positive_.getActions()) {
            if (action.getClass() != ActionOnGraph.InverseAction.class) continue;
            return false;
        }
        for (ActionOnGraph<V, E> action : this.negative_.getActions()) {
            if (action.getClass() == ActionOnGraph.InverseAction.class) continue;
            return false;
        }
        return true;
    }

    private SimpleChanceGenerator<V, E> getRightOne(ActionOnGraph<V, E> action) {
        if (action.getClass() == ActionOnGraph.InverseAction.class) {
            return this.negative_;
        }
        return this.positive_;
    }

    @Override
    public void choosed(ActionOnGraph<V, E> action) {
        assert (this.iAmConsistent());
        this.getRightOne(action).choosed(action);
        assert (this.iAmConsistent());
    }

    @Override
    public void swapChances(ActionOnGraph<V, E> action1, ActionOnGraph<V, E> action2) {
        SimpleChanceGenerator<V, E> generator2;
        assert (this.iAmConsistent());
        SimpleChanceGenerator<V, E> generator1 = this.getRightOne(action1);
        if (generator1 == (generator2 = this.getRightOne(action2))) {
            generator1.swapChances(action1, action2);
        } else {
            generator1.choosed(action1);
            generator2.addChance(action2);
        }
        assert (this.iAmConsistent());
    }

    @Override
    public void repeatChoices() {
        assert (this.iAmConsistent());
        this.positive_.repeatChoices();
        this.negative_.repeatChoices();
        assert (this.iAmConsistent());
    }

    @Override
    public ActionOnGraph<V, E> getNext() {
        assert (this.iAmConsistent());
        SimpleChanceGenerator<V, E> generator1 = this.positive_;
        SimpleChanceGenerator<V, E> generator2 = this.positive_;
        if (this.random_.nextBoolean()) {
            generator1 = this.negative_;
        } else {
            generator2 = this.negative_;
        }
        ActionOnGraph<V, E> action = generator1.getNext();
        if (action != null) {
            return action;
        }
        return generator2.getNext();
    }

    @Override
    public void addChance(ActionOnGraph<V, E> action) {
        assert (this.iAmConsistent());
        this.getRightOne(action).addChance(action);
        assert (this.iAmConsistent());
    }
}

