/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.actions;

import bridge.interfaces.Graph;
import bridge.interfaces.HierarchicalSet;
import bridge.interfaces.Link;
import mascoptLib.graphgenerator.actions.ActionOnGraph;

public class RemoveLinkOnGraph<V, E extends Link<V>>
extends ActionOnGraph<V, E> {
    protected E link_;
    protected V v1_;
    protected V v2_;

    public RemoveLinkOnGraph(E link) {
        this.link_ = link;
    }

    public RemoveLinkOnGraph(V v1, V v2) {
        this.v1_ = v1;
        this.v2_ = v2;
    }

    @Override
    public void apply(Graph<V, E> graph) {
        if (this.link_ == null) {
            HierarchicalSet<E> linkSet = graph.getEdgesConnected(this.v1_, this.v2_);
            assert (linkSet.size() == 1);
            this.link_ = (Link)linkSet.iterator().next();
        }
        graph.removeEdge(this.link_);
    }

    @Override
    public void unApply(Graph<V, E> graph) {
        if (this.link_ == null) {
            graph.addEdge(this.v1_, this.v2_);
            HierarchicalSet<E> linkSet = graph.getEdgesConnected(this.v1_, this.v2_);
            assert (linkSet.size() == 1);
            this.link_ = (Link)linkSet.iterator().next();
        } else {
            graph.addEdge(this.link_);
        }
    }
}

