/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.criterium;

import bridge.interfaces.Link;
import mascoptLib.graphgenerator.criterium.AroundCriterion;
import mascoptLib.graphgenerator.criterium.AtLeastCriterion;
import mascoptLib.graphgenerator.criterium.AtMostCriterion;
import mascoptLib.graphgenerator.criterium.FitnessCriterion;
import mascoptLib.graphgenerator.numericproperty.common.AverageDegreeComputator;
import mascoptLib.graphgenerator.numericproperty.common.AverageDistanceComputator;
import mascoptLib.graphgenerator.numericproperty.common.DiameterComputator;
import mascoptLib.graphgenerator.numericproperty.common.LinkNoComputator;
import mascoptLib.graphgenerator.numericproperty.common.MaximalDegreeComputator;
import mascoptLib.graphgenerator.numericproperty.common.StandardDeviationComputator;

public class CriterionFactory<V, L extends Link<V>> {
    public FitnessCriterion<V, L> getAroundDiameter(double expectedValue, double scaleFactor) {
        return new AroundCriterion(new DiameterComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtLeastDiameter(double expectedValue, double scaleFactor) {
        return new AtLeastCriterion(new DiameterComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtMostDiameter(double expectedValue, double scaleFactor) {
        return new AtMostCriterion(new DiameterComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAroundAverageVertexDegree(double expectedValue, double scaleFactor) {
        return new AroundCriterion(new AverageDegreeComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtLeastAverageVertexDegree(double expectedValue, double scaleFactor) {
        return new AtLeastCriterion(new AverageDegreeComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtMostAverageVertexDegree(double expectedValue, double scaleFactor) {
        return new AtMostCriterion(new AverageDegreeComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAroundVertexStandardDeviation(double expectedValue, double scaleFactor) {
        return new AroundCriterion(new StandardDeviationComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtLeastVertexStandardDeviation(double expectedValue, double scaleFactor) {
        return new AtLeastCriterion(new StandardDeviationComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtMostVertexStandardDeviation(double expectedValue, double scaleFactor) {
        return new AtMostCriterion(new StandardDeviationComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAroundLinkNo(double expectedValue, double scaleFactor) {
        return new AroundCriterion(new LinkNoComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtLeastLinkNo(double expectedValue, double scaleFactor) {
        return new AtLeastCriterion(new LinkNoComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtMostLinkNo(double expectedValue, double scaleFactor) {
        return new AtMostCriterion(new LinkNoComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAroundAverageDistance(double expectedValue, double scaleFactor) {
        return new AroundCriterion(new AverageDistanceComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtLeastAverageDistance(double expectedValue, double scaleFactor) {
        return new AtLeastCriterion(new AverageDistanceComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtMostAverageDistance(double expectedValue, double scaleFactor) {
        return new AtMostCriterion(new AverageDistanceComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAroundMaximalDegree(double expectedValue, double scaleFactor) {
        return new AroundCriterion(new MaximalDegreeComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtLeastMaximalDegree(double expectedValue, double scaleFactor) {
        return new AtLeastCriterion(new MaximalDegreeComputator(), expectedValue, scaleFactor);
    }

    public FitnessCriterion<V, L> getAtMostMaximalDegree(double expectedValue, double scaleFactor) {
        return new AtMostCriterion(new MaximalDegreeComputator(), expectedValue, scaleFactor);
    }
}

