/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.criterium;

import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import mascoptLib.graphgenerator.criterium.FitnessCriterion;
import mascoptLib.graphgenerator.numericproperty.NumericPropriertyComputator;

public abstract class WrapperCriterion<V, L extends Link<V>>
implements FitnessCriterion<V, L> {
    protected NumericPropriertyComputator<V, L> criterion_;
    protected double expectedValue_;
    protected double scaleFactor_;

    public WrapperCriterion(NumericPropriertyComputator<V, L> criterion, double expectedValue, double scaleFactor) {
        this.criterion_ = criterion;
        this.expectedValue_ = expectedValue;
        this.scaleFactor_ = scaleFactor;
    }

    private boolean checkUpperBound(double value, double expectedValue, double scaleFactor) {
        assert (Math.tanh(Math.abs(value - expectedValue) * scaleFactor * 0.001) < 0.999999) : "collapsed values on" + Math.abs(value - expectedValue) * scaleFactor * 0.001;
        return true;
    }

    protected double normalizeValue(double value, double expectedValue, double scaleFactor) {
        assert (this.checkUpperBound(value, expectedValue, scaleFactor));
        return Math.tanh(Math.abs(value - expectedValue) * scaleFactor * 0.001);
    }

    public String toString() {
        return "(class: " + this.getClass().getSimpleName() + ") with \n --[computator: " + this.criterion_ + "; expectedValue: " + this.expectedValue_ + "; scaleFactor: " + this.scaleFactor_ + "]";
    }

    @Override
    public abstract double compute(Graph<V, L> var1);
}

