/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.numericproperty.common;

import bridge.interfaces.Link;
import java.util.HashSet;
import mascoptLib.graphgenerator.numericproperty.SimpleComputator;
import mascoptLib.numeric.MascoptDouble;
import tools.dataStructures.Fifo;

public class AverageDistanceComputator<V, E extends Link<V>>
extends SimpleComputator<V, E> {
    HashSet<V> visitedVertices_;
    protected int resultMean_ = 0;

    @Override
    public void compute() {
        this.resultMean_ = 0;
        this.visitedVertices_ = new HashSet(this.graph_.vertexSet().size() * 2);
        for (Object vertex : this.graph_.vertexSet()) {
            this.visitedVertices_.clear();
            this.maxDistance(vertex);
            if (this.visitedVertices_.size() == this.graph_.vertexSet().size()) continue;
            this.result_ = null;
            return;
        }
        this.result_ = new MascoptDouble((double)this.resultMean_ / (Math.pow(this.graph_.vertexSet().size(), 2.0) - (double)this.graph_.vertexSet().size()));
    }

    protected int maxDistance(V rootVertex) {
        int resultDiameter = 0;
        int roundSize = 0;
        Fifo fifo = new Fifo();
        Object specialVertex = null;
        this.visitedVertices_.add(rootVertex);
        fifo.put(specialVertex);
        Object actualVertex = rootVertex;
        while (true) {
            if (actualVertex == specialVertex) {
                this.resultMean_ += roundSize * (++resultDiameter - 1);
                roundSize = 0;
                if (fifo.isEmpty()) {
                    return resultDiameter - 1;
                }
                fifo.put(specialVertex);
            } else {
                assert (this.visitedVertices_.contains(actualVertex));
                ++roundSize;
                for (Object outVertex : this.graph_.outNeighborhood(actualVertex)) {
                    if (!this.visitedVertices_.add(outVertex)) continue;
                    fifo.put(outVertex);
                }
            }
            actualVertex = fifo.get();
        }
    }
}

